/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSpout;
import com.simibubi.create.content.contraptions.fluids.actors.FillingRecipe;
import com.simibubi.create.content.contraptions.fluids.actors.GenericItemFilling;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.PotionItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SpoutCategory
extends CreateRecipeCategory<FillingRecipe> {
    AnimatedSpout spout = new AnimatedSpout();

    public SpoutCategory() {
        super(SpoutCategory.doubleItemIcon((IItemProvider)AllBlocks.SPOUT.get(), (IItemProvider)Items.field_151131_as), SpoutCategory.emptyBackground(177, 70));
    }

    public static List<FillingRecipe> getRecipes(IIngredientManager ingredientManager) {
        ArrayList<FillingRecipe> recipes = new ArrayList<FillingRecipe>();
        ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().forEach(stack -> {
            if (stack.func_77973_b() instanceof PotionItem) {
                FluidStack fluidFromPotionItem = PotionFluidHandler.getFluidFromPotionItem(stack);
                Ingredient bottle = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151069_bo});
                recipes.add(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("potions")).withItemIngredients(bottle).withFluidIngredients(FluidIngredient.fromFluidStack(fluidFromPotionItem)).withSingleItemOutput((ItemStack)stack).build());
                return;
            }
            LazyOptional capability = stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!capability.isPresent()) {
                return;
            }
            ingredientManager.getAllIngredients(VanillaTypes.FLUID).stream().forEach(fluidStack -> {
                ItemStack copy = stack.func_77946_l();
                copy.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(fhi -> {
                    if (!GenericItemFilling.isFluidHandlerValid(copy, fhi)) {
                        return;
                    }
                    FluidStack fluidCopy = fluidStack.copy();
                    fluidCopy.setAmount(1000);
                    fhi.fill(fluidCopy, IFluidHandler.FluidAction.EXECUTE);
                    ItemStack container = fhi.getContainer();
                    if (container.func_77969_a(copy)) {
                        return;
                    }
                    if (container.func_190926_b()) {
                        return;
                    }
                    Ingredient bucket = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack});
                    ResourceLocation itemName = stack.func_77973_b().getRegistryName();
                    ResourceLocation fluidName = fluidCopy.getFluid().getRegistryName();
                    recipes.add(new ProcessingRecipeBuilder<FillingRecipe>(FillingRecipe::new, Create.asResource("fill_" + itemName.func_110624_b() + "_" + itemName.func_110623_a() + "_with_" + fluidName.func_110624_b() + "_" + fluidName.func_110623_a())).withItemIngredients(bucket).withFluidIngredients(FluidIngredient.fromFluidStack(fluidCopy)).withSingleItemOutput(container).build());
                });
            });
        });
        return recipes;
    }

    public Class<? extends FillingRecipe> getRecipeClass() {
        return FillingRecipe.class;
    }

    public void setIngredients(FillingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.func_192400_c());
        ingredients.setInputLists(VanillaTypes.FLUID, recipe.getFluidIngredients().stream().map(FluidIngredient::getMatchingFluidStacks).collect(Collectors.toList()));
        if (!recipe.getRollableResults().isEmpty()) {
            ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
        }
        if (!recipe.getFluidResults().isEmpty()) {
            ingredients.setOutputs(VanillaTypes.FLUID, recipe.getFluidResults());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, FillingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        FluidIngredient fluidIngredient = recipe.getRequiredFluid();
        List<ItemStack> matchingIngredients = Arrays.asList(((Ingredient)recipe.func_192400_c().get(0)).func_193365_a());
        fluidStacks.init(0, true, 27, 32);
        fluidStacks.set(0, SpoutCategory.withImprovedVisibility(fluidIngredient.getMatchingFluidStacks()));
        itemStacks.init(0, true, 26, 50);
        itemStacks.set(0, matchingIngredients);
        itemStacks.init(1, false, 131, 50);
        itemStacks.set(1, recipe.func_77571_b());
        SpoutCategory.addFluidTooltip(fluidStacks, (List<FluidIngredient>)ImmutableList.of((Object)fluidIngredient), Collections.emptyList());
    }

    public void draw(FillingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26, 31);
        AllGuiTextures.JEI_SLOT.draw(matrixStack, 26, 50);
        SpoutCategory.getRenderedSlot(recipe, 0).draw(matrixStack, 131, 50);
        AllGuiTextures.JEI_SHADOW.draw(matrixStack, 62, 57);
        AllGuiTextures.JEI_DOWN_ARROW.draw(matrixStack, 126, 29);
        this.spout.withFluids(recipe.getRequiredFluid().getMatchingFluidStacks()).draw(matrixStack, this.getBackground().getWidth() / 2 - 13, 22);
    }
}

