/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.crafter;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.base.HorizontalKineticBlock;
import com.simibubi.create.content.contraptions.components.crafter.CrafterHelper;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterBlock;
import com.simibubi.create.content.contraptions.components.crafter.MechanicalCrafterTileEntity;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class ConnectedInputHandler {
    public static boolean shouldConnect(World world, BlockPos pos, Direction face, Direction direction) {
        BlockState refState = world.func_180495_p(pos);
        if (!refState.func_235901_b_(HorizontalKineticBlock.HORIZONTAL_FACING)) {
            return false;
        }
        Direction refDirection = (Direction)refState.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
        if (direction.func_176740_k() == refDirection.func_176740_k()) {
            return false;
        }
        if (face == refDirection) {
            return false;
        }
        BlockState neighbour = world.func_180495_p(pos.func_177972_a(direction));
        if (!AllBlocks.MECHANICAL_CRAFTER.has(neighbour)) {
            return false;
        }
        return refDirection == neighbour.func_177229_b(HorizontalKineticBlock.HORIZONTAL_FACING);
    }

    public static void toggleConnection(World world, BlockPos pos, BlockPos pos2) {
        BlockPos controllerPos2;
        MechanicalCrafterTileEntity crafter1 = CrafterHelper.getCrafter((IBlockDisplayReader)world, pos);
        MechanicalCrafterTileEntity crafter2 = CrafterHelper.getCrafter((IBlockDisplayReader)world, pos2);
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        BlockPos controllerPos1 = crafter1.func_174877_v().func_177971_a((Vector3i)crafter1.input.data.get(0));
        if (controllerPos1.equals((Object)(controllerPos2 = crafter2.func_174877_v().func_177971_a((Vector3i)crafter2.input.data.get(0))))) {
            MechanicalCrafterTileEntity controller = CrafterHelper.getCrafter((IBlockDisplayReader)world, controllerPos1);
            Set<BlockPos> positions = controller.input.data.stream().map(arg_0 -> ((BlockPos)controllerPos1).func_177971_a(arg_0)).collect(Collectors.toSet());
            LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
            ArrayList<BlockPos> splitGroup = new ArrayList<BlockPos>();
            frontier.add(pos2);
            positions.remove(pos2);
            positions.remove(pos);
            while (!frontier.isEmpty()) {
                BlockPos current = (BlockPos)frontier.remove(0);
                for (Direction direction : Iterate.directions) {
                    BlockPos next = current.func_177972_a(direction);
                    if (!positions.remove(next)) continue;
                    splitGroup.add(next);
                    frontier.add(next);
                }
            }
            ConnectedInputHandler.initAndAddAll(world, crafter1, positions);
            ConnectedInputHandler.initAndAddAll(world, crafter2, splitGroup);
            crafter1.func_70296_d();
            crafter1.connectivityChanged();
            crafter2.func_70296_d();
            crafter2.connectivityChanged();
            return;
        }
        if (!crafter1.input.isController) {
            crafter1 = CrafterHelper.getCrafter((IBlockDisplayReader)world, controllerPos1);
        }
        if (!crafter2.input.isController) {
            crafter2 = CrafterHelper.getCrafter((IBlockDisplayReader)world, controllerPos2);
        }
        if (crafter1 == null || crafter2 == null) {
            return;
        }
        ConnectedInputHandler.connectControllers(world, crafter1, crafter2);
        world.func_180501_a(crafter1.func_174877_v(), crafter1.func_195044_w(), 3);
        crafter1.func_70296_d();
        crafter1.connectivityChanged();
        crafter2.func_70296_d();
        crafter2.connectivityChanged();
    }

    public static void initAndAddAll(World world, MechanicalCrafterTileEntity crafter, Collection<BlockPos> positions) {
        crafter.input = new ConnectedInput();
        positions.forEach(splitPos -> ConnectedInputHandler.modifyAndUpdate(world, splitPos, input -> {
            input.attachTo(crafter.func_174877_v(), (BlockPos)splitPos);
            crafter.input.data.add(splitPos.func_177973_b((Vector3i)crafter.func_174877_v()));
        }));
    }

    public static void connectControllers(World world, MechanicalCrafterTileEntity crafter1, MechanicalCrafterTileEntity crafter2) {
        crafter1.input.data.forEach(offset -> {
            BlockPos connectedPos = crafter1.func_174877_v().func_177971_a((Vector3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {});
        });
        crafter2.input.data.forEach(offset -> {
            if (offset.equals((Object)BlockPos.field_177992_a)) {
                return;
            }
            BlockPos connectedPos = crafter2.func_174877_v().func_177971_a((Vector3i)offset);
            ConnectedInputHandler.modifyAndUpdate(world, connectedPos, input -> {
                input.attachTo(crafter1.func_174877_v(), connectedPos);
                crafter1.input.data.add(BlockPos.field_177992_a.func_177973_b((Vector3i)input.data.get(0)));
            });
        });
        crafter2.input.attachTo(crafter1.func_174877_v(), crafter2.func_174877_v());
        crafter1.input.data.add(BlockPos.field_177992_a.func_177973_b((Vector3i)crafter2.input.data.get(0)));
    }

    private static void modifyAndUpdate(World world, BlockPos pos, Consumer<ConnectedInput> callback) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof MechanicalCrafterTileEntity)) {
            return;
        }
        MechanicalCrafterTileEntity crafter = (MechanicalCrafterTileEntity)te;
        callback.accept(crafter.input);
        crafter.func_70296_d();
        crafter.connectivityChanged();
    }

    public static class ConnectedInput {
        boolean isController = true;
        List<BlockPos> data = Collections.synchronizedList(new ArrayList());

        public ConnectedInput() {
            this.data.add(BlockPos.field_177992_a);
        }

        public void attachTo(BlockPos controllerPos, BlockPos myPos) {
            this.isController = false;
            this.data.clear();
            this.data.add(controllerPos.func_177973_b((Vector3i)myPos));
        }

        public IItemHandler getItemHandler(World world, BlockPos pos) {
            if (!this.isController) {
                BlockPos controllerPos = pos.func_177971_a((Vector3i)this.data.get(0));
                ConnectedInput input = CrafterHelper.getInput((IBlockDisplayReader)world, controllerPos);
                if (input == this || input == null || !input.isController) {
                    return new ItemStackHandler();
                }
                return input.getItemHandler(world, controllerPos);
            }
            Direction facing = Direction.SOUTH;
            BlockState blockState = world.func_180495_p(pos);
            if (blockState.func_235901_b_(MechanicalCrafterBlock.HORIZONTAL_FACING)) {
                facing = (Direction)blockState.func_177229_b(MechanicalCrafterBlock.HORIZONTAL_FACING);
            }
            Direction.AxisDirection axisDirection = facing.func_176743_c();
            Direction.Axis compareAxis = facing.func_176746_e().func_176740_k();
            Comparator invOrdering = (p1, p2) -> {
                int compareY = -Integer.compare(p1.func_177956_o(), p2.func_177956_o());
                int modifier = axisDirection.func_179524_a() * (compareAxis == Direction.Axis.Z ? -1 : 1);
                int c1 = compareAxis.func_196052_a(p1.func_177958_n(), p1.func_177956_o(), p1.func_177952_p());
                int c2 = compareAxis.func_196052_a(p2.func_177958_n(), p2.func_177956_o(), p2.func_177952_p());
                return compareY != 0 ? compareY : modifier * Integer.compare(c1, c2);
            };
            List list = this.data.stream().sorted(invOrdering).map(l -> CrafterHelper.getCrafter((IBlockDisplayReader)world, pos.func_177971_a((Vector3i)l))).filter(Objects::nonNull).map(crafter -> crafter.getInventory()).collect(Collectors.toList());
            return new CombinedInvWrapper((IItemHandlerModifiable[])Arrays.copyOf(list.toArray(), list.size(), IItemHandlerModifiable[].class));
        }

        public void write(CompoundNBT nbt) {
            nbt.func_74757_a("Controller", this.isController);
            ListNBT list = new ListNBT();
            this.data.forEach(pos -> list.add((Object)NBTUtil.func_186859_a((BlockPos)pos)));
            nbt.func_218657_a("Data", (INBT)list);
        }

        public void read(CompoundNBT nbt) {
            this.isController = nbt.func_74767_n("Controller");
            this.data.clear();
            nbt.func_150295_c("Data", 10).forEach(inbt -> this.data.add(NBTUtil.func_186861_c((CompoundNBT)((CompoundNBT)inbt))));
        }
    }
}

