/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.bell;

import com.simibubi.create.content.curiosities.bell.SoulBaseParticle;
import com.simibubi.create.content.curiosities.bell.SoulParticle;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class SoulPulseEffect {
    public static final int MAX_DISTANCE = 11;
    private static final List<List<BlockPos>> LAYERS = SoulPulseEffect.genLayers();
    private static final int WAITING_TICKS = 100;
    public static final int TICKS_PER_LAYER = 6;
    private int ticks;
    public final BlockPos pos;
    public final int distance;
    public final List<BlockPos> added;

    public SoulPulseEffect(BlockPos pos, int distance, boolean canOverlap) {
        this.ticks = 6 * distance;
        this.pos = pos;
        this.distance = distance;
        this.added = canOverlap ? null : new ArrayList();
    }

    public boolean finished() {
        return this.ticks <= -100;
    }

    public boolean canOverlap() {
        return this.added == null;
    }

    public List<BlockPos> tick(World world) {
        if (this.finished()) {
            return null;
        }
        --this.ticks;
        if (this.ticks < 0 || this.ticks % 6 != 0) {
            return null;
        }
        List<BlockPos> spawns = this.getPotentialSoulSpawns(world);
        while (spawns.isEmpty() && this.ticks > 0) {
            this.ticks -= 6;
            spawns.addAll(this.getPotentialSoulSpawns(world));
        }
        return spawns;
    }

    public int currentLayerIdx() {
        return this.distance - this.ticks / 6 - 1;
    }

    public List<BlockPos> getPotentialSoulSpawns(World world) {
        if (world == null) {
            return new ArrayList<BlockPos>();
        }
        return SoulPulseEffect.getLayer(this.currentLayerIdx()).map(p -> p.func_177971_a((Vector3i)this.pos)).filter(p -> SoulPulseEffect.canSpawnSoulAt(world, p, true)).collect(Collectors.toList());
    }

    public static boolean isDark(World world, BlockPos at) {
        return world.func_226658_a_(LightType.BLOCK, at) < 8;
    }

    public static boolean canSpawnSoulAt(World world, BlockPos at, boolean ignoreLight) {
        EntityType dummy = EntityType.field_200725_aD;
        double dummyWidth = 0.2;
        double dummyHeight = 0.75;
        double w2 = dummyWidth / 2.0;
        return world != null && WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)at, (EntityType)dummy) && (ignoreLight || SoulPulseEffect.isDark(world, at)) && world.func_241457_a_(null, new AxisAlignedBB((double)at.func_177958_n() + 0.5 - w2, (double)at.func_177956_o(), (double)at.func_177952_p() + 0.5 - w2, (double)at.func_177958_n() + 0.5 + w2, (double)at.func_177956_o() + dummyHeight, (double)at.func_177952_p() + 0.5 + w2), (a, b) -> true).allMatch(VoxelShape::func_197766_b);
    }

    public void spawnParticles(World world, BlockPos at) {
        if (world == null || !world.field_72995_K) {
            return;
        }
        Vector3d p = Vector3d.func_237491_b_((Vector3i)at);
        if (this.canOverlap()) {
            world.func_195589_b((IParticleData)((int)Math.round(VecHelper.getCenterOf((Vector3i)this.pos).func_72438_d(VecHelper.getCenterOf((Vector3i)at))) >= this.distance ? new SoulParticle.PerimeterData() : new SoulParticle.ExpandingPerimeterData()), p.field_72450_a + 0.5, p.field_72448_b + 0.5, p.field_72449_c + 0.5, 0.0, 0.0, 0.0);
        }
        if (world.func_226658_a_(LightType.BLOCK, at) < 8) {
            world.func_195589_b((IParticleData)new SoulParticle.Data(), p.field_72450_a + 0.5, p.field_72448_b + 0.5, p.field_72449_c + 0.5, 0.0, 0.0, 0.0);
            world.func_195594_a((IParticleData)new SoulBaseParticle.Data(), p.field_72450_a + 0.5, p.field_72448_b + 0.01, p.field_72449_c + 0.5, 0.0, 0.0, 0.0);
        }
    }

    private static List<List<BlockPos>> genLayers() {
        ArrayList<List<BlockPos>> layers = new ArrayList<List<BlockPos>>();
        for (int i = 0; i < 11; ++i) {
            layers.add(new ArrayList());
        }
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 11; ++y) {
                for (int z = 0; z < 11; ++z) {
                    BlockPos prev;
                    int i;
                    BlockPos candidate = new BlockPos(x, y, z);
                    int dist = (int)Math.round(Math.sqrt(candidate.func_218140_a(0.0, 0.0, 0.0, false)));
                    if (dist > 11) continue;
                    if (dist <= 0) {
                        dist = 1;
                    }
                    List layer = (List)layers.get(dist - 1);
                    int start = layer.size();
                    int end = start + 1;
                    layer.add(candidate);
                    if (candidate.func_177958_n() != 0) {
                        layer.add(new BlockPos(-candidate.func_177958_n(), candidate.func_177956_o(), candidate.func_177952_p()));
                        ++end;
                    }
                    if (candidate.func_177956_o() != 0) {
                        for (i = start; i < end; ++i) {
                            prev = (BlockPos)layer.get(i);
                            layer.add(new BlockPos(prev.func_177958_n(), -prev.func_177956_o(), prev.func_177952_p()));
                        }
                        end += end - start;
                    }
                    if (candidate.func_177952_p() == 0) continue;
                    for (i = start; i < end; ++i) {
                        prev = (BlockPos)layer.get(i);
                        layer.add(new BlockPos(prev.func_177958_n(), prev.func_177956_o(), -prev.func_177952_p()));
                    }
                }
            }
        }
        return layers;
    }

    public static Stream<BlockPos> getLayer(int idx) {
        if (idx < 0 || idx >= 11) {
            return Stream.empty();
        }
        return LAYERS.get(idx).stream();
    }
}

