/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.toolbox;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.curiosities.toolbox.RadialToolboxMenu;
import com.simibubi.create.content.curiosities.toolbox.ToolboxEquipPacket;
import com.simibubi.create.content.curiosities.toolbox.ToolboxHandler;
import com.simibubi.create.content.curiosities.toolbox.ToolboxInventory;
import com.simibubi.create.content.curiosities.toolbox.ToolboxTileEntity;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.networking.AllPackets;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class ToolboxHandlerClient {
    static int COOLDOWN = 0;

    public static void clientTick() {
        if (COOLDOWN > 0 && !AllKeys.TOOLBELT.isPressed()) {
            --COOLDOWN;
        }
    }

    public static boolean onPickItem() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return false;
        }
        World level = player.field_70170_p;
        RayTraceResult hitResult = mc.field_71476_x;
        if (hitResult == null || hitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return false;
        }
        if (player.func_184812_l_()) {
            return false;
        }
        ItemStack result = ItemStack.field_190927_a;
        List<ToolboxTileEntity> toolboxes = ToolboxHandler.getNearest((IWorld)player.field_70170_p, (PlayerEntity)player, 8);
        if (toolboxes.isEmpty()) {
            return false;
        }
        if (hitResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = ((BlockRayTraceResult)hitResult).func_216350_a();
            BlockState state = level.func_180495_p(pos);
            if (state.func_185904_a() == Material.field_151579_a) {
                return false;
            }
            result = state.getPickBlock(hitResult, (IBlockReader)level, pos, (PlayerEntity)player);
        } else if (hitResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            Entity entity = ((EntityRayTraceResult)hitResult).func_216348_a();
            result = entity.getPickedResult(hitResult);
        }
        if (result.func_190926_b()) {
            return false;
        }
        for (ToolboxTileEntity toolboxTileEntity : toolboxes) {
            ToolboxInventory inventory = toolboxTileEntity.inventory;
            for (int comp = 0; comp < 8; ++comp) {
                ItemStack inSlot = inventory.takeFromCompartment(1, comp, true);
                if (inSlot.func_190926_b() || inSlot.func_77973_b() != result.func_77973_b() || !ItemStack.func_77970_a((ItemStack)inSlot, (ItemStack)result)) continue;
                AllPackets.channel.sendToServer((Object)new ToolboxEquipPacket(toolboxTileEntity.func_174877_v(), comp, player.field_71071_by.field_70461_c));
                return true;
            }
        }
        return false;
    }

    public static void onKeyInput(int key, boolean pressed) {
        String slotKey;
        if (key != AllKeys.TOOLBELT.getBoundCode()) {
            return;
        }
        if (COOLDOWN > 0) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World level = player.field_70170_p;
        List<ToolboxTileEntity> toolboxes = ToolboxHandler.getNearest((IWorld)player.field_70170_p, (PlayerEntity)player, 8);
        CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
        boolean equipped = compound.func_74764_b(slotKey = String.valueOf(player.field_71071_by.field_70461_c));
        if (equipped) {
            TileEntity blockEntity;
            boolean canReachToolbox;
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(slotKey).func_74775_l("Pos"));
            double max = ToolboxHandler.getMaxRange((PlayerEntity)player);
            boolean bl = canReachToolbox = ToolboxHandler.distance(player.func_213303_ch(), pos) < max * max;
            if (canReachToolbox && (blockEntity = level.func_175625_s(pos)) instanceof ToolboxTileEntity) {
                RadialToolboxMenu screen = new RadialToolboxMenu((List<ToolboxTileEntity>)ImmutableList.of((Object)((ToolboxTileEntity)blockEntity)), RadialToolboxMenu.State.SELECT_ITEM_UNEQUIP);
                screen.prevSlot(compound.func_74775_l(slotKey).func_74762_e("Slot"));
                ScreenOpener.open(screen);
                return;
            }
            ScreenOpener.open(new RadialToolboxMenu((List<ToolboxTileEntity>)ImmutableList.of(), RadialToolboxMenu.State.DETACH));
            return;
        }
        if (toolboxes.isEmpty()) {
            return;
        }
        if (toolboxes.size() == 1) {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_ITEM));
        } else {
            ScreenOpener.open(new RadialToolboxMenu(toolboxes, RadialToolboxMenu.State.SELECT_BOX));
        }
    }

    public static void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay, float partialTicks) {
        MainWindow mainWindow = Minecraft.func_71410_x().func_228018_at_();
        int x = mainWindow.func_198107_o() / 2 - 90;
        int y = mainWindow.func_198087_p() - 23;
        RenderSystem.enableDepthTest();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        CompoundNBT persistentData = player.getPersistentData();
        if (!persistentData.func_74764_b("CreateToolboxData")) {
            return;
        }
        CompoundNBT compound = player.getPersistentData().func_74775_l("CreateToolboxData");
        if (compound.isEmpty()) {
            return;
        }
        ms.func_227860_a_();
        for (int slot = 0; slot < 9; ++slot) {
            int offset;
            String key = String.valueOf(slot);
            if (!compound.func_74764_b(key)) continue;
            BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l(key).func_74775_l("Pos"));
            double max = ToolboxHandler.getMaxRange((PlayerEntity)player);
            boolean selected = player.field_71071_by.field_70461_c == slot;
            int n = offset = selected ? 1 : 0;
            AllGuiTextures texture = ToolboxHandler.distance(player.func_213303_ch(), pos) < max * max ? (selected ? AllGuiTextures.TOOLBELT_SELECTED_ON : AllGuiTextures.TOOLBELT_HOTBAR_ON) : (selected ? AllGuiTextures.TOOLBELT_SELECTED_OFF : AllGuiTextures.TOOLBELT_HOTBAR_OFF);
            texture.draw(ms, x + 20 * slot - offset, y + offset);
        }
        ms.func_227865_b_();
    }
}

