/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.belts.tunnel;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.relays.belt.BeltHelper;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BeltTunnelTileEntity;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelBlock;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelFilterSlot;
import com.simibubi.create.content.logistics.block.belts.tunnel.BrassTunnelItemHandler;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.belt.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.INamedIconOptions;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BrassTunnelTileEntity
extends BeltTunnelTileEntity
implements IHaveGoggleInformation {
    SidedFilteringBehaviour filtering;
    boolean connectedLeft;
    boolean connectedRight;
    ItemStack stackToDistribute;
    float distributionProgress;
    int distributionDistanceLeft;
    int distributionDistanceRight;
    int previousOutputIndex = 0;
    Couple<List<Pair<BlockPos, Direction>>> distributionTargets = Couple.create(ArrayList::new);
    private boolean syncedOutputActive = false;
    private Set<BrassTunnelTileEntity> syncSet = new HashSet<BrassTunnelTileEntity>();
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    private LazyOptional<IItemHandler> beltCapability;
    private LazyOptional<IItemHandler> tunnelCapability;
    private static Random rand = new Random();
    private static Map<Pair<BrassTunnelTileEntity, Direction>, ItemStack> distributed = new IdentityHashMap<Pair<BrassTunnelTileEntity, Direction>, ItemStack>();
    private static Set<Pair<BrassTunnelTileEntity, Direction>> full = new HashSet<Pair<BrassTunnelTileEntity, Direction>>();

    public BrassTunnelTileEntity(TileEntityType<? extends BeltTunnelTileEntity> type) {
        super(type);
        this.stackToDistribute = ItemStack.field_190927_a;
        this.beltCapability = LazyOptional.empty();
        this.tunnelCapability = LazyOptional.of(() -> new BrassTunnelItemHandler(this));
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (ITextComponent)Lang.translate("logistics.when_multiple_outputs_available", new Object[0]), this, new CenteredSideValueBoxTransform((state, d) -> d == Direction.UP));
        behaviours.add(this.selectionMode);
        this.selectionMode.requiresWrench();
        this.selectionMode.withCallback(setting -> {
            for (boolean side : Iterate.trueAndFalse) {
                BrassTunnelTileEntity adjacent;
                if (!this.isConnected(side) || (adjacent = this.getAdjacent(side)) == null) continue;
                adjacent.selectionMode.setValue((int)setting);
            }
        });
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        BeltTileEntity beltBelow = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, this.field_174879_c.func_177977_b());
        if (this.distributionProgress > 0.0f) {
            this.distributionProgress -= 1.0f;
        }
        if (beltBelow == null || beltBelow.getSpeed() == 0.0f) {
            return;
        }
        if (this.stackToDistribute.func_190926_b() && !this.syncedOutputActive) {
            return;
        }
        if (this.field_145850_b.field_72995_K && !this.isVirtual()) {
            return;
        }
        if (this.distributionProgress == -1.0f) {
            this.distributionTargets.forEach(List::clear);
            this.distributionDistanceLeft = 0;
            this.distributionDistanceRight = 0;
            this.syncSet.clear();
            List<Pair<BrassTunnelTileEntity, Direction>> validOutputs = this.gatherValidOutputs();
            if (this.selectionMode.get() == SelectionMode.SYNCHRONIZE) {
                boolean notifySyncedOut;
                boolean allEmpty = true;
                boolean allFull = true;
                for (BrassTunnelTileEntity te2 : this.syncSet) {
                    boolean hasStack = !te2.stackToDistribute.func_190926_b();
                    allEmpty &= !hasStack;
                    allFull &= hasStack;
                }
                boolean bl = notifySyncedOut = !allEmpty;
                if (allFull || allEmpty) {
                    this.syncSet.forEach(te -> {
                        te.syncedOutputActive = notifySyncedOut;
                    });
                }
            }
            if (validOutputs == null) {
                return;
            }
            if (this.stackToDistribute.func_190926_b()) {
                return;
            }
            for (Pair<BrassTunnelTileEntity, Direction> pair : validOutputs) {
                Direction output;
                BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                if (this.insertIntoTunnel(tunnel, output = (Direction)pair.getValue(), this.stackToDistribute, true) == null) continue;
                this.distributionTargets.get(!tunnel.flapFilterEmpty(output)).add((Pair<BlockPos, Direction>)Pair.of((Object)tunnel.field_174879_c, (Object)output));
                int distance = tunnel.field_174879_c.func_177958_n() + tunnel.field_174879_c.func_177952_p() - this.field_174879_c.func_177958_n() - this.field_174879_c.func_177952_p();
                if (distance < 0) {
                    this.distributionDistanceLeft = Math.max(this.distributionDistanceLeft, -distance);
                    continue;
                }
                this.distributionDistanceRight = Math.max(this.distributionDistanceRight, distance);
            }
            if (((List)this.distributionTargets.getFirst()).isEmpty() && ((List)this.distributionTargets.getSecond()).isEmpty()) {
                return;
            }
            if (this.selectionMode.get() != SelectionMode.SYNCHRONIZE || this.syncedOutputActive) {
                this.distributionProgress = 10.0f;
                this.sendData();
            }
            return;
        }
        if (this.distributionProgress != 0.0f) {
            return;
        }
        this.distributionTargets.forEach(list -> {
            if (this.stackToDistribute.func_190926_b()) {
                return;
            }
            ArrayList<Pair<BrassTunnelTileEntity, Direction>> validTargets = new ArrayList<Pair<BrassTunnelTileEntity, Direction>>();
            for (Pair pair : list) {
                BlockPos tunnelPos = (BlockPos)pair.getKey();
                Direction output = (Direction)pair.getValue();
                TileEntity te = this.field_145850_b.func_175625_s(tunnelPos);
                if (!(te instanceof BrassTunnelTileEntity)) continue;
                validTargets.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)((BrassTunnelTileEntity)te), (Object)output));
            }
            this.distribute(validTargets);
            this.distributionProgress = -1.0f;
        });
    }

    private void distribute(List<Pair<BrassTunnelTileEntity, Direction>> validTargets) {
        boolean robin;
        int amountTargets = validTargets.size();
        if (amountTargets == 0) {
            return;
        }
        distributed.clear();
        full.clear();
        int indexStart = this.previousOutputIndex % amountTargets;
        SelectionMode mode = this.selectionMode.get();
        boolean force = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.FORCED_SPLIT;
        boolean split = mode == SelectionMode.FORCED_SPLIT || mode == SelectionMode.SPLIT;
        boolean bl = robin = mode == SelectionMode.FORCED_ROUND_ROBIN || mode == SelectionMode.ROUND_ROBIN;
        if (mode == SelectionMode.RANDOMIZE) {
            indexStart = rand.nextInt(amountTargets);
        }
        if (mode == SelectionMode.PREFER_NEAREST || mode == SelectionMode.SYNCHRONIZE) {
            indexStart = 0;
        }
        ItemStack toDistribute = this.stackToDistribute.func_77946_l();
        for (boolean distributeAgain : Iterate.trueAndFalse) {
            ItemStack toDistributeThisCycle = null;
            int remainingOutputs = amountTargets;
            int leftovers = 0;
            block1: for (boolean simulate : Iterate.trueAndFalse) {
                if (remainingOutputs == 0) break;
                leftovers = 0;
                int index = indexStart;
                int stackSize = toDistribute.func_190916_E();
                int splitStackSize = stackSize / remainingOutputs;
                int splitRemainder = stackSize % remainingOutputs;
                int visited = 0;
                toDistributeThisCycle = toDistribute.func_77946_l();
                if (!force && !split && simulate) continue;
                while (visited < amountTargets) {
                    ItemStack remainder;
                    int increasedCount;
                    Pair<BrassTunnelTileEntity, Direction> pair = validTargets.get(index);
                    BrassTunnelTileEntity tunnel = (BrassTunnelTileEntity)pair.getKey();
                    Direction side = (Direction)pair.getValue();
                    index = (index + 1) % amountTargets;
                    ++visited;
                    if (full.contains(pair)) {
                        if (!split || !simulate) continue;
                        --remainingOutputs;
                        continue;
                    }
                    int count = split ? splitStackSize + (splitRemainder > 0 ? 1 : 0) : stackSize;
                    ItemStack toOutput = ItemHandlerHelper.copyStackWithSize((ItemStack)toDistributeThisCycle, (int)count);
                    boolean testWithIncreasedCount = distributed.containsKey(pair);
                    int n = increasedCount = testWithIncreasedCount ? distributed.get(pair).func_190916_E() : 0;
                    if (testWithIncreasedCount) {
                        toOutput.func_190917_f(increasedCount);
                    }
                    if ((remainder = this.insertIntoTunnel(tunnel, side, toOutput, true)) == null || remainder.func_190916_E() == (testWithIncreasedCount ? count + 1 : count)) {
                        if (force) {
                            return;
                        }
                        if (split && simulate) {
                            --remainingOutputs;
                        }
                        if (!simulate) {
                            full.add(pair);
                        }
                        if (!robin) continue;
                        continue block1;
                    }
                    if (!remainder.func_190926_b() && !simulate) {
                        full.add(pair);
                    }
                    if (!simulate) {
                        toOutput.func_190918_g(remainder.func_190916_E());
                        distributed.put(pair, toOutput);
                    }
                    leftovers += remainder.func_190916_E();
                    toDistributeThisCycle.func_190918_g(count);
                    if (toDistributeThisCycle.func_190926_b()) continue block1;
                    --splitRemainder;
                    if (split) continue;
                    continue block1;
                }
            }
            toDistribute.func_190920_e(toDistributeThisCycle.func_190916_E() + leftovers);
            if (leftovers == 0 && distributeAgain || !split) break;
        }
        int failedTransferrals = 0;
        for (Map.Entry<Pair<BrassTunnelTileEntity, Direction>, ItemStack> entry : distributed.entrySet()) {
            Pair<BrassTunnelTileEntity, Direction> pair = entry.getKey();
            failedTransferrals += this.insertIntoTunnel((BrassTunnelTileEntity)pair.getKey(), (Direction)pair.getValue(), entry.getValue(), false).func_190916_E();
        }
        toDistribute.func_190917_f(failedTransferrals);
        this.stackToDistribute = ItemHandlerHelper.copyStackWithSize((ItemStack)this.stackToDistribute, (int)toDistribute.func_190916_E());
        ++this.previousOutputIndex;
        this.previousOutputIndex %= amountTargets;
        this.notifyUpdate();
    }

    public void setStackToDistribute(ItemStack stack) {
        this.stackToDistribute = stack;
        this.distributionProgress = -1.0f;
        this.sendData();
        this.func_70296_d();
    }

    public ItemStack getStackToDistribute() {
        return this.stackToDistribute;
    }

    public List<ItemStack> grabAllStacksOfGroup(boolean simulate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack own = this.getStackToDistribute();
        if (!own.func_190926_b()) {
            list.add(own);
            if (!simulate) {
                this.setStackToDistribute(ItemStack.field_190927_a);
            }
        }
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                ItemStack other;
                if (!this.field_145850_b.isAreaLoaded(adjacent.func_174877_v(), 1)) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null || (other = adjacent.getStackToDistribute()).func_190926_b()) continue;
                list.add(other);
                if (simulate) continue;
                adjacent.setStackToDistribute(ItemStack.field_190927_a);
            }
        }
        return list;
    }

    @Nullable
    protected ItemStack insertIntoTunnel(BrassTunnelTileEntity tunnel, Direction side, ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return stack;
        }
        if (!tunnel.testFlapFilter(side, stack)) {
            return null;
        }
        BeltTileEntity below = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, tunnel.field_174879_c.func_177977_b());
        if (below == null) {
            return null;
        }
        BlockPos offset = tunnel.func_174877_v().func_177977_b().func_177972_a(side);
        DirectBeltInputBehaviour sideOutput = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, offset, DirectBeltInputBehaviour.TYPE);
        if (sideOutput != null) {
            if (!sideOutput.canInsertFromSide(side)) {
                return null;
            }
            ItemStack result = sideOutput.handleInsertion(stack, side, simulate);
            if (result.func_190926_b() && !simulate) {
                tunnel.flap(side, false);
            }
            return result;
        }
        Direction movementFacing = below.getMovementFacing();
        if (side == movementFacing && !BlockHelper.hasBlockSolidSide(this.field_145850_b.func_180495_p(offset), (IBlockReader)this.field_145850_b, offset, side.func_176734_d())) {
            BeltTileEntity controllerTE = below.getControllerTE();
            if (controllerTE == null) {
                return null;
            }
            if (!simulate) {
                tunnel.flap(side, true);
                ItemStack ejected = stack;
                float beltMovementSpeed = below.getDirectionAwareBeltMovementSpeed();
                float movementSpeed = Math.max(Math.abs(beltMovementSpeed), 0.125f);
                int additionalOffset = beltMovementSpeed > 0.0f ? 1 : 0;
                Vector3d outPos = BeltHelper.getVectorForOffset(controllerTE, below.index + additionalOffset);
                Vector3d outMotion = Vector3d.func_237491_b_((Vector3i)side.func_176730_m()).func_186678_a((double)movementSpeed).func_72441_c(0.0, 0.125, 0.0);
                outPos.func_178787_e(outMotion.func_72432_b());
                ItemEntity entity = new ItemEntity(this.field_145850_b, outPos.field_72450_a, outPos.field_72448_b + 0.375, outPos.field_72449_c, ejected);
                entity.func_213317_d(outMotion);
                entity.func_174869_p();
                entity.field_70133_I = true;
                this.field_145850_b.func_217376_c((Entity)entity);
            }
            return ItemStack.field_190927_a;
        }
        return null;
    }

    public boolean testFlapFilter(Direction side, ItemStack stack) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.test(stack);
        }
        return this.filtering.test(side, stack);
    }

    public boolean flapFilterEmpty(Direction side) {
        if (this.filtering == null) {
            return false;
        }
        if (this.filtering.get(side) == null) {
            FilteringBehaviour adjacentFilter = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, this.field_174879_c.func_177972_a(side), FilteringBehaviour.TYPE);
            if (adjacentFilter == null) {
                return true;
            }
            return adjacentFilter.getFilter().func_190926_b();
        }
        return this.filtering.getFilter(side).func_190926_b();
    }

    @Override
    public void initialize() {
        if (this.filtering == null) {
            this.filtering = this.createSidedFilter();
            this.attachBehaviourLate(this.filtering);
        }
        super.initialize();
    }

    public boolean canInsert(Direction side, ItemStack stack) {
        if (this.filtering != null && !this.filtering.test(side, stack)) {
            return false;
        }
        if (!this.hasDistributionBehaviour()) {
            return true;
        }
        return this.stackToDistribute.func_190926_b();
    }

    public boolean hasDistributionBehaviour() {
        if (this.flaps.isEmpty()) {
            return false;
        }
        if (this.connectedLeft || this.connectedRight) {
            return true;
        }
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return false;
        }
        Direction.Axis axis = (Direction.Axis)blockState.func_177229_b(BrassTunnelBlock.HORIZONTAL_AXIS);
        for (Direction direction : this.flaps.keySet()) {
            if (direction.func_176740_k() == axis) continue;
            return true;
        }
        return false;
    }

    private List<Pair<BrassTunnelTileEntity, Direction>> gatherValidOutputs() {
        ArrayList<Pair<BrassTunnelTileEntity, Direction>> validOutputs = new ArrayList<Pair<BrassTunnelTileEntity, Direction>>();
        boolean synchronize = this.selectionMode.get() == SelectionMode.SYNCHRONIZE;
        this.addValidOutputsOf(this, validOutputs);
        for (boolean left : Iterate.trueAndFalse) {
            BrassTunnelTileEntity adjacent = this;
            while (adjacent != null) {
                if (!this.field_145850_b.isAreaLoaded(adjacent.func_174877_v(), 1)) {
                    return null;
                }
                if ((adjacent = adjacent.getAdjacent(left)) == null) continue;
                this.addValidOutputsOf(adjacent, validOutputs);
            }
        }
        if (!this.syncedOutputActive && synchronize) {
            return null;
        }
        return validOutputs;
    }

    private void addValidOutputsOf(BrassTunnelTileEntity tunnelTE, List<Pair<BrassTunnelTileEntity, Direction>> validOutputs) {
        this.syncSet.add(tunnelTE);
        BeltTileEntity below = BeltHelper.getSegmentTE((IWorld)this.field_145850_b, tunnelTE.field_174879_c.func_177977_b());
        if (below == null) {
            return;
        }
        Direction movementFacing = below.getMovementFacing();
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return;
        }
        boolean prioritizeSides = tunnelTE == this;
        for (boolean sidePass : Iterate.trueAndFalse) {
            if (!prioritizeSides && sidePass) continue;
            for (Direction direction : Iterate.horizontalDirections) {
                if (direction == movementFacing && below.getSpeed() == 0.0f || prioritizeSides && sidePass == (direction.func_176740_k() == movementFacing.func_176740_k()) || direction == movementFacing.func_176734_d() || !tunnelTE.sides.contains(direction)) continue;
                BlockPos offset = tunnelTE.field_174879_c.func_177977_b().func_177972_a(direction);
                DirectBeltInputBehaviour inputBehaviour = TileEntityBehaviour.get((IBlockReader)this.field_145850_b, offset, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null) {
                    if (direction != movementFacing || BlockHelper.hasBlockSolidSide(this.field_145850_b.func_180495_p(offset), (IBlockReader)this.field_145850_b, offset, direction.func_176734_d())) continue;
                    validOutputs.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)tunnelTE, (Object)direction));
                    continue;
                }
                if (!inputBehaviour.canInsertFromSide(direction)) continue;
                validOutputs.add((Pair<BrassTunnelTileEntity, Direction>)Pair.of((Object)tunnelTE, (Object)direction));
            }
        }
    }

    @Override
    public void addBehavioursDeferred(List<TileEntityBehaviour> behaviours) {
        super.addBehavioursDeferred(behaviours);
        this.filtering = this.createSidedFilter();
        behaviours.add(this.filtering);
    }

    protected SidedFilteringBehaviour createSidedFilter() {
        return new SidedFilteringBehaviour(this, new BrassTunnelFilterSlot(), this::makeFilter, this::isValidFaceForFilter);
    }

    private FilteringBehaviour makeFilter(Direction side, FilteringBehaviour filter) {
        return filter;
    }

    private boolean isValidFaceForFilter(Direction side) {
        return this.sides.contains(side);
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        compound.func_74757_a("SyncedOutput", this.syncedOutputActive);
        compound.func_74757_a("ConnectedLeft", this.connectedLeft);
        compound.func_74757_a("ConnectedRight", this.connectedRight);
        compound.func_218657_a("StackToDistribute", (INBT)this.stackToDistribute.serializeNBT());
        compound.func_74776_a("DistributionProgress", this.distributionProgress);
        compound.func_74768_a("PreviousIndex", this.previousOutputIndex);
        compound.func_74768_a("DistanceLeft", this.distributionDistanceLeft);
        compound.func_74768_a("DistanceRight", this.distributionDistanceRight);
        for (boolean filtered : Iterate.trueAndFalse) {
            compound.func_218657_a(filtered ? "FilteredTargets" : "Targets", (INBT)NBTHelper.writeCompoundList((Iterable)this.distributionTargets.get(filtered), pair -> {
                CompoundNBT nbt = new CompoundNBT();
                nbt.func_218657_a("Pos", (INBT)NBTUtil.func_186859_a((BlockPos)((BlockPos)pair.getKey())));
                nbt.func_74768_a("Face", ((Direction)pair.getValue()).func_176745_a());
                return nbt;
            }));
        }
        super.write(compound, clientPacket);
    }

    @Override
    protected void fromTag(BlockState state, CompoundNBT compound, boolean clientPacket) {
        boolean wasConnectedLeft = this.connectedLeft;
        boolean wasConnectedRight = this.connectedRight;
        this.syncedOutputActive = compound.func_74767_n("SyncedOutput");
        this.connectedLeft = compound.func_74767_n("ConnectedLeft");
        this.connectedRight = compound.func_74767_n("ConnectedRight");
        this.stackToDistribute = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("StackToDistribute"));
        this.distributionProgress = compound.func_74760_g("DistributionProgress");
        this.previousOutputIndex = compound.func_74762_e("PreviousIndex");
        this.distributionDistanceLeft = compound.func_74762_e("DistanceLeft");
        this.distributionDistanceRight = compound.func_74762_e("DistanceRight");
        for (boolean filtered : Iterate.trueAndFalse) {
            this.distributionTargets.set(filtered, NBTHelper.readCompoundList(compound.func_150295_c(filtered ? "FilteredTargets" : "Targets", 10), nbt -> {
                BlockPos pos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("Pos"));
                Direction face = Direction.func_82600_a((int)nbt.func_74762_e("Face"));
                return Pair.of((Object)pos, (Object)face);
            }));
        }
        super.fromTag(state, compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (wasConnectedLeft != this.connectedLeft || wasConnectedRight != this.connectedRight) {
            this.requestModelDataUpdate();
            if (this.func_145830_o()) {
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 16);
            }
        }
        this.filtering.updateFilterPresence();
    }

    public boolean isConnected(boolean leftSide) {
        return leftSide ? this.connectedLeft : this.connectedRight;
    }

    @Override
    public void updateTunnelConnections() {
        BrassTunnelTileEntity adjacent;
        super.updateTunnelConnections();
        boolean connectivityChanged = false;
        boolean nowConnectedLeft = this.determineIfConnected(true);
        boolean nowConnectedRight = this.determineIfConnected(false);
        if (this.connectedLeft != nowConnectedLeft) {
            this.connectedLeft = nowConnectedLeft;
            connectivityChanged = true;
            adjacent = this.getAdjacent(true);
            if (adjacent != null && !this.field_145850_b.field_72995_K) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
                AllTriggers.triggerForNearbyPlayers(AllTriggers.CONNECT_TUNNEL, (IWorld)this.field_145850_b, this.field_174879_c, 4);
            }
        }
        if (this.connectedRight != nowConnectedRight) {
            this.connectedRight = nowConnectedRight;
            connectivityChanged = true;
            adjacent = this.getAdjacent(false);
            if (adjacent != null && !this.field_145850_b.field_72995_K) {
                adjacent.updateTunnelConnections();
                adjacent.selectionMode.setValue(this.selectionMode.getValue());
            }
        }
        if (this.filtering != null) {
            this.filtering.updateFilterPresence();
        }
        if (connectivityChanged) {
            this.sendData();
        }
    }

    protected boolean determineIfConnected(boolean leftSide) {
        if (this.flaps.isEmpty()) {
            return false;
        }
        BrassTunnelTileEntity adjacentTunnelTE = this.getAdjacent(leftSide);
        return adjacentTunnelTE != null && !adjacentTunnelTE.flaps.isEmpty();
    }

    @Nullable
    protected BrassTunnelTileEntity getAdjacent(boolean leftSide) {
        if (!this.func_145830_o()) {
            return null;
        }
        BlockState blockState = this.func_195044_w();
        if (!AllBlocks.BRASS_TUNNEL.has(blockState)) {
            return null;
        }
        Direction.Axis axis = (Direction.Axis)blockState.func_177229_b(BrassTunnelBlock.HORIZONTAL_AXIS);
        Direction baseDirection = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        Direction direction = leftSide ? baseDirection.func_176735_f() : baseDirection.func_176746_e();
        BlockPos adjacentPos = this.field_174879_c.func_177972_a(direction);
        BlockState adjacentBlockState = this.field_145850_b.func_180495_p(adjacentPos);
        if (!AllBlocks.BRASS_TUNNEL.has(adjacentBlockState)) {
            return null;
        }
        if (adjacentBlockState.func_177229_b(BrassTunnelBlock.HORIZONTAL_AXIS) != axis) {
            return null;
        }
        TileEntity adjacentTE = this.field_145850_b.func_175625_s(adjacentPos);
        if (adjacentTE.func_145837_r()) {
            return null;
        }
        if (!(adjacentTE instanceof BrassTunnelTileEntity)) {
            return null;
        }
        return (BrassTunnelTileEntity)adjacentTE;
    }

    @Override
    public void func_145843_s() {
        this.tunnelCapability.invalidate();
        super.func_145843_s();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.tunnelCapability.cast();
        }
        return super.getCapability(capability, side);
    }

    public LazyOptional<IItemHandler> getBeltCapability() {
        TileEntity tileEntity;
        if (!this.beltCapability.isPresent() && (tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null) {
            this.beltCapability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        return this.beltCapability;
    }

    public boolean canTakeItems() {
        return this.stackToDistribute.func_190926_b() && !this.syncedOutputActive;
    }

    @Override
    public boolean addToGoggleTooltip(List<ITextComponent> tooltip, boolean isPlayerSneaking) {
        List<ItemStack> allStacks = this.grabAllStacksOfGroup(true);
        if (allStacks.isEmpty()) {
            return false;
        }
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.brass_tunnel.contains", new Object[0])).func_240699_a_(TextFormatting.WHITE));
        for (ItemStack item : allStacks) {
            tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.brass_tunnel.contains_entry", new TranslationTextComponent(item.func_77973_b().func_77667_c(item)).getString(), item.func_190916_E())).func_240699_a_(TextFormatting.GRAY));
        }
        tooltip.add((ITextComponent)componentSpacing.func_230531_f_().func_230529_a_((ITextComponent)Lang.translate("tooltip.brass_tunnel.retrieve", new Object[0])).func_240699_a_(TextFormatting.DARK_GRAY));
        return true;
    }

    public static enum SelectionMode implements INamedIconOptions
    {
        SPLIT(AllIcons.I_TUNNEL_SPLIT),
        FORCED_SPLIT(AllIcons.I_TUNNEL_FORCED_SPLIT),
        ROUND_ROBIN(AllIcons.I_TUNNEL_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_TUNNEL_FORCED_ROUND_ROBIN),
        PREFER_NEAREST(AllIcons.I_TUNNEL_PREFER_NEAREST),
        RANDOMIZE(AllIcons.I_TUNNEL_RANDOMIZE),
        SYNCHRONIZE(AllIcons.I_TUNNEL_SYNCHRONIZE);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "tunnel.selection_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

