/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.block;

import com.jozufozu.flywheel.backend.instancing.IInstanceRendered;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.relays.belt.BeltBlock;
import com.simibubi.create.content.contraptions.relays.belt.BeltPart;
import com.simibubi.create.content.contraptions.relays.belt.BeltSlope;
import com.simibubi.create.content.contraptions.relays.belt.BeltTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.AbstractShaftBlock;
import com.simibubi.create.content.schematics.ItemRequirement;
import com.simibubi.create.content.schematics.MaterialChecklist;
import com.simibubi.create.content.schematics.SchematicPrinter;
import com.simibubi.create.content.schematics.block.LaunchedItem;
import com.simibubi.create.content.schematics.block.SchematicannonContainer;
import com.simibubi.create.content.schematics.block.SchematicannonInventory;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.IPartialSafeNBT;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTProcessors;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class SchematicannonTileEntity
extends SmartTileEntity
implements INamedContainerProvider,
IInstanceRendered {
    public static final int NEIGHBOUR_CHECKING = 100;
    public static final int MAX_ANCHOR_DISTANCE = 256;
    public SchematicannonInventory inventory;
    public boolean sendUpdate;
    public boolean dontUpdateChecklist;
    public int neighbourCheckCooldown;
    public SchematicPrinter printer;
    public ItemStack missingItem;
    public boolean positionNotLoaded;
    public boolean hasCreativeCrate;
    private int printerCooldown;
    private int skipsLeft;
    private boolean blockSkipped;
    public BlockPos previousTarget;
    public LinkedHashSet<LazyOptional<IItemHandler>> attachedInventories;
    public List<LaunchedItem> flyingBlocks;
    public MaterialChecklist checklist;
    public float fuelLevel;
    public float bookPrintingProgress;
    public float schematicProgress;
    public String statusMsg;
    public State state;
    public int blocksPlaced;
    public int blocksToPlace;
    public int replaceMode;
    public boolean skipMissing;
    public boolean replaceTileEntities;
    public boolean firstRenderTick;

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 16.0;
    }

    public SchematicannonTileEntity(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.setLazyTickRate(30);
        this.attachedInventories = new LinkedHashSet();
        this.flyingBlocks = new LinkedList<LaunchedItem>();
        this.inventory = new SchematicannonInventory(this);
        this.statusMsg = "idle";
        this.state = State.STOPPED;
        this.replaceMode = 2;
        this.checklist = new MaterialChecklist();
        this.printer = new SchematicPrinter();
    }

    public void findInventories() {
        this.hasCreativeCrate = false;
        this.attachedInventories.clear();
        for (Direction facing : Iterate.directions) {
            LazyOptional capability;
            TileEntity tileEntity;
            if (!this.field_145850_b.func_195588_v(this.field_174879_c.func_177972_a(facing))) continue;
            if (AllBlocks.CREATIVE_CRATE.has(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)))) {
                this.hasCreativeCrate = true;
            }
            if ((tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null || !(capability = tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())).isPresent()) continue;
            this.attachedInventories.add((LazyOptional<IItemHandler>)capability);
        }
    }

    @Override
    protected void fromTag(BlockState blockState, CompoundNBT compound, boolean clientPacket) {
        if (!clientPacket) {
            this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        }
        this.statusMsg = compound.func_74779_i("Status");
        this.schematicProgress = compound.func_74760_g("Progress");
        this.bookPrintingProgress = compound.func_74760_g("PaperProgress");
        this.fuelLevel = compound.func_74760_g("Fuel");
        this.state = State.valueOf(compound.func_74779_i("State"));
        this.blocksPlaced = compound.func_74762_e("AmountPlaced");
        this.blocksToPlace = compound.func_74762_e("AmountToPlace");
        this.missingItem = null;
        if (compound.func_74764_b("MissingItem")) {
            this.missingItem = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("MissingItem"));
        }
        CompoundNBT options = compound.func_74775_l("Options");
        this.replaceMode = options.func_74762_e("ReplaceMode");
        this.skipMissing = options.func_74767_n("SkipMissing");
        this.replaceTileEntities = options.func_74767_n("ReplaceTileEntities");
        if (compound.func_74764_b("Printer")) {
            this.printer.fromTag(compound.func_74775_l("Printer"), clientPacket);
        }
        if (compound.func_74764_b("FlyingBlocks")) {
            this.readFlyingBlocks(compound);
        }
        super.fromTag(blockState, compound, clientPacket);
    }

    protected void readFlyingBlocks(CompoundNBT compound) {
        ListNBT tagBlocks = compound.func_150295_c("FlyingBlocks", 10);
        if (tagBlocks.isEmpty()) {
            this.flyingBlocks.clear();
        }
        boolean pastDead = false;
        for (int i = 0; i < tagBlocks.size(); ++i) {
            CompoundNBT c = tagBlocks.func_150305_b(i);
            LaunchedItem launched = LaunchedItem.fromNBT(c);
            BlockPos readBlockPos = launched.target;
            if (this.field_145850_b == null || !this.field_145850_b.field_72995_K) {
                this.flyingBlocks.add(launched);
                continue;
            }
            while (!(pastDead || this.flyingBlocks.isEmpty() || this.flyingBlocks.get((int)0).target.equals((Object)readBlockPos))) {
                this.flyingBlocks.remove(0);
            }
            pastDead = true;
            if (i < this.flyingBlocks.size()) continue;
            this.flyingBlocks.add(launched);
        }
    }

    @Override
    public void write(CompoundNBT compound, boolean clientPacket) {
        if (!clientPacket) {
            compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
            if (this.state == State.RUNNING) {
                compound.func_74757_a("Running", true);
            }
        }
        compound.func_74776_a("Progress", this.schematicProgress);
        compound.func_74776_a("PaperProgress", this.bookPrintingProgress);
        compound.func_74776_a("Fuel", this.fuelLevel);
        compound.func_74778_a("Status", this.statusMsg);
        compound.func_74778_a("State", this.state.name());
        compound.func_74768_a("AmountPlaced", this.blocksPlaced);
        compound.func_74768_a("AmountToPlace", this.blocksToPlace);
        if (this.missingItem != null) {
            compound.func_218657_a("MissingItem", (INBT)this.missingItem.serializeNBT());
        }
        CompoundNBT options = new CompoundNBT();
        options.func_74768_a("ReplaceMode", this.replaceMode);
        options.func_74757_a("SkipMissing", this.skipMissing);
        options.func_74757_a("ReplaceTileEntities", this.replaceTileEntities);
        compound.func_218657_a("Options", (INBT)options);
        CompoundNBT printerData = new CompoundNBT();
        this.printer.write(printerData);
        compound.func_218657_a("Printer", (INBT)printerData);
        ListNBT tagFlyingBlocks = new ListNBT();
        for (LaunchedItem b : this.flyingBlocks) {
            tagFlyingBlocks.add((Object)b.serializeNBT());
        }
        compound.func_218657_a("FlyingBlocks", (INBT)tagFlyingBlocks);
        super.write(compound, clientPacket);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.state != State.STOPPED && this.neighbourCheckCooldown-- <= 0) {
            this.neighbourCheckCooldown = 100;
            this.findInventories();
        }
        this.firstRenderTick = true;
        this.previousTarget = this.printer.getCurrentTarget();
        this.tickFlyingBlocks();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.tickPaperPrinter();
        this.refillFuelIfPossible();
        this.skipsLeft = (Integer)this.config().schematicannonSkips.get();
        this.blockSkipped = true;
        while (this.blockSkipped && this.skipsLeft-- > 0) {
            this.tickPrinter();
        }
        this.schematicProgress = 0.0f;
        if (this.blocksToPlace > 0) {
            this.schematicProgress = (float)this.blocksPlaced / (float)this.blocksToPlace;
        }
        if (this.sendUpdate) {
            this.sendUpdate = false;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 6);
        }
    }

    public CSchematics config() {
        return AllConfigs.SERVER.schematics;
    }

    protected void tickPrinter() {
        ItemRequirement requirement;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        this.blockSkipped = false;
        if (this.state == State.STOPPED) {
            if (this.printer.isLoaded()) {
                this.resetPrinter();
            }
            return;
        }
        if (blueprint.func_190926_b()) {
            this.state = State.STOPPED;
            this.statusMsg = "idle";
            this.sendUpdate = true;
            return;
        }
        if (this.state == State.PAUSED && !this.positionNotLoaded && this.missingItem == null && (double)this.fuelLevel > this.getFuelUsageRate()) {
            return;
        }
        if (!this.printer.isLoaded()) {
            this.initializePrinter(blueprint);
            return;
        }
        if (this.printerCooldown > 0) {
            --this.printerCooldown;
            return;
        }
        if (this.fuelLevel <= 0.0f && !this.hasCreativeCrate) {
            this.fuelLevel = 0.0f;
            this.state = State.PAUSED;
            this.statusMsg = "noGunpowder";
            this.sendUpdate = true;
            return;
        }
        if (this.hasCreativeCrate && this.missingItem != null) {
            this.missingItem = null;
            this.state = State.RUNNING;
        }
        if (this.missingItem == null && !this.positionNotLoaded) {
            if (!this.printer.advanceCurrentPos()) {
                this.finishedPrinting();
                return;
            }
            this.sendUpdate = true;
        }
        if (!this.func_145831_w().isAreaLoaded(this.printer.getCurrentTarget(), 0)) {
            this.positionNotLoaded = true;
            this.statusMsg = "targetNotLoaded";
            this.state = State.PAUSED;
            return;
        }
        if (this.positionNotLoaded) {
            this.positionNotLoaded = false;
            this.state = State.RUNNING;
        }
        if ((requirement = this.printer.getCurrentRequirement()).isInvalid() || !this.printer.shouldPlaceCurrent(this.field_145850_b, this::shouldPlace)) {
            this.statusMsg = "searching";
            this.blockSkipped = true;
            return;
        }
        List<ItemRequirement.StackRequirement> requiredItems = requirement.getRequiredItems();
        if (!requirement.isEmpty()) {
            for (ItemRequirement.StackRequirement required : requiredItems) {
                if (this.grabItemsFromAttachedInventories(required.item, required.usage, true)) continue;
                if (this.skipMissing) {
                    this.statusMsg = "skipping";
                    this.blockSkipped = true;
                    if (this.missingItem != null) {
                        this.missingItem = null;
                        this.state = State.RUNNING;
                    }
                    return;
                }
                this.missingItem = required.item;
                this.state = State.PAUSED;
                this.statusMsg = "missingBlock";
                return;
            }
            for (ItemRequirement.StackRequirement required : requiredItems) {
                this.grabItemsFromAttachedInventories(required.item, required.usage, false);
            }
        }
        this.state = State.RUNNING;
        ItemStack icon = requirement.isEmpty() || requiredItems.isEmpty() ? ItemStack.field_190927_a : requiredItems.get((int)0).item;
        this.printer.handleCurrentTarget((target, blockState, tile) -> {
            this.statusMsg = blockState.func_177230_c() != Blocks.field_150350_a ? "placing" : "clearing";
            this.launchBlockOrBelt(target, icon, blockState, tile);
        }, (target, entity) -> {
            this.statusMsg = "placing";
            this.launchEntity(target, icon, entity);
        });
        this.printerCooldown = (Integer)this.config().schematicannonDelay.get();
        this.fuelLevel = (float)((double)this.fuelLevel - this.getFuelUsageRate());
        this.sendUpdate = true;
        this.missingItem = null;
    }

    public double getFuelUsageRate() {
        return this.hasCreativeCrate ? 0.0 : (Double)this.config().schematicannonFuelUsage.get() / 100.0;
    }

    protected void initializePrinter(ItemStack blueprint) {
        if (!blueprint.func_77942_o()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicInvalid";
            this.sendUpdate = true;
            return;
        }
        if (!blueprint.func_77978_p().func_74767_n("Deployed")) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicNotPlaced";
            this.sendUpdate = true;
            return;
        }
        this.printer.loadSchematic(blueprint, this.field_145850_b, true);
        if (this.printer.isWorldEmpty()) {
            this.state = State.STOPPED;
            this.statusMsg = "schematicExpired";
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            this.inventory.setStackInSlot(1, new ItemStack((IItemProvider)AllItems.EMPTY_SCHEMATIC.get()));
            this.printer.resetSchematic();
            return;
        }
        if (!this.printer.getAnchor().func_218141_a((Vector3i)this.func_174877_v(), 256.0)) {
            this.state = State.STOPPED;
            this.statusMsg = "targetOutsideRange";
            this.printer.resetSchematic();
            return;
        }
        this.state = State.PAUSED;
        this.statusMsg = "ready";
        this.updateChecklist();
        this.sendUpdate = true;
        this.blocksToPlace += this.blocksPlaced;
    }

    protected ItemStack getItemForBlock(BlockState blockState) {
        Item item = BlockItem.field_179220_a.getOrDefault(blockState.func_177230_c(), Items.field_190931_a);
        return item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item);
    }

    protected boolean grabItemsFromAttachedInventories(ItemStack required, ItemRequirement.ItemUseType usage, boolean simulate) {
        IItemHandler iItemHandler;
        if (this.hasCreativeCrate) {
            return true;
        }
        this.attachedInventories.removeIf(cap -> !cap.isPresent());
        if (usage == ItemRequirement.ItemUseType.DAMAGE) {
            for (LazyOptional lazyOptional : this.attachedInventories) {
                IItemHandler iItemHandler2 = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
                for (int i = 0; i < iItemHandler2.getSlots(); ++i) {
                    ItemStack extractItem = iItemHandler2.extractItem(i, 1, true);
                    if (!ItemRequirement.validate(required, extractItem) || !extractItem.func_77984_f()) continue;
                    if (!simulate) {
                        ItemStack stack = iItemHandler2.extractItem(i, 1, false);
                        stack.func_196085_b(stack.func_77952_i() + 1);
                        if (stack.func_77952_i() <= stack.func_77958_k()) {
                            if (iItemHandler2.getStackInSlot(i).func_190926_b()) {
                                iItemHandler2.insertItem(i, stack, false);
                            } else {
                                ItemHandlerHelper.insertItem((IItemHandler)iItemHandler2, (ItemStack)stack, (boolean)false);
                            }
                        }
                    }
                    return true;
                }
            }
        }
        boolean success = false;
        if (usage == ItemRequirement.ItemUseType.CONSUME) {
            boolean bl = false;
            for (LazyOptional lazyOptional : this.attachedInventories) {
                iItemHandler = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
                if ((var5_8 += ItemHelper.extract(iItemHandler, s -> ItemRequirement.validate(required, s), ItemHelper.ExtractionCountMode.UPTO, required.func_190916_E(), true).func_190916_E()) < required.func_190916_E()) continue;
                success = true;
                break;
            }
        }
        if (!simulate && success) {
            LazyOptional lazyOptional;
            boolean bl = false;
            Iterator iterator = this.attachedInventories.iterator();
            while (iterator.hasNext() && (var5_10 += ItemHelper.extract(iItemHandler = (IItemHandler)(lazyOptional = (LazyOptional)iterator.next()).orElse((Object)EmptyHandler.INSTANCE), s -> ItemRequirement.validate(required, s), ItemHelper.ExtractionCountMode.UPTO, required.func_190916_E(), false).func_190916_E()) < required.func_190916_E()) {
            }
        }
        return success;
    }

    public void finishedPrinting() {
        this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
        this.inventory.setStackInSlot(1, new ItemStack((IItemProvider)AllItems.EMPTY_SCHEMATIC.get(), this.inventory.getStackInSlot(1).func_190916_E() + 1));
        this.state = State.STOPPED;
        this.statusMsg = "finished";
        this.resetPrinter();
        AllSoundEvents.SCHEMATICANNON_FINISH.playOnServer(this.field_145850_b, this.field_174879_c);
        this.sendUpdate = true;
    }

    protected void resetPrinter() {
        this.printer.resetSchematic();
        this.missingItem = null;
        this.sendUpdate = true;
        this.schematicProgress = 0.0f;
        this.blocksPlaced = 0;
        this.blocksToPlace = 0;
    }

    protected boolean shouldPlace(BlockPos pos, BlockState state, TileEntity te, BlockState toReplace, BlockState toReplaceOther, boolean isNormalCube) {
        if (pos.func_218141_a((Vector3i)this.func_174877_v(), 2.0)) {
            return false;
        }
        if (!this.replaceTileEntities && (toReplace.hasTileEntity() || toReplaceOther != null && toReplaceOther.hasTileEntity())) {
            return false;
        }
        if (this.shouldIgnoreBlockState(state, te)) {
            return false;
        }
        boolean placingAir = state.func_177230_c().isAir(state, (IBlockReader)this.field_145850_b, pos);
        if (this.replaceMode == 3) {
            return true;
        }
        if (this.replaceMode == 2 && !placingAir) {
            return true;
        }
        if (!(this.replaceMode != 1 || !isNormalCube && (toReplace.func_215686_e((IBlockReader)this.field_145850_b, pos) || toReplaceOther != null && toReplaceOther.func_215686_e((IBlockReader)this.field_145850_b, pos)) || placingAir)) {
            return true;
        }
        return this.replaceMode == 0 && !toReplace.func_215686_e((IBlockReader)this.field_145850_b, pos) && (toReplaceOther == null || !toReplaceOther.func_215686_e((IBlockReader)this.field_145850_b, pos)) && !placingAir;
    }

    protected boolean shouldIgnoreBlockState(BlockState state, TileEntity te) {
        if (state.func_177230_c() == Blocks.field_189881_dj) {
            return true;
        }
        ItemRequirement requirement = ItemRequirement.of(state, te);
        if (requirement.isEmpty()) {
            return false;
        }
        if (requirement.isInvalid()) {
            return false;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208163_P) && state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.UPPER) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208139_an) && state.func_177229_b((Property)BlockStateProperties.field_208139_an) == BedPart.HEAD) {
            return true;
        }
        return state.func_177230_c() instanceof PistonHeadBlock;
    }

    protected void tickFlyingBlocks() {
        LinkedList<LaunchedItem> toRemove = new LinkedList<LaunchedItem>();
        for (LaunchedItem b : this.flyingBlocks) {
            if (!b.update(this.field_145850_b)) continue;
            toRemove.add(b);
        }
        this.flyingBlocks.removeAll(toRemove);
    }

    protected void refillFuelIfPossible() {
        if (this.hasCreativeCrate) {
            return;
        }
        if ((double)(1.0f - this.fuelLevel + 0.0078125f) < this.getFuelAddedByGunPowder()) {
            return;
        }
        if (this.inventory.getStackInSlot(4).func_190926_b()) {
            return;
        }
        this.inventory.getStackInSlot(4).func_190918_g(1);
        this.fuelLevel = (float)((double)this.fuelLevel + this.getFuelAddedByGunPowder());
        this.sendUpdate = true;
    }

    public double getFuelAddedByGunPowder() {
        return (Double)this.config().schematicannonGunpowderWorth.get() / 100.0;
    }

    protected void tickPaperPrinter() {
        boolean outputFull;
        int BookInput = 2;
        int BookOutput = 3;
        ItemStack blueprint = this.inventory.getStackInSlot(0);
        ItemStack paper = this.inventory.extractItem(BookInput, 1, true);
        boolean bl = outputFull = this.inventory.getStackInSlot(BookOutput).func_190916_E() == this.inventory.getSlotLimit(BookOutput);
        if (paper.func_190926_b() || outputFull) {
            if (this.bookPrintingProgress != 0.0f) {
                this.sendUpdate = true;
            }
            this.bookPrintingProgress = 0.0f;
            this.dontUpdateChecklist = false;
            return;
        }
        if (!this.printer.isLoaded()) {
            if (!blueprint.func_190926_b()) {
                this.initializePrinter(blueprint);
            }
            return;
        }
        if (this.bookPrintingProgress >= 1.0f) {
            this.bookPrintingProgress = 0.0f;
            if (!this.dontUpdateChecklist) {
                this.updateChecklist();
            }
            this.dontUpdateChecklist = true;
            this.inventory.extractItem(BookInput, 1, false);
            ItemStack stack = this.checklist.createItem();
            stack.func_190920_e(this.inventory.getStackInSlot(BookOutput).func_190916_E() + 1);
            this.inventory.setStackInSlot(BookOutput, stack);
            this.sendUpdate = true;
            return;
        }
        this.bookPrintingProgress += 0.05f;
        this.sendUpdate = true;
    }

    public static BlockState stripBeltIfNotLast(BlockState blockState) {
        boolean isLastSegment = false;
        Direction facing = (Direction)blockState.func_177229_b(BeltBlock.HORIZONTAL_FACING);
        BeltSlope slope = (BeltSlope)((Object)blockState.func_177229_b(BeltBlock.SLOPE));
        boolean positive = facing.func_176743_c() == Direction.AxisDirection.POSITIVE;
        boolean start = blockState.func_177229_b(BeltBlock.PART) == BeltPart.START;
        boolean end = blockState.func_177229_b(BeltBlock.PART) == BeltPart.END;
        switch (slope) {
            case DOWNWARD: {
                isLastSegment = start;
                break;
            }
            case UPWARD: {
                isLastSegment = end;
                break;
            }
            default: {
                boolean bl = isLastSegment = positive && end || !positive && start;
            }
        }
        if (!isLastSegment) {
            blockState = blockState.func_177229_b(BeltBlock.PART) == BeltPart.MIDDLE ? Blocks.field_150350_a.func_176223_P() : (BlockState)AllBlocks.SHAFT.getDefaultState().func_206870_a((Property)AbstractShaftBlock.AXIS, (Comparable)facing.func_176746_e().func_176740_k());
        }
        return blockState;
    }

    protected void launchBlockOrBelt(BlockPos target, ItemStack icon, BlockState blockState, TileEntity tile) {
        if (AllBlocks.BELT.has(blockState)) {
            blockState = SchematicannonTileEntity.stripBeltIfNotLast(blockState);
            if (tile instanceof BeltTileEntity && AllBlocks.BELT.has(blockState)) {
                this.launchBelt(target, blockState, ((BeltTileEntity)tile).beltLength);
            } else {
                this.launchBlock(target, icon, blockState, null);
            }
        } else {
            CompoundNBT data = null;
            if (tile != null) {
                if (AllTags.AllBlockTags.SAFE_NBT.matches(blockState)) {
                    data = tile.func_189515_b(new CompoundNBT());
                    data = NBTProcessors.process(tile, data, true);
                } else if (tile instanceof IPartialSafeNBT) {
                    data = new CompoundNBT();
                    ((IPartialSafeNBT)tile).writeSafe(data, false);
                    data = NBTProcessors.process(tile, data, true);
                }
            }
            this.launchBlock(target, icon, blockState, data);
        }
    }

    protected void launchBelt(BlockPos target, BlockState state, int length) {
        ++this.blocksPlaced;
        ItemStack connector = AllItems.BELT_CONNECTOR.asStack();
        this.flyingBlocks.add(new LaunchedItem.ForBelt(this.func_174877_v(), target, connector, state, length));
        this.playFiringSound();
    }

    protected void launchBlock(BlockPos target, ItemStack stack, BlockState state, @Nullable CompoundNBT data) {
        if (!state.func_177230_c().isAir(state, (IBlockReader)this.field_145850_b, target)) {
            ++this.blocksPlaced;
        }
        this.flyingBlocks.add(new LaunchedItem.ForBlockState(this.func_174877_v(), target, stack, state, data));
        this.playFiringSound();
    }

    protected void launchEntity(BlockPos target, ItemStack stack, Entity entity) {
        ++this.blocksPlaced;
        this.flyingBlocks.add(new LaunchedItem.ForEntity(this.func_174877_v(), target, stack, entity));
        this.playFiringSound();
    }

    public void playFiringSound() {
        AllSoundEvents.SCHEMATICANNON_LAUNCH_BLOCK.playOnServer(this.field_145850_b, this.field_174879_c);
    }

    @Override
    public void sendToContainer(PacketBuffer buffer) {
        buffer.func_179255_a(this.func_174877_v());
        buffer.func_150786_a(this.func_189517_E_());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return SchematicannonContainer.create(id, inv, this);
    }

    public ITextComponent func_145748_c_() {
        return Lang.translate("gui.schematicannon.title", new Object[0]);
    }

    public void updateChecklist() {
        this.checklist.required.clear();
        this.checklist.damageRequired.clear();
        this.checklist.blocksNotLoaded = false;
        if (this.printer.isLoaded()) {
            this.blocksToPlace = this.blocksPlaced;
            this.blocksToPlace += this.printer.markAllBlockRequirements(this.checklist, this.field_145850_b, this::shouldPlace);
            this.printer.markAllEntityRequirements(this.checklist);
        }
        this.checklist.gathered.clear();
        this.findInventories();
        for (LazyOptional lazyOptional : this.attachedInventories) {
            if (!lazyOptional.isPresent()) continue;
            IItemHandler inventory = (IItemHandler)lazyOptional.orElse((Object)EmptyHandler.INSTANCE);
            for (int slot = 0; slot < inventory.getSlots(); ++slot) {
                ItemStack stackInSlot = inventory.getStackInSlot(slot);
                if (inventory.extractItem(slot, 1, true).func_190926_b()) continue;
                this.checklist.collect(stackInSlot);
            }
        }
        this.sendUpdate = true;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.findInventories();
    }

    public boolean shouldRenderNormally() {
        return true;
    }

    public static enum State {
        STOPPED,
        PAUSED,
        RUNNING;

    }
}

