/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility.placement;

import com.simibubi.create.CreateClient;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
public interface IPlacementHelper {
    public static final BlockState ID = new BlockState(Blocks.field_150350_a, null, null);

    public Predicate<ItemStack> getItemPredicate();

    public Predicate<BlockState> getStatePredicate();

    public PlacementOffset getOffset(PlayerEntity var1, World var2, BlockState var3, BlockPos var4, BlockRayTraceResult var5);

    default public PlacementOffset getOffset(PlayerEntity player, World world, BlockState state, BlockPos pos, BlockRayTraceResult ray, ItemStack heldItem) {
        PlacementOffset offset = this.getOffset(player, world, state, pos, ray);
        if (heldItem.func_77973_b() instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)heldItem.func_77973_b();
            offset = offset.withGhostState(blockItem.func_179223_d().func_176223_P());
        }
        return offset;
    }

    default public void renderAt(BlockPos pos, BlockState state, BlockRayTraceResult ray, PlacementOffset offset) {
        this.displayGhost(offset);
    }

    public static void renderArrow(Vector3d center, Vector3d target, Direction arrowPlane) {
        IPlacementHelper.renderArrow(center, target, arrowPlane, 1.0);
    }

    public static void renderArrow(Vector3d center, Vector3d target, Direction arrowPlane, double distanceFromCenter) {
        Vector3d direction = target.func_178788_d(center).func_72432_b();
        Vector3d facing = Vector3d.func_237491_b_((Vector3i)arrowPlane.func_176730_m());
        Vector3d start = center.func_178787_e(direction);
        Vector3d offset = direction.func_186678_a(distanceFromCenter - 1.0);
        Vector3d offsetA = direction.func_72431_c(facing).func_72432_b().func_186678_a(0.25);
        Vector3d offsetB = facing.func_72431_c(direction).func_72432_b().func_186678_a(0.25);
        Vector3d endA = center.func_178787_e(direction.func_186678_a(0.75)).func_178787_e(offsetA);
        Vector3d endB = center.func_178787_e(direction.func_186678_a(0.75)).func_178787_e(offsetB);
        CreateClient.OUTLINER.showLine("placementArrowA" + center + target, start.func_178787_e(offset), endA.func_178787_e(offset)).lineWidth(0.0625f);
        CreateClient.OUTLINER.showLine("placementArrowB" + center + target, start.func_178787_e(offset), endB.func_178787_e(offset)).lineWidth(0.0625f);
    }

    default public void displayGhost(PlacementOffset offset) {
        if (!offset.hasGhostState()) {
            return;
        }
        CreateClient.GHOST_BLOCKS.showGhostState(this, offset.getTransform().apply(offset.getGhostState())).at(offset.getBlockPos()).breathingAlpha();
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vector3d hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, dir -> dir.func_176740_k() == axis);
    }

    public static List<Direction> orderedByDistanceOnlyAxis(BlockPos pos, Vector3d hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.func_176740_k() == axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vector3d hit, Direction.Axis axis) {
        return IPlacementHelper.orderedByDistance(pos, hit, dir -> dir.func_176740_k() != axis);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vector3d hit, Direction.Axis axis, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistance(pos, hit, ((Predicate<Direction>)dir -> dir.func_176740_k() != axis).and(includeDirection));
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vector3d hit, Direction.Axis first, Direction.Axis second) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, (Direction d) -> d.func_176740_k() != second);
    }

    public static List<Direction> orderedByDistanceExceptAxis(BlockPos pos, Vector3d hit, Direction.Axis first, Direction.Axis second, Predicate<Direction> includeDirection) {
        return IPlacementHelper.orderedByDistanceExceptAxis(pos, hit, first, ((Predicate<Direction>)d -> d.func_176740_k() != second).and(includeDirection));
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vector3d hit) {
        return IPlacementHelper.orderedByDistance(pos, hit, _$ -> true);
    }

    public static List<Direction> orderedByDistance(BlockPos pos, Vector3d hit, Predicate<Direction> includeDirection) {
        Vector3d centerToHit = hit.func_178788_d(VecHelper.getCenterOf((Vector3i)pos));
        return Arrays.stream(Iterate.directions).filter(includeDirection).map(dir -> Pair.of(dir, Vector3d.func_237491_b_((Vector3i)dir.func_176730_m()).func_72438_d(centerToHit))).sorted(Comparator.comparingDouble(Pair::getSecond)).map(Pair::getFirst).collect(Collectors.toList());
    }

    default public boolean matchesItem(ItemStack item) {
        return this.getItemPredicate().test(item);
    }

    default public boolean matchesState(BlockState state) {
        return this.getStatePredicate().test(state);
    }
}

