/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.ltmoveplus.forge;

import com.corosus.ltmoveplus.config.MovePlusCfgForge;
import com.corosus.ltmoveplus.forge.EventHandlerForge;
import com.corosus.ltmoveplus.forge.MovePlus;
import com.corosus.ltmoveplus.network.MovePlusNetwork;
import com.corosus.ltmoveplus.network.ToServerPlayerCrawlState;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ClientTicker {
    public static boolean needsInit = true;
    public static Vector3d prevMotion;
    public static HashMap<KeyBinding, Long> keyTimesLastPressed;
    public static HashMap<KeyBinding, Boolean> keyLastState;
    public static HashMap<KeyBinding, Vector2f> lookupKeyToDirection;
    public static boolean keepSpectatingPlayer;
    public static String lastPlayerSpectated;
    public static long lastTick;
    public static boolean debug;
    public static int syncDelay;
    public static String csvSpecPlayers;
    public static HashMap<Class, String> cacheClassToCanonicalName;
    public static boolean spectateFixes;

    public static void tickInit() {
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, new Vector2f(1.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, new Vector2f(-1.0f, 0.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, new Vector2f(0.0f, -1.0f));
        lookupKeyToDirection.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, new Vector2f(0.0f, 1.0f));
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74351_w, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74368_y, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74370_x, false);
        keyLastState.put(Minecraft.func_71410_x().field_71474_y.field_74366_z, false);
    }

    public static void tickClientRender() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (player == null || camera == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (!(mc.field_71462_r != null || ((Boolean)MovePlusCfgForge.GENERAL.dontGroundDodgeIfSneaking.get()).booleanValue() && player.func_225608_bj_() || !((Boolean)MovePlusCfgForge.GENERAL.useGroundDodge.get()).booleanValue())) {
            ClientTicker.tickDodging();
        }
    }

    public static void tickClientRenderScreen(RenderGameOverlayEvent.Pre event) {
    }

    public static void tickClientRenderWorldLast() {
    }

    public static void tickClientGame() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        if (player == null || camera == null) {
            return;
        }
        if (needsInit) {
            needsInit = false;
            ClientTicker.tickInit();
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            if (((Boolean)MovePlusCfgForge.GENERAL.useLedgeClimb.get()).booleanValue()) {
                ClientTicker.tickLedgeClimb();
            }
            if ((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get() > 0.0) {
                ClientTicker.tickKnockbackResistence();
            }
        }
        ClientTicker.tickSpectating();
        if (((Boolean)MovePlusCfgForge.GENERAL.useCrawlAnywhere.get()).booleanValue()) {
            ClientTicker.tickCrawl();
        }
    }

    public static void tickSpectating() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        Minecraft mc = Minecraft.func_71410_x();
        long curTime = System.currentTimeMillis();
        if (player == null || camera == null) {
            return;
        }
        if (spectateFixes) {
            Entity specEnt = mc.func_175606_aa();
            ClientPlayerEntity clientPlayer = mc.field_71439_g;
            if (specEnt != null && player != null && player.field_70170_p != null && player.func_175149_v()) {
                if (curTime > lastTick + (long)syncDelay) {
                    lastTick = curTime;
                    if (specEnt != clientPlayer) {
                        lastPlayerSpectated = specEnt.func_200200_C_().getString();
                        keepSpectatingPlayer = true;
                        ClientTicker.dbg("syncing client player to spectator position: " + specEnt);
                        clientPlayer.func_70107_b(specEnt.func_226277_ct_(), specEnt.func_226278_cu_(), specEnt.func_226281_cx_());
                    }
                    if (keepSpectatingPlayer && !lastPlayerSpectated.equals("")) {
                        boolean ghostPlayer = false;
                        boolean diffDimensionPlayer = false;
                        AbstractClientPlayerEntity foundNonSpectatingPlayerInSameDimension = null;
                        for (AbstractClientPlayerEntity otherPlayer : mc.field_71441_e.func_217369_A()) {
                            if (!otherPlayer.func_200200_C_().getString().equals(lastPlayerSpectated)) continue;
                            foundNonSpectatingPlayerInSameDimension = otherPlayer;
                        }
                        ClientPlayNetHandler clientplaynethandler = mc.field_71439_g.field_71174_a;
                        NetworkPlayerInfo netInfo = clientplaynethandler.func_175104_a(lastPlayerSpectated);
                        if (netInfo == null) {
                            ClientTicker.dbg("detected target player not on server");
                        } else if (foundNonSpectatingPlayerInSameDimension == null) {
                            ClientTicker.dbg("detected player in diff dimension");
                            diffDimensionPlayer = true;
                        }
                        boolean isSpectatingASpectator = false;
                        if (specEnt != clientPlayer && specEnt.func_175149_v()) {
                            isSpectatingASpectator = true;
                        }
                        if (diffDimensionPlayer && !isSpectatingASpectator) {
                            clientPlayer.func_71165_d("/tp " + clientPlayer.func_200200_C_().getString() + " " + lastPlayerSpectated);
                            clientPlayer.func_71165_d("/spectate");
                            clientPlayer.func_71165_d("/spectate " + lastPlayerSpectated);
                        }
                        if (foundNonSpectatingPlayerInSameDimension != null && foundNonSpectatingPlayerInSameDimension != specEnt) {
                            ghostPlayer = true;
                        }
                        if (ghostPlayer) {
                            clientPlayer.func_71165_d("/spectate");
                            clientPlayer.func_71165_d("/spectate " + lastPlayerSpectated);
                        }
                        boolean noPlayerToTrack = foundNonSpectatingPlayerInSameDimension == null && !diffDimensionPlayer;
                        boolean usePlayerList = true;
                        if (usePlayerList && !csvSpecPlayers.equals("") && !csvSpecPlayers.equals("OFF")) {
                            ClientTicker.dbg("spec cycle starting: " + csvSpecPlayers);
                            String[] names = csvSpecPlayers.split(",");
                            boolean abort = false;
                            block1: for (int i = 0; i < names.length && !abort; ++i) {
                                names[i] = names[i].trim();
                                ClientTicker.dbg("spec cycle considering: " + names[i]);
                                AbstractClientPlayerEntity foundNonSpectatingPlayerInSameDimension2 = null;
                                for (AbstractClientPlayerEntity otherPlayer : mc.field_71441_e.func_217369_A()) {
                                    if (abort) continue block1;
                                    if (!otherPlayer.func_200200_C_().getString().equals(names[i])) continue;
                                    foundNonSpectatingPlayerInSameDimension2 = otherPlayer;
                                    if (!lastPlayerSpectated.equals(foundNonSpectatingPlayerInSameDimension2.func_200200_C_().getString())) {
                                        lastPlayerSpectated = foundNonSpectatingPlayerInSameDimension2.func_200200_C_().getString();
                                        ClientTicker.dbg("spec cycle found: " + names[i] + " in dim to spectate, setting " + lastPlayerSpectated);
                                        clientPlayer.func_71165_d("/spectate");
                                        clientPlayer.func_71165_d("/spectate " + lastPlayerSpectated);
                                        abort = true;
                                        continue;
                                    }
                                    abort = true;
                                }
                            }
                        }
                    }
                }
                if (clientPlayer.func_225608_bj_()) {
                    keepSpectatingPlayer = false;
                    lastPlayerSpectated = "";
                    ClientTicker.dbg("setting keepSpectatingPlayer = false");
                }
            }
        }
    }

    public static void clientChatEvent(ClientChatEvent event) {
        if (!spectateFixes) {
            return;
        }
        ClientTicker.dbg("intercepting chat event: " + event.getMessage());
        if (event.getMessage().startsWith("/mp_spec_csv")) {
            ClientTicker.dbg("mp_spec_csv firing");
            try {
                String[] args = event.getMessage().split(" ");
                csvSpecPlayers = args[1];
                ClientTicker.dbg("csvSpecPlayers set to: " + csvSpecPlayers);
                event.setCanceled(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void dbg(Object obj) {
        if (debug) {
            System.out.println(obj);
        }
    }

    public static void tickDodging() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        lookupKeyToDirection.forEach((k, v) -> ClientTicker.processDodgeKey(k, v));
    }

    public static void processDodgeKey(KeyBinding key, Vector2f vec) {
        long curTime = System.currentTimeMillis();
        long lastTime = ClientTicker.getLastKeyTime(key);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (key.func_151470_d() && !keyLastState.get(key).booleanValue()) {
            if (lastTime == -1L) {
                ClientTicker.setLastKeyTime(key, curTime);
            } else if (player.func_233570_aj_() && lastTime + (long)((Integer)MovePlusCfgForge.GENERAL.doubleTapDodgeMaxTimeInMilliseconds.get()).intValue() > curTime) {
                double forceVertical = (Double)MovePlusCfgForge.GENERAL.groundDodgeForceVertical.get();
                double forceHorizontal = (Double)MovePlusCfgForge.GENERAL.groundDodgeForceHorizontal.get();
                ClientTicker.setRelVel((Entity)player, vec.field_189983_j, (float)forceVertical, vec.field_189982_i, (float)forceHorizontal);
                ClientTicker.setLastKeyTime(key, -1L);
                MovePlus.LOGGER.info(":|");
                ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.CLIENT, FMLPaths.CONFIGDIR.get());
            } else {
                ClientTicker.setLastKeyTime(key, curTime);
            }
        }
        if (!key.func_151470_d() && keyLastState.get(key).booleanValue()) {
            for (Map.Entry<KeyBinding, Long> entry : keyTimesLastPressed.entrySet()) {
                if (entry.getKey() == key) continue;
                entry.setValue(-1L);
            }
        }
        keyLastState.put(key, key.func_151470_d());
    }

    public static void tickLedgeClimb() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Entity camera = Minecraft.func_71410_x().func_175606_aa();
        boolean renderDebug = true;
        if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d()) {
            float climbSpeed;
            float grabDist = 0.75f;
            Vector3d lookVec = player.func_70040_Z().func_186678_a((double)grabDist);
            Vector3d lookVecBehind = player.func_70040_Z().func_186678_a(-0.25);
            double yScanRangeAir = (double)player.func_213302_cg() + 0.2;
            double yScanRangeSolid = 0.4;
            double yScanRes = 0.2;
            double yAirSize = 0.25;
            double xzSize = 0.3;
            double xzSizeBehind = 0.1;
            AxisAlignedBB playerAABB = player.func_174813_aQ();
            AxisAlignedBB spotForHandsAir = new AxisAlignedBB(player.func_226277_ct_() + lookVec.field_72450_a, playerAABB.field_72338_b, player.func_226281_cx_() + lookVec.field_72449_c, player.func_226277_ct_() + lookVec.field_72450_a, playerAABB.field_72338_b, player.func_226281_cx_() + lookVec.field_72449_c).func_72314_b(xzSize, yAirSize, xzSize);
            AxisAlignedBB behindUnderFeet = new AxisAlignedBB(player.func_226277_ct_() + lookVecBehind.field_72450_a, playerAABB.field_72338_b, player.func_226281_cx_() + lookVecBehind.field_72449_c, player.func_226277_ct_() + lookVecBehind.field_72450_a, playerAABB.field_72338_b, player.func_226281_cx_() + lookVecBehind.field_72449_c).func_72314_b(xzSizeBehind, xzSizeBehind, xzSizeBehind);
            if (renderDebug) {
                ClientTicker.renderOffsetAABB(behindUnderFeet.func_72317_d(-player.func_226277_ct_(), -playerAABB.field_72338_b, -player.func_226281_cx_()), 0.0, 0.0, 0.0, 0.0f, 1.0f, 0.0f);
            }
            boolean foundGrabbableSpot = false;
            if (!player.func_233570_aj_() && player.field_70170_p.func_226665_a__((Entity)player, behindUnderFeet)) {
                block0: for (double y = yScanRangeAir; y > 0.25 && !foundGrabbableSpot; y -= yScanRes) {
                    if (!player.field_70170_p.func_226665_a__((Entity)player, spotForHandsAir.func_72317_d(0.0, y, 0.0))) continue;
                    AxisAlignedBB aabbRenderAir = spotForHandsAir.func_72317_d(-player.func_226277_ct_(), -playerAABB.field_72338_b + y, -player.func_226281_cx_());
                    if (renderDebug) {
                        ClientTicker.renderOffsetAABB(aabbRenderAir.func_72314_b(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 0.0f, 0.0f, 1.0f);
                    }
                    for (double y2 = 0.0; y2 < yScanRangeSolid; y2 += yScanRes) {
                        AxisAlignedBB aabbTry2 = spotForHandsAir.func_72317_d(0.0, y - yAirSize * 1.0 - y2, 0.0);
                        AxisAlignedBB aabbRenderSolid = aabbTry2.func_72317_d(-player.func_226277_ct_(), -playerAABB.field_72338_b, -player.func_226281_cx_());
                        AxisAlignedBB aabb2 = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72314_b(1.0, 1.0, 1.0);
                        if (player.field_70170_p.func_226665_a__((Entity)player, aabbTry2) || !(aabbTry2.field_72338_b + 0.15 > playerAABB.field_72338_b)) continue;
                        foundGrabbableSpot = true;
                        if (!renderDebug) continue block0;
                        ClientTicker.renderOffsetAABB(aabbRenderSolid.func_72314_b(xzSize, 0.0, xzSize), 0.0, 0.0, 0.0, 1.0f, 0.0f, 0.0f);
                        continue block0;
                    }
                }
            }
            if (foundGrabbableSpot && player.func_213322_ci().field_72448_b < (double)(climbSpeed = 0.08f)) {
                Vector3d speed = player.func_213322_ci();
                player.func_213293_j(speed.field_72450_a, (double)climbSpeed, speed.field_72449_c);
            }
        }
    }

    public static void tickKnockbackResistence() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        float speed = (float)player.func_213322_ci().func_189985_c();
        if (player.field_70737_aN > 0) {
            player.field_70737_aN = 0;
            if ((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get() == 1.0) {
                player.func_213317_d(prevMotion);
            } else {
                player.func_213293_j(ClientTicker.prevMotion.field_72450_a + player.func_213322_ci().field_72450_a * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)), ClientTicker.prevMotion.field_72448_b + player.func_213322_ci().field_72448_b > 0.1 ? 0.0 : player.func_213322_ci().field_72448_b * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)), ClientTicker.prevMotion.field_72449_c + player.func_213322_ci().field_72450_a * (1.0 - Math.min((Double)MovePlusCfgForge.GENERAL.knockbackResistAmount.get(), 1.0)));
            }
        } else {
            prevMotion = player.func_213322_ci().func_186678_a(1.0);
        }
    }

    public static long getLastKeyTime(KeyBinding keybind) {
        if (!keyTimesLastPressed.containsKey(keybind)) {
            keyTimesLastPressed.put(keybind, -1L);
        }
        return keyTimesLastPressed.get(keybind);
    }

    public static void setLastKeyTime(KeyBinding keybind, long time) {
        keyTimesLastPressed.put(keybind, time);
    }

    public static void setRelVel(Entity entity, float rightSpeed, float y, float forwardSpeed, float horizontalMultiplier) {
        float var5 = 10.0f;
        float var6 = 0.0f;
        float var7 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * var5;
        int var8 = (int)Math.floor((double)(var7 / 360.0f) + 0.5);
        var7 = var7 - (float)var8 * 360.0f + 270.0f;
        if (forwardSpeed <= 0.0f && forwardSpeed < 0.0f) {
            var7 += 180.0f;
        }
        if (rightSpeed > 0.0f) {
            var7 += 90.0f - forwardSpeed * 10.0f;
        } else if (rightSpeed < 0.0f) {
            var7 += 270.0f + forwardSpeed * 10.0f;
        }
        float var9 = MathHelper.func_76134_b((float)(-var7 * 0.01745329f - 3.141593f));
        float var10 = MathHelper.func_76126_a((float)(-var7 * 0.01745329f - 3.141593f));
        float var11 = -MathHelper.func_76134_b((float)(-var6 * 0.01745329f - 0.7853982f));
        float var13 = var9 * var11;
        float var15 = var10 * var11;
        if (rightSpeed == 0.0f && forwardSpeed == 0.0f) {
            ClientTicker.AddHorizAndSetVerticalVel(entity, (float)entity.func_213322_ci().field_72450_a / 2.0f, y, (float)entity.func_213322_ci().field_72449_c / 2.0f);
        } else {
            ClientTicker.AddHorizAndSetVerticalVel(entity, var13 * horizontalMultiplier * -1.0f, y, var15 * horizontalMultiplier);
        }
    }

    public static void AddHorizAndSetVerticalVel(Entity entity, float x, float y, float z) {
        entity.func_213317_d(new Vector3d(entity.func_213322_ci().field_72450_a + (double)x, (double)y, entity.func_213322_ci().field_72449_c + (double)z));
    }

    public static void renderOffsetAABB(AxisAlignedBB bounds, double x, double y, double z, float r, float g, float b) {
    }

    public static String getCanonicalNameCached(Class clazz) {
        if (!cacheClassToCanonicalName.containsKey(clazz)) {
            cacheClassToCanonicalName.put(clazz, clazz.getCanonicalName());
        }
        return cacheClassToCanonicalName.get(clazz);
    }

    public static void tickCrawl() {
        try {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                KeyBinding keySneak = Minecraft.func_71410_x().field_71474_y.field_228046_af_;
                KeyBinding keySprint = Minecraft.func_71410_x().field_71474_y.field_151444_V;
                if (keySneak.func_151470_d()) {
                    if (keySprint.func_151470_d() && !ClientTicker.isCurrentlyCrawling()) {
                        ClientTicker.setCrawling(true);
                        ClientTicker.sendCrawlPacketToServer(true);
                    }
                } else {
                    if (ClientTicker.isCurrentlyCrawling()) {
                        ClientTicker.sendCrawlPacketToServer(false);
                    }
                    ClientTicker.setCrawling(false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isCurrentlyCrawling() {
        return EventHandlerForge.playerCrawlingClient;
    }

    public static void setCrawling(boolean crawling) {
        EventHandlerForge.playerCrawlingClient = crawling;
    }

    public static void sendCrawlPacketToServer(boolean isCrawling) {
        MovePlusNetwork.CHANNEL.sendToServer((Object)new ToServerPlayerCrawlState(isCrawling));
    }

    public static boolean isMainClientPlayer(PlayerEntity player) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        return player.func_110124_au() == Minecraft.func_71410_x().field_71439_g.func_110124_au();
    }

    static {
        keyTimesLastPressed = new HashMap();
        keyLastState = new HashMap();
        lookupKeyToDirection = new HashMap();
        keepSpectatingPlayer = false;
        lastPlayerSpectated = "";
        lastTick = 0L;
        debug = false;
        syncDelay = 5000;
        csvSpecPlayers = "";
        cacheClassToCanonicalName = new HashMap();
        spectateFixes = false;
    }
}

