/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.common.entity.underdasea.EagleRayEntity;

public class EagleRayModel
extends SegmentedModel<EagleRayEntity> {
    private float[] interpolatedWingAmplitudes = new float[10];
    private ModelRenderer body;

    public EagleRayModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 64;
        this.body = new ModelRenderer((Model)this, 32, 0);
        this.body.func_228300_a_(-2.0f, 0.0f, 0.0f, 5.0f, 3.0f, 32.0f);
        this.body.func_78793_a(0.0f, 0.0f, -8.0f);
        this.body.func_78787_b(128, 64);
        this.body.field_78809_i = true;
    }

    public void setRotationAngles(EagleRayEntity eagleRay, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)this.body);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        super.func_225598_a_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderWings(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        this.renderTailSimple(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    private void renderTailSimple(MatrixStack stack, IVertexBuilder buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        float minU = 0.75f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 0.5f;
        stack.func_227860_a_();
        stack.func_227861_a_((double)0.55f, 0.0, 1.5);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        stack.func_227862_a_(1.5f, 1.0f, 1.0f);
        EagleRayModel.vertex(buffer, stack.func_227866_c_().func_227870_a_(), stack.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 0.0f, red, green, blue, alpha, minU, minV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.func_227866_c_().func_227870_a_(), stack.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 1.0f, red, green, blue, alpha, minU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.func_227866_c_().func_227870_a_(), stack.func_227866_c_().func_227872_b_(), 1.0f, 0.0f, 1.0f, red, green, blue, alpha, maxU, maxV, packedLightIn, packedOverlayIn);
        EagleRayModel.vertex(buffer, stack.func_227866_c_().func_227870_a_(), stack.func_227866_c_().func_227872_b_(), 1.0f, 0.0f, 0.0f, red, green, blue, alpha, maxU, minV, packedLightIn, packedOverlayIn);
        stack.func_227865_b_();
    }

    private static void vertex(IVertexBuilder bufferIn, Matrix4f matrixIn, Matrix3f matrixNormalIn, float x, float y, float z, float red, float green, float blue, float alpha, float texU, float texV, int packedLight, int packedOverlay) {
        bufferIn.func_227888_a_(matrixIn, x, y, z).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(packedOverlay).func_227886_a_(packedLight).func_227887_a_(matrixNormalIn, 0.0f, -1.0f, 0.0f).func_181675_d();
    }

    private void renderWings(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.03125, 0.0, -0.5);
        matrixStackIn.func_227862_a_(2.0f, 0.5f, 2.0f);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, false);
        matrixStackIn.func_227861_a_(0.0, 0.0, 0.5);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        matrixStackIn.func_227861_a_(0.0, 0.0, -0.5);
        this.renderWing(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha, true);
        matrixStackIn.func_227865_b_();
    }

    private void renderWing(MatrixStack stack, IVertexBuilder buffer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha, boolean reverse) {
        float minUFront = 0.0f;
        float maxUFront = 0.25f;
        float minVFront = 0.0f;
        float maxVFront = 0.5f;
        float minUBack = 0.0f;
        float maxUBack = 0.25f;
        float minVBack = 0.5f;
        float maxVBack = 1.0f;
        stack.func_227860_a_();
        stack.func_227861_a_(0.078125, 0.0, 0.0);
        for (int i = 1; i < 10; ++i) {
            float prevAmplitude = this.interpolatedWingAmplitudes[i - 1];
            float amplitude = this.interpolatedWingAmplitudes[i];
            float prevX = (float)(i - 1) / 9.0f;
            float x = (float)i / 9.0f;
            float prevUFront = minUFront + (maxUFront - minUFront) * prevX;
            float uFront = minUFront + (maxUFront - minUFront) * x;
            float prevUBack = minUBack + (maxUBack - minUBack) * prevX;
            float uBack = minUBack + (maxUBack - minUBack) * x;
            float offset = -0.001f;
            Matrix4f matrix = stack.func_227866_c_().func_227870_a_();
            Matrix3f normal = stack.func_227866_c_().func_227872_b_();
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude - offset, 0.0f, red, green, blue, alpha, uBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude - offset, 1.0f, red, green, blue, alpha, uBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude - offset, 1.0f, red, green, blue, alpha, prevUBack, reverse ? minVBack : maxVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude - offset, 0.0f, red, green, blue, alpha, prevUBack, reverse ? maxVBack : minVBack, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude, 0.0f, red, green, blue, alpha, prevUFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, prevX, prevAmplitude, 1.0f, red, green, blue, alpha, prevUFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude, 1.0f, red, green, blue, alpha, uFront, reverse ? minVFront : maxVFront, packedLightIn, packedOverlayIn);
            EagleRayModel.vertex(buffer, matrix, normal, x, amplitude, 0.0f, red, green, blue, alpha, uFront, reverse ? maxVFront : minVFront, packedLightIn, packedOverlayIn);
        }
        stack.func_227865_b_();
    }

    public void setLivingAnimations(EagleRayEntity ray, float par2, float par3, float partialTicks) {
        float[] prevWingAmplitudes = ray.getPrevWingAmplitudes();
        float[] wingAmplitudes = ray.getWingAmplitudes();
        for (int i = 1; i < 10; ++i) {
            float prevWingAmplitude = prevWingAmplitudes[i];
            float wingAmplitude = wingAmplitudes[i];
            this.interpolatedWingAmplitudes[i] = prevWingAmplitude + partialTicks * (wingAmplitude - prevWingAmplitude);
        }
    }
}

