/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.EggModel;
import net.tropicraft.core.common.entity.egg.EggEntity;

public class EggRenderer
extends LivingRenderer<EggEntity, EggModel> {
    public EggRenderer(EntityRendererManager rendererManager) {
        super(rendererManager, (EntityModel)new EggModel(), 1.0f);
        this.field_76987_f = 0.5f;
    }

    public void render(EggEntity egg, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        stack.func_227860_a_();
        if (egg.shouldEggRenderFlat()) {
            this.field_76989_e = 0.0f;
            stack.func_227861_a_(0.0, 0.05, 0.0);
            this.drawFlatEgg(egg, partialTicks, stack, bufferIn, packedLightIn);
        } else {
            this.field_76989_e = 0.2f;
            stack.func_227862_a_(0.5f, 0.5f, 0.5f);
            super.func_225623_a_((LivingEntity)egg, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        }
        stack.func_227865_b_();
    }

    public void drawFlatEgg(EggEntity ent, float partialTicks, MatrixStack stack, IRenderTypeBuffer bufferIn, int packedLightIn) {
        stack.func_227860_a_();
        stack.func_227863_a_(this.field_76990_c.func_229098_b_());
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
        stack.func_227862_a_(0.25f, 0.25f, 0.25f);
        IVertexBuilder buffer = TropicraftRenderUtils.getEntityCutoutBuilder(bufferIn, this.getEntityTexture(ent));
        int overlay = EggRenderer.func_229117_c_((LivingEntity)ent, (float)this.func_225625_b_(ent, partialTicks));
        Matrix4f mat = stack.func_227866_c_().func_227870_a_();
        Matrix3f normal = new Matrix3f();
        normal.func_226119_c_();
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, -0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, 0.5, -0.25, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, 0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        TropicraftSpecialRenderHelper.vertex(buffer, mat, normal, -0.5, 0.75, 0.0, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP, packedLightIn, overlay);
        stack.func_227865_b_();
    }

    protected boolean canRenderName(EggEntity entity) {
        return entity.func_145818_k_();
    }

    public ResourceLocation getEntityTexture(EggEntity entity) {
        return TropicraftRenderUtils.bindTextureEntity(entity.getEggTexture());
    }
}

