/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.common.ColorHelper;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;

public class FurnitureRenderer<T extends FurnitureEntity>
extends EntityRenderer<T> {
    private final String textureName;
    private final EntityModel<T> model;
    private final float scale;
    private float red = 0.0f;
    private float green = 0.0f;
    private float blue = 0.0f;

    public FurnitureRenderer(EntityRendererManager renderManager, String textureName, EntityModel<T> model) {
        this(renderManager, textureName, model, 1.0f);
    }

    public FurnitureRenderer(EntityRendererManager renderManager, String textureName, EntityModel<T> model, float scale) {
        super(renderManager);
        this.textureName = textureName;
        this.model = model;
        this.scale = scale;
    }

    public void render(T furniture, float entityYaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int packedLightIn) {
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, this.getYOffset(), 0.0);
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - entityYaw));
        stack.func_227862_a_(this.scale, this.scale, this.scale);
        this.setupTransforms(stack);
        float rockingAngle = this.getRockingAngle(furniture, partialTicks);
        if (!MathHelper.func_180185_a((float)rockingAngle, (float)0.0f)) {
            stack.func_227863_a_(new Quaternion(this.getRockingAxis(), rockingAngle, true));
        }
        int color = ((FurnitureEntity)((Object)furniture)).getColor().getColorValue();
        this.red = ColorHelper.getRed(color);
        this.green = ColorHelper.getGreen(color);
        this.blue = ColorHelper.getBlue(color);
        IVertexBuilder ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(TropicraftRenderUtils.getTextureEntity(this.textureName + "_base_layer")));
        stack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.model.func_225598_a_(stack, ivertexbuilder, this.func_229100_c_((Entity)furniture, partialTicks), OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        ivertexbuilder = buffer.getBuffer(this.model.func_228282_a_(TropicraftRenderUtils.getTextureEntity(this.textureName + "_color_layer")));
        this.model.func_225598_a_(stack, ivertexbuilder, this.func_229100_c_((Entity)furniture, partialTicks), OverlayTexture.field_229196_a_, this.red, this.green, this.blue, 1.0f);
        super.func_225623_a_(furniture, entityYaw, partialTicks, stack, buffer, packedLightIn);
        stack.func_227865_b_();
    }

    protected double getYOffset() {
        return 0.3125;
    }

    protected void setupTransforms(MatrixStack stack) {
    }

    protected float getRockingAngle(T entity, float partialTicks) {
        float f2 = (float)((FurnitureEntity)((Object)entity)).getTimeSinceHit() - partialTicks;
        float f3 = ((FurnitureEntity)((Object)entity)).getDamage() - partialTicks;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f2 > 0.0f) {
            return MathHelper.func_76126_a((float)f2) * f2 * f3 / this.getRockAmount() * (float)((FurnitureEntity)((Object)entity)).getForwardDirection();
        }
        return 0.0f;
    }

    protected Vector3f getRockingAxis() {
        return new Vector3f(1.0f, 0.0f, 1.0f);
    }

    protected float getRockAmount() {
        return 10.0f;
    }

    public ResourceLocation getEntityTexture(T furniture) {
        return null;
    }
}

