/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.entity.SeaTurtleEntity;
import net.tropicraft.core.common.entity.placeable.BeachFloatEntity;
import net.tropicraft.core.common.entity.placeable.FurnitureEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="tropicraft")
public class PlayerRotationHandler {
    private static float rotationYawHead;
    private static float prevRotationYawHead;
    private static float rotationPitch;
    private static float prevRotationPitch;

    private static float interpolateAndWrap(float cur, float prev, float partial) {
        return MathHelper.func_76142_g((float)(prev + (cur - prev) * partial));
    }

    @SubscribeEvent
    public static void onRenderPlayer(RenderPlayerEvent.Pre event) {
        MatrixStack stack = event.getMatrixStack();
        IRenderTypeBuffer buffers = event.getBuffers();
        PlayerEntity p = event.getPlayer();
        Entity riding = p.func_184187_bx();
        if (riding instanceof BeachFloatEntity) {
            FurnitureEntity floaty = (FurnitureEntity)riding;
            stack.func_227860_a_();
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-(floaty.field_70126_B + event.getPartialRenderTick() * (floaty.field_70177_z - floaty.field_70126_B))));
            stack.func_227861_a_(0.0, 1.55, 1.55);
            stack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(90.0f));
            float f = PlayerRotationHandler.interpolateAndWrap(p.field_70761_aq, p.field_70760_ar, event.getPartialRenderTick());
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
            rotationYawHead = p.field_70759_as;
            prevRotationYawHead = p.field_70758_at;
            p.field_70759_as = p.field_70761_aq;
            p.field_70758_at = p.field_70760_ar;
            rotationPitch = p.field_70125_A;
            prevRotationPitch = p.field_70127_C;
            p.field_70125_A = 10.0f;
            p.field_70127_C = 10.0f;
            p.field_184619_aG = 0.0f;
            p.field_70721_aZ = 0.0f;
            p.field_184618_aE = 0.0f;
        }
        if (riding instanceof SeaTurtleEntity) {
            SeaTurtleEntity turtle = (SeaTurtleEntity)riding;
            stack.func_227860_a_();
            float pitch = PlayerRotationHandler.interpolateAndWrap(turtle.field_70125_A, turtle.field_70127_C, event.getPartialRenderTick());
            float yaw = PlayerRotationHandler.interpolateAndWrap(turtle.field_70759_as, turtle.field_70758_at, event.getPartialRenderTick());
            stack.func_227861_a_(0.0, turtle.func_70042_X() - p.func_70033_W(), 0.0);
            stack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(yaw));
            stack.func_227861_a_(0.0, -0.1, 0.0);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
            stack.func_227861_a_(0.0, 0.1, 0.0);
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(yaw));
            stack.func_227861_a_(0.0, -turtle.func_70042_X() + p.func_70033_W(), 0.0);
            Vector3d passengerOffset = new Vector3d(-0.25, 0.0, 0.0).func_178785_b((float)(-Math.toRadians(yaw) - 1.5707963267948966));
            stack.func_227861_a_(passengerOffset.func_82615_a(), 0.0, passengerOffset.func_82616_c());
            rotationPitch = p.field_70125_A;
            prevRotationPitch = p.field_70127_C;
            p.field_70125_A = 10.0f;
            p.field_70127_C = 10.0f;
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPost(RenderPlayerEvent.Post event) {
        PlayerEntity p = event.getPlayer();
        if (p.func_184187_bx() instanceof BeachFloatEntity || p.func_184187_bx() instanceof SeaTurtleEntity) {
            event.getMatrixStack().func_227865_b_();
            p.field_70125_A = rotationPitch;
            p.field_70127_C = prevRotationPitch;
        }
        if (p.func_184187_bx() instanceof BeachFloatEntity) {
            p.field_70759_as = rotationYawHead;
            p.field_70758_at = prevRotationYawHead;
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerSpecials(RenderNameplateEvent event) {
        if (event.getEntity().func_184187_bx() instanceof BeachFloatEntity) {
            event.setResult(Event.Result.DENY);
        }
    }
}

