/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.scuba.ModelScubaGear;
import net.tropicraft.core.client.tileentity.MachineRenderer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.AirCompressorTileEntity;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;

public class AirCompressorRenderer
extends MachineRenderer<AirCompressorTileEntity> {
    private final ModelScubaGear tankModel = new ModelScubaGear(0.0f, EquipmentSlotType.CHEST);

    public AirCompressorRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher, (Block)TropicraftBlocks.AIR_COMPRESSOR.get(), new EIHMachineModel(RenderType::func_228634_a_));
    }

    @Override
    protected RenderMaterial getMaterial() {
        return TropicraftRenderUtils.getTEMaterial("drink_mixer");
    }

    @Override
    protected void animationTransform(AirCompressorTileEntity te, MatrixStack stack, float partialTicks) {
        float progress = te.getBreatheProgress(partialTicks);
        float sin = 1.0f + MathHelper.func_76134_b((float)progress);
        float sc = 1.0f + 0.05f * sin;
        stack.func_227861_a_(0.0, 1.5, 0.0);
        stack.func_227862_a_(sc, sc, sc);
        stack.func_227861_a_(0.0, -1.5, 0.0);
        if ((double)progress < Math.PI) {
            float shake = MathHelper.func_76126_a((float)(te.getBreatheProgress(partialTicks) * 10.0f)) * 8.0f;
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(shake));
        }
    }

    @Override
    protected void renderIngredients(AirCompressorTileEntity te, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.isActive()) {
            stack.func_227860_a_();
            stack.func_227861_a_(-0.5, 0.5, 0.0);
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
            IVertexBuilder builder = ItemRenderer.func_229113_a_((IRenderTypeBuffer)buffer, (RenderType)RenderType.func_228640_c_((ResourceLocation)ScubaArmorItem.getArmorTexture(te.getTank().getType())), (boolean)true, (boolean)false);
            this.tankModel.showChest = true;
            this.tankModel.renderScubaGear(stack, builder, combinedLightIn, combinedOverlayIn, false);
            stack.func_227865_b_();
        }
    }
}

