/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.BambooMugModel;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.tileentity.MachineRenderer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.DrinkMixerTileEntity;
import net.tropicraft.core.common.item.CocktailItem;

public class DrinkMixerRenderer
extends MachineRenderer<DrinkMixerTileEntity> {
    private final BambooMugModel modelBambooMug = new BambooMugModel(RenderType::func_228638_b_);
    private final ItemRenderer renderItem = Minecraft.func_71410_x().func_175599_af();
    private ItemEntity dummyEntityItem;
    private static final float[][] INGREDIENT_OFFSETS = new float[][]{{0.3f, -0.5f, 0.05f}, {-0.3f, -0.5f, 0.05f}, {0.0f, 0.3f, -0.1f}};
    private static final float[][] INGREDIENT_SCALES = new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.8f, 0.8f, 0.8f}};

    public DrinkMixerRenderer(TileEntityRendererDispatcher rendererDispatcher) {
        super(rendererDispatcher, (Block)TropicraftBlocks.DRINK_MIXER.get(), new EIHMachineModel(RenderType::func_228634_a_));
    }

    @Override
    protected RenderMaterial getMaterial() {
        return TropicraftRenderUtils.getTEMaterial("drink_mixer");
    }

    @Override
    public void renderIngredients(DrinkMixerTileEntity te, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (this.dummyEntityItem == null) {
            this.dummyEntityItem = new ItemEntity((World)Minecraft.func_71410_x().field_71441_e, 0.0, 0.0, 0.0, new ItemStack((IItemProvider)Items.field_151102_aT));
        }
        NonNullList<ItemStack> ingredients = te.getIngredients();
        if (!te.isDoneMixing()) {
            for (int index = 0; index < ingredients.size(); ++index) {
                ItemStack ingredient = (ItemStack)ingredients.get(index);
                if (ingredient.func_190926_b()) continue;
                this.renderIngredient(stack, buffer, combinedOverlayIn, combinedLightIn, ingredient, index);
            }
        }
        if (te.isMixing() || !te.result.func_190926_b()) {
            stack.func_227860_a_();
            stack.func_227861_a_((double)-0.2f, -0.25, 0.0);
            if (te.isDoneMixing()) {
                this.modelBambooMug.renderLiquid = true;
                this.modelBambooMug.liquidColor = CocktailItem.getCocktailColor(te.result);
            } else {
                this.modelBambooMug.renderLiquid = false;
            }
            IVertexBuilder ivertexbuilder = buffer.getBuffer(this.modelBambooMug.func_228282_a_(TropicraftRenderUtils.getTextureTE("bamboo_mug")));
            this.modelBambooMug.func_225598_a_(stack, ivertexbuilder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            stack.func_227865_b_();
        }
    }

    private void renderIngredient(MatrixStack stack, IRenderTypeBuffer buffer, int combinedOverlayIn, int combinedLight, ItemStack ingredient, int ingredientIndex) {
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f));
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        float[] offsets = INGREDIENT_OFFSETS[ingredientIndex];
        float[] scales = INGREDIENT_SCALES[ingredientIndex];
        stack.func_227861_a_((double)offsets[0], (double)offsets[1], (double)offsets[2]);
        stack.func_227862_a_(scales[0], scales[1], scales[2]);
        this.dummyEntityItem.func_92058_a(ingredient);
        IBakedModel bakedModel = TropicraftRenderUtils.getBakedModel(this.renderItem, ingredient);
        this.renderItem.func_229111_a_(ingredient, ItemCameraTransforms.TransformType.FIXED, false, stack, buffer, combinedLight, combinedOverlayIn, bakedModel);
        stack.func_227865_b_();
    }
}

