/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.MachineModel;
import net.tropicraft.core.common.block.tileentity.IMachineTile;

public abstract class MachineRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    private final Block block;
    protected final MachineModel<T> model;

    public MachineRenderer(TileEntityRendererDispatcher rendererDispatcher, Block block, MachineModel<T> model) {
        super(rendererDispatcher);
        this.block = block;
        this.model = model;
    }

    public void func_225616_a_(T te, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        stack.func_227860_a_();
        stack.func_227861_a_(0.5, 1.5, 0.5);
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        if (te == null || te.func_145831_w() == null) {
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-90.0f));
        } else {
            BlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
            Direction facing = state.func_177230_c() != this.block ? Direction.NORTH : ((IMachineTile)te).getDirection(state);
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(facing.func_185119_l() + 90.0f));
        }
        if (te != null && ((IMachineTile)te).isActive()) {
            this.animationTransform(te, stack, partialTicks);
        }
        TropicraftRenderUtils.renderModel(this.getMaterial(), this.model, stack, buffer, combinedLightIn, combinedOverlayIn);
        if (te != null) {
            this.renderIngredients(te, stack, buffer, combinedLightIn, combinedOverlayIn);
        }
        stack.func_227865_b_();
    }

    protected abstract RenderMaterial getMaterial();

    protected void animationTransform(T te, MatrixStack stack, float partialTicks) {
        float angle = MathHelper.func_76126_a((float)((float)(157.07963267948966 * (double)((IMachineTile)te).getProgress(partialTicks)))) * 15.0f;
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
    }

    protected abstract void renderIngredients(T var1, MatrixStack var2, IRenderTypeBuffer var3, int var4, int var5);
}

