/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.sound.Sounds;

@Mod.EventBusSubscriber
public class BongoDrumBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private final Size size;

    public BongoDrumBlock(Size size, AbstractBlock.Properties properties) {
        super(properties);
        this.size = size;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    public Size getSize() {
        return this.size;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.size.shape;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (result.func_216354_b() != Direction.UP) {
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        this.playBongoSound(world, pos, state, this.getAdjustedPitch((RayTraceResult)result));
        return ActionResultType.CONSUME;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean flag = worldIn.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag) {
                this.playBongoSound(worldIn, pos, state);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        BlockState state = world.func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (state.func_177230_c() instanceof BongoDrumBlock && event.getFace() == Direction.UP) {
            ((BongoDrumBlock)block).playBongoSound(world, event.getPos(), state);
        }
    }

    public void playBongoSound(World world, BlockPos pos, BlockState state) {
        this.playBongoSound(world, pos, state, 1.0f);
    }

    public void playBongoSound(World world, BlockPos pos, BlockState state, float pitch) {
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, this.size.soundEvent.get(), SoundCategory.BLOCKS, 1.0f, pitch);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }

    public float getAdjustedPitch(RayTraceResult hitVec) {
        if (hitVec == null || hitVec.func_216347_e() == null) {
            return 1.0f;
        }
        double distX = Math.abs(hitVec.func_216347_e().field_72450_a - Math.floor(hitVec.func_216347_e().field_72450_a) - 0.5);
        double distZ = Math.abs(hitVec.func_216347_e().field_72449_c - Math.floor(hitVec.func_216347_e().field_72449_c) - 0.5);
        double dist = (float)Math.sqrt(distX * distX + distZ * distZ);
        double radiusMax = 1.0;
        if (this.size == Size.SMALL) {
            radiusMax = 0.25;
        } else if (this.size == Size.MEDIUM) {
            radiusMax = 0.3125;
        } else if (this.size == Size.LARGE) {
            radiusMax = 0.375;
        }
        double adjPitch = dist / radiusMax;
        return 1.0f + (float)adjPitch;
    }

    public static enum Size {
        SMALL(8, () -> Sounds.BONGO_HIGH),
        MEDIUM(10, () -> Sounds.BONGO_MED),
        LARGE(12, () -> Sounds.BONGO_LOW);

        public final VoxelShape shape;
        final Supplier<SoundEvent> soundEvent;

        private Size(int size, Supplier<SoundEvent> soundEvent) {
            double offset = (16 - size) / 2;
            this.shape = Block.func_208617_a((double)offset, (double)0.0, (double)offset, (double)(16.0 - offset), (double)16.0, (double)(16.0 - offset));
            this.soundEvent = soundEvent;
        }
    }
}

