/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.Tags;
import net.tropicraft.core.common.item.TropicraftItems;

public class CoffeeBushBlock
extends CropsBlock {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)6);
    public static final int MAX_HEIGHT = 3;
    public static final int GROWTH_RATE_FERTILE = 10;
    public static final int GROWTH_RATE_INFERTILE = 20;

    public CoffeeBushBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public IntegerProperty func_185524_e() {
        return AGE;
    }

    public int func_185526_g() {
        return 6;
    }

    protected IItemProvider func_199772_f() {
        return (IItemProvider)TropicraftItems.RAW_COFFEE_BEAN.get();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn.func_175623_d(pos.func_177984_a())) {
            BlockPos ground = pos;
            int height = 1;
            while (worldIn.func_180495_p(ground = ground.func_177977_b()).func_177230_c() == this) {
                ++height;
            }
            BlockState blockState = worldIn.func_180495_p(ground);
            if (height < 3 && worldIn.field_73012_v.nextInt(blockState.func_177230_c().isFertile(blockState, (IBlockReader)worldIn, ground) ? 10 : 20) == 0) {
                worldIn.func_175656_a(pos.func_177984_a(), this.func_176223_P());
            }
        }
        super.func_225534_a_(state, worldIn, pos, rand);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (((Integer)state.func_177229_b((Property)AGE)).intValue() == this.func_185526_g()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
            int count = 1 + player.func_70681_au().nextInt(3);
            ItemStack stack = new ItemStack((IItemProvider)TropicraftItems.RAW_COFFEE_BEAN.get(), count);
            CoffeeBushBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            return world.field_72995_K ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        return ActionResultType.PASS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_196658_i || Tags.Blocks.DIRT.func_230235_a_((Object)this) || state.func_177230_c() == Blocks.field_150458_ak || state.func_177230_c() == this;
    }
}

