/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.block.tileentity.DrinkMixerTileEntity;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.TropicraftItems;

public class DrinkMixerBlock
extends Block
implements ITileEntityProvider {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public DrinkMixerBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_190948_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_149739_a() + ".desc").func_240699_a_(TextFormatting.GRAY));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = player.func_184614_ca();
        DrinkMixerTileEntity mixer = (DrinkMixerTileEntity)world.func_175625_s(pos);
        if (mixer == null) {
            return ActionResultType.FAIL;
        }
        if (mixer.isDoneMixing()) {
            mixer.retrieveResult(player);
            return ActionResultType.CONSUME;
        }
        if (stack.func_190926_b()) {
            mixer.emptyMixer(player);
            return ActionResultType.CONSUME;
        }
        ItemStack ingredientStack = stack.func_77946_l();
        ingredientStack.func_190920_e(1);
        if (mixer.addToMixer(ingredientStack) && !player.func_184812_l_()) {
            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
        }
        if (ingredientStack.func_77973_b() == TropicraftItems.BAMBOO_MUG.get() && mixer.canMix()) {
            mixer.startMixing();
            if (!player.func_184812_l_()) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            Drink craftedDrink = MixerRecipes.getDrink(mixer.ingredients);
            Drink pinaColada = Drink.PINA_COLADA;
            if (craftedDrink == null || craftedDrink.drinkId == pinaColada.drinkId) {
                // empty if block
            }
        }
        return ActionResultType.CONSUME;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState ret = super.func_196258_a(context);
        return (BlockState)ret.func_206870_a((Property)FACING, (Comparable)context.func_195999_j().func_174811_aO());
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new DrinkMixerTileEntity();
    }
}

