/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import it.unimi.dsi.fastutil.objects.Reference2ByteMap;
import it.unimi.dsi.fastutil.objects.Reference2ByteOpenHashMap;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockVoxelShape;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class MangroveRootsBlock
extends Block
implements IWaterLoggable {
    private static final Reference2ByteMap<BlockState> STATE_TO_KEY = new Reference2ByteOpenHashMap();
    private static final VoxelShape[] SHAPE_TABLE = MangroveRootsBlock.buildShapeTable();
    private static final int PIANGUA_GROW_CHANCE = 80;
    private static final int PIANGUA_RADIUS = 1;
    public static final BooleanProperty TALL = BooleanProperty.func_177716_a((String)"tall");
    public static final BooleanProperty GROUNDED = BooleanProperty.func_177716_a((String)"grounded");
    public static final EnumProperty<Connection> NORTH = EnumProperty.func_177709_a((String)"north", Connection.class);
    public static final EnumProperty<Connection> EAST = EnumProperty.func_177709_a((String)"east", Connection.class);
    public static final EnumProperty<Connection> SOUTH = EnumProperty.func_177709_a((String)"south", Connection.class);
    public static final EnumProperty<Connection> WEST = EnumProperty.func_177709_a((String)"west", Connection.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final Direction[] DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    public static final EnumProperty<Connection>[] CONNECTIONS = new EnumProperty[]{NORTH, EAST, SOUTH, WEST};

    public MangroveRootsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)TALL, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)GROUNDED, (Comparable)Boolean.valueOf(false))).func_206870_a(NORTH, (Comparable)((Object)Connection.NONE))).func_206870_a(EAST, (Comparable)((Object)Connection.NONE))).func_206870_a(SOUTH, (Comparable)((Object)Connection.NONE))).func_206870_a(WEST, (Comparable)((Object)Connection.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static VoxelShape[] buildShapeTable() {
        VoxelShape[] table = new VoxelShape[32];
        for (int key = 0; key < table.length; ++key) {
            boolean tall = (key & 1) != 0;
            boolean north = (key >> 1 & 1) != 0;
            boolean east = (key >> 2 & 1) != 0;
            boolean south = (key >> 3 & 1) != 0;
            boolean west = (key >> 4 & 1) != 0;
            table[key] = MangroveRootsBlock.computeShapeFor(tall, north, east, south, west);
        }
        return table;
    }

    private static VoxelShape computeShapeFor(boolean tall, boolean north, boolean east, boolean south, boolean west) {
        double height = tall ? 16.0 : 10.0;
        VoxelShape shape = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)height, (double)10.0);
        if (north) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)height, (double)6.0));
        }
        if (east) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)10.0, (double)0.0, (double)6.0, (double)16.0, (double)height, (double)10.0));
        }
        if (south) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)height, (double)16.0));
        }
        if (west) {
            shape = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)6.0, (double)height, (double)10.0));
        }
        return shape;
    }

    private static int shapeKey(BlockState state) {
        return ((Boolean)state.func_177229_b((Property)TALL) != false ? 1 : 0) | (((Connection)((Object)state.func_177229_b(NORTH))).exists() ? 2 : 0) | (((Connection)((Object)state.func_177229_b(EAST))).exists() ? 4 : 0) | (((Connection)((Object)state.func_177229_b(SOUTH))).exists() ? 8 : 0) | (((Connection)((Object)state.func_177229_b(WEST))).exists() ? 16 : 0);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        byte key = STATE_TO_KEY.computeByteIfAbsent((Object)state, MangroveRootsBlock::shapeKey);
        return SHAPE_TABLE[key];
    }

    public VoxelShape func_230335_e_(BlockState state, IBlockReader reader, BlockPos pos) {
        return super.func_230335_e_(state, reader, pos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getConnectedState((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return this.getConnectedState((IBlockReader)world, currentPos);
    }

    private BlockState getConnectedState(IBlockReader world, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)GROUNDED, (Comparable)Boolean.valueOf(this.isGrounded(world, pos)));
        if (!this.isTall(state = (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.NORTH)))).func_206870_a(EAST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.EAST)))).func_206870_a(SOUTH, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.SOUTH)))).func_206870_a(WEST, (Comparable)((Object)this.getConnectionFor(world, pos, Direction.WEST)))) && !world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this)) {
            state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)TALL, (Comparable)Boolean.valueOf(false))).func_206870_a(NORTH, (Comparable)((Object)((Connection)((Object)state.func_177229_b(NORTH))).shorten()))).func_206870_a(EAST, (Comparable)((Object)((Connection)((Object)state.func_177229_b(EAST))).shorten()))).func_206870_a(SOUTH, (Comparable)((Object)((Connection)((Object)state.func_177229_b(SOUTH))).shorten()))).func_206870_a(WEST, (Comparable)((Object)((Connection)((Object)state.func_177229_b(WEST))).shorten()));
        }
        return state;
    }

    private Connection getConnectionFor(IBlockReader world, BlockPos pos, Direction direction) {
        BlockPos adjacentPos = pos.func_177972_a(direction);
        BlockState adjacentState = world.func_180495_p(adjacentPos);
        if (this.canConnectTo(adjacentState, world, adjacentPos, direction)) {
            if (world.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this) && this.canConnectTo(world, adjacentPos.func_177984_a(), direction)) {
                return Connection.NONE;
            }
            if (adjacentState.func_203425_a((Block)this)) {
                boolean tall = this.isAdjacentTall(world, adjacentPos, direction.func_176734_d());
                return tall ? Connection.HIGH : Connection.LOW;
            }
            return Connection.HIGH;
        }
        return Connection.NONE;
    }

    private boolean isAdjacentTall(IBlockReader world, BlockPos pos, Direction sourceDirection) {
        BlockState aboveState = world.func_180495_p(pos.func_177984_a());
        if (aboveState.func_203425_a((Block)this) || aboveState.func_242698_a(world, pos, Direction.DOWN, BlockVoxelShape.CENTER)) {
            return true;
        }
        for (Direction direction : DIRECTIONS) {
            if (direction == sourceDirection || !this.canConnectTo(world, pos.func_177972_a(direction), direction)) continue;
            return true;
        }
        return false;
    }

    private boolean isTall(BlockState state) {
        int count = 0;
        if (((Connection)((Object)state.func_177229_b(NORTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.func_177229_b(EAST))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.func_177229_b(SOUTH))).exists()) {
            ++count;
        }
        if (((Connection)((Object)state.func_177229_b(WEST))).exists()) {
            ++count;
        }
        return count > 1;
    }

    private boolean canConnectTo(IBlockReader world, BlockPos pos, Direction direction) {
        return this.canConnectTo(world.func_180495_p(pos), world, pos, direction);
    }

    private boolean canConnectTo(BlockState state, IBlockReader world, BlockPos pos, Direction direction) {
        return (state.func_203425_a((Block)this) || state.func_224755_d(world, pos, direction)) && !FenceBlock.func_220073_a((Block)state.func_177230_c());
    }

    private boolean isGrounded(IBlockReader world, BlockPos pos) {
        BlockPos groundPos = pos.func_177977_b();
        return world.func_180495_p(groundPos).func_224755_d(world, groundPos, Direction.UP);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_185499_a(BlockState state, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TALL, GROUNDED, NORTH, EAST, SOUTH, WEST, WATERLOGGED});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)GROUNDED) != false && (Boolean)state.func_177229_b((Property)TALL) != false;
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (random.nextInt(80) == 0) {
            this.tryGrowPianguas(world, pos, random);
        }
    }

    private void tryGrowPianguas(ServerWorld world, BlockPos pos, Random random) {
        BlockPos soilPos = pos.func_177977_b();
        if (!world.func_180495_p(soilPos).func_203425_a((Block)TropicraftBlocks.MUD.get())) {
            return;
        }
        BlockPos growPos = soilPos.func_177982_a(random.nextInt(3) - 1, -random.nextInt(2), random.nextInt(3) - 1);
        BlockState growIn = world.func_180495_p(growPos);
        if (growIn.func_203425_a((Block)TropicraftBlocks.MUD.get()) && !world.func_180495_p(growPos.func_177984_a()).func_200132_m() && !this.hasNearPianguas(world, growPos)) {
            world.func_175656_a(growPos, ((Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get()).func_176223_P());
        }
    }

    private boolean hasNearPianguas(ServerWorld world, BlockPos source) {
        Block mudWithPianguas = (Block)TropicraftBlocks.MUD_WITH_PIANGUAS.get();
        BlockPos minSpacingPos = source.func_177982_a(-1, -1, -1);
        BlockPos maxSpacingPos = source.func_177982_a(1, 0, 1);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)minSpacingPos, (BlockPos)maxSpacingPos)) {
            if (!world.func_180495_p(pos).func_203425_a(mudWithPianguas)) continue;
            return true;
        }
        return false;
    }

    public static enum Connection implements IStringSerializable
    {
        NONE("none"),
        HIGH("high"),
        LOW("low");

        private final String key;

        private Connection(String key) {
            this.key = key;
        }

        public boolean exists() {
            return this != NONE;
        }

        public String func_176610_l() {
            return this.key;
        }

        public Connection shorten() {
            return this == HIGH ? LOW : this;
        }
    }
}

