/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.trees.Tree;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.server.ServerWorld;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.tree.CitrusFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.CitrusTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TropicraftTrees {
    public static final Tree GRAPEFRUIT = TropicraftTrees.createFruit(TropicraftBlocks.GRAPEFRUIT_LEAVES);
    public static final Tree LEMON = TropicraftTrees.createFruit(TropicraftBlocks.LEMON_LEAVES);
    public static final Tree LIME = TropicraftTrees.createFruit(TropicraftBlocks.LIME_LEAVES);
    public static final Tree ORANGE = TropicraftTrees.createFruit(TropicraftBlocks.ORANGE_LEAVES);
    public static final Tree RAINFOREST = TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
        int treeType = random.nextInt(4);
        if (treeType == 0) {
            return ((RainforestTreeFeature)TropicraftFeatures.TALL_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
        if (treeType == 1) {
            return ((RainforestTreeFeature)TropicraftFeatures.SMALL_TUALUNG.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
        if (treeType == 2) {
            return ((RainforestTreeFeature)TropicraftFeatures.UP_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
        return ((RainforestTreeFeature)TropicraftFeatures.LARGE_TUALUNG.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
    });
    public static final Tree PALM = TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
        int palmType = random.nextInt(3);
        if (palmType == 0) {
            return ((PalmTreeFeature)TropicraftFeatures.NORMAL_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
        if (palmType == 1) {
            return ((PalmTreeFeature)TropicraftFeatures.CURVED_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
        }
        return ((PalmTreeFeature)TropicraftFeatures.LARGE_PALM_TREE.get()).func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_);
    });
    public static final Tree RED_MANGROVE = TropicraftTrees.create("red_mangrove");
    public static final Tree TALL_MANGROVE = TropicraftTrees.create("tall_mangrove");
    public static final Tree TEA_MANGROVE = TropicraftTrees.create("tea_mangrove");
    public static final Tree BLACK_MANGROVE = TropicraftTrees.create("black_mangrove");

    private static Tree createFruit(Supplier<? extends Block> fruitLeaves) {
        return TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
            WeightedBlockStateProvider leaves = new WeightedBlockStateProvider().func_227407_a_(((LeavesBlock)TropicraftBlocks.FRUIT_LEAVES.get()).func_176223_P(), 1).func_227407_a_(((Block)fruitLeaves.get()).func_176223_P(), 1);
            BaseTreeFeatureConfig config = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)leaves, (FoliagePlacer)new CitrusFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new CitrusTrunkPlacer(6, 3, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_225568_b_();
            return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)config);
        });
    }

    private static Tree create(String id) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243552_au, (ResourceLocation)new ResourceLocation("tropicraft", id));
        return TropicraftTrees.create((MinecraftServer server, Random random, boolean beehive) -> {
            DynamicRegistries registries = server.func_244267_aX();
            MutableRegistry features = registries.func_243612_b(Registry.field_243552_au);
            return (ConfiguredFeature)features.func_230516_a_(key);
        });
    }

    private static Tree create(final FeatureProvider featureProvider) {
        return new Tree(){

            @Nullable
            protected ConfiguredFeature<BaseTreeFeatureConfig, ?> func_225546_b_(Random random, boolean beehive) {
                return null;
            }

            public boolean func_230339_a_(ServerWorld world, ChunkGenerator generator, BlockPos pos, BlockState sapling, Random random) {
                ConfiguredFeature<?, ?> feature = featureProvider.getFeature(world.func_73046_m(), random, this.hasFlowers((IWorld)world, pos));
                if (feature == null) {
                    return false;
                }
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 4);
                if (feature.func_242765_a((ISeedReader)world, generator, random, pos)) {
                    return true;
                }
                world.func_180501_a(pos, sapling, 4);
                return false;
            }

            private boolean hasFlowers(IWorld world, BlockPos origin) {
                BlockPos min = origin.func_177982_a(-2, -1, -2);
                BlockPos max = origin.func_177982_a(2, 1, 2);
                for (BlockPos pos : BlockPos.Mutable.func_218278_a((BlockPos)min, (BlockPos)max)) {
                    if (!world.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_226149_I_)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    static interface FeatureProvider {
        @Nullable
        public ConfiguredFeature<?, ?> getFeature(MinecraftServer var1, Random var2, boolean var3);
    }
}

