/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.huge_plant;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.RegistryObject;

public final class HugePlantBlock
extends BushBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.func_177709_a((String)"type", Type.class);
    private Supplier<RegistryObject<? extends IItemProvider>> pickItem;

    public HugePlantBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)Type.SEED)));
    }

    public HugePlantBlock setPickItem(Supplier<RegistryObject<? extends IItemProvider>> item) {
        this.pickItem = item;
        return this;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (plantPos.equals((Object)pos) || world.func_180495_p(plantPos).func_196953_a(context)) continue;
            return null;
        }
        return (BlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)Type.SEED));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            if (plantPos.equals((Object)pos)) continue;
            BlockState plantState = shape.blockAt(plantPos);
            world.func_180501_a(plantPos, plantState, 3);
        }
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        Shape shape = Shape.match((Block)this, (IBlockReader)world, pos);
        if (shape == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (this.isValidPosition(world, shape)) {
            return state;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private boolean isValidPosition(IWorld world, Shape shape) {
        BlockPos seedPos = shape.seed();
        BlockState seedState = world.func_180495_p(seedPos);
        return super.func_196260_a(seedState, (IWorldReader)world, seedPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        if (HugePlantBlock.isSeedBlock((Block)this, state)) {
            BlockState worldState = world.func_180495_p(pos);
            if (worldState != state && !this.isValidPositionToPlace(world, pos)) {
                return false;
            }
            return super.func_196260_a(state, world, pos);
        }
        return Shape.match((Block)this, (IBlockReader)world, pos) != null;
    }

    private boolean isValidPositionToPlace(IWorldReader world, BlockPos pos) {
        for (BlockPos plantPos : Shape.fromSeed((Block)this, pos)) {
            if (world.func_180495_p(plantPos).func_185904_a().func_76222_j()) continue;
            return false;
        }
        return true;
    }

    public void placeAt(IWorld world, BlockPos pos, int flags) {
        Shape shape = Shape.fromSeed((Block)this, pos);
        for (BlockPos plantPos : shape) {
            BlockState plantState = shape.blockAt(plantPos);
            world.func_180501_a(plantPos, plantState, flags);
        }
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!world.field_72995_K) {
            Shape shape = Shape.match((Block)this, (IBlockReader)world, pos);
            if (shape == null) {
                return;
            }
            if (!player.func_184812_l_()) {
                HugePlantBlock.func_220054_a((BlockState)state, (World)world, (BlockPos)shape.seed(), null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
            int flags = 50;
            for (BlockPos plantPos : shape) {
                world.func_180501_a(plantPos, Blocks.field_150350_a.func_176223_P(), flags);
                world.func_217379_c(2001, plantPos, Block.func_196246_j((BlockState)state));
            }
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (state.func_177229_b(TYPE) == Type.SEED) {
            return super.func_220076_a(state, builder);
        }
        return Collections.emptyList();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (this.pickItem != null) {
            return new ItemStack((IItemProvider)this.pickItem.get().get());
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE});
    }

    static boolean isSeedBlock(Block block, BlockState state) {
        return state.func_203425_a(block) && state.func_177229_b(TYPE) == Type.SEED;
    }

    public static final class Shape
    implements Iterable<BlockPos> {
        public static final int RADIUS = 1;
        private final Block block;
        private final BlockPos seed;

        private Shape(Block block, BlockPos seed) {
            this.block = block;
            this.seed = seed;
        }

        public static Shape fromSeed(Block block, BlockPos seed) {
            return new Shape(block, seed);
        }

        @Nullable
        public static Shape match(Block block, IBlockReader world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                Shape shape;
                if (!HugePlantBlock.isSeedBlock(block, world.func_180495_p(plantPos)) || !(shape = Shape.fromSeed(block, plantPos)).validate(world)) continue;
                return shape;
            }
            return null;
        }

        @Nullable
        public static Shape matchIncomplete(Block block, IBlockReader world, BlockPos pos) {
            for (BlockPos plantPos : Shape.matchPositions(pos)) {
                if (!HugePlantBlock.isSeedBlock(block, world.func_180495_p(plantPos))) continue;
                return Shape.fromSeed(block, plantPos);
            }
            return null;
        }

        private static Iterable<BlockPos> matchPositions(BlockPos pos) {
            BlockPos minPos = pos.func_177982_a(-1, -2, -1);
            BlockPos maxPos = pos.func_177982_a(1, 0, 1);
            return BlockPos.func_218278_a((BlockPos)minPos, (BlockPos)maxPos);
        }

        public boolean validate(IBlockReader world) {
            for (BlockPos pos : this) {
                if (world.func_180495_p(pos).func_203425_a(this.block)) continue;
                return false;
            }
            return true;
        }

        public BlockState blockAt(BlockPos pos) {
            Type type = Type.OUTER;
            if (pos.equals((Object)this.seed())) {
                type = Type.SEED;
            } else if (pos.equals((Object)this.center())) {
                type = Type.CENTER;
            }
            return (BlockState)this.block.func_176223_P().func_206870_a(TYPE, (Comparable)((Object)type));
        }

        public BlockPos seed() {
            return this.seed;
        }

        public BlockPos center() {
            return this.seed.func_177982_a(0, 1, 0);
        }

        public AxisAlignedBB asAabb() {
            BlockPos seed = this.seed;
            return new AxisAlignedBB((double)(seed.func_177958_n() - 1), (double)seed.func_177956_o(), (double)(seed.func_177952_p() - 1), (double)(seed.func_177958_n() + 1) + 1.0, (double)(seed.func_177956_o() + 2) + 1.0, (double)(seed.func_177952_p() + 1) + 1.0);
        }

        @Override
        public Iterator<BlockPos> iterator() {
            BlockPos center = this.center();
            return BlockPos.func_218278_a((BlockPos)center.func_177982_a(-1, -1, -1), (BlockPos)center.func_177982_a(1, 1, 1)).iterator();
        }
    }

    public static enum Type implements IStringSerializable
    {
        SEED("seed"),
        CENTER("center"),
        OUTER("outer");

        private final String key;

        private Type(String key) {
            this.key = key;
        }

        public String func_176610_l() {
            return this.key;
        }
    }
}

