/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;
import net.tropicraft.core.common.block.AirCompressorBlock;
import net.tropicraft.core.common.block.tileentity.IMachineTile;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;
import net.tropicraft.core.common.item.scuba.ScubaArmorItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageAirCompressorInventory;

public class AirCompressorTileEntity
extends TileEntity
implements ITickableTileEntity,
IMachineTile {
    private boolean compressing;
    private int ticks;
    private static final int fillRate = 5;
    @Nonnull
    private ItemStack stack = ItemStack.field_190927_a;
    private ScubaArmorItem tank;

    public AirCompressorTileEntity() {
        super((TileEntityType)TropicraftTileEntityTypes.AIR_COMPRESSOR.get());
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.compressing = nbt.func_74767_n("Compressing");
        if (nbt.func_74764_b("Tank")) {
            this.setTank(ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Tank")));
        } else {
            this.setTank(ItemStack.field_190927_a);
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Compressing", this.compressing);
        CompoundNBT var4 = new CompoundNBT();
        this.stack.func_77955_b(var4);
        nbt.func_218657_a("Tank", (INBT)var4);
        return nbt;
    }

    public void setTank(@Nonnull ItemStack tankItemStack) {
        this.stack = tankItemStack;
        this.tank = !(this.stack.func_77973_b() instanceof ScubaArmorItem) ? null : (ScubaArmorItem)this.stack.func_77973_b();
    }

    @Nonnull
    public ItemStack getTankStack() {
        return this.stack;
    }

    @Nullable
    public ScubaArmorItem getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        if (this.tank == null) {
            return;
        }
        int airContained = this.tank.getRemainingAir(this.getTankStack());
        int maxAir = this.tank.getMaxAir(this.getTankStack());
        if (this.compressing) {
            int overflow = this.tank.addAir(5, this.getTankStack());
            ++this.ticks;
            if (overflow > 0) {
                this.finishCompressing();
            }
        }
    }

    public boolean addTank(ItemStack stack) {
        if (this.tank == null && stack.func_77973_b() instanceof ScubaArmorItem && ((ScubaArmorItem)stack.func_77973_b()).providesAir()) {
            this.setTank(stack);
            this.compressing = true;
            this.syncInventory();
            return true;
        }
        return false;
    }

    public void ejectTank() {
        if (!this.stack.func_190926_b() && !this.field_145850_b.field_72995_K) {
            ItemEntity tankItem = new ItemEntity(this.field_145850_b, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.stack);
            this.field_145850_b.func_217376_c((Entity)tankItem);
        }
        this.setTank(ItemStack.field_190927_a);
        this.syncInventory();
        this.ticks = 0;
        this.compressing = false;
    }

    public boolean isDoneCompressing() {
        return this.ticks > 0 && !this.compressing;
    }

    public float getTickRatio(float partialTicks) {
        if (this.tank != null) {
            return ((float)this.ticks + partialTicks) / (float)(this.tank.getMaxAir(this.getTankStack()) * 5);
        }
        return 0.0f;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void startCompressing() {
        this.compressing = true;
        this.syncInventory();
    }

    public void finishCompressing() {
        this.compressing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public float getBreatheProgress(float partialTicks) {
        if (this.isDoneCompressing()) {
            return 0.0f;
        }
        return (float)(((double)(((float)this.ticks + partialTicks) / 20.0f) * Math.PI + Math.PI) % (Math.PI * 2));
    }

    @Override
    public boolean isActive() {
        return !this.getTankStack().func_190926_b();
    }

    @Override
    public float getProgress(float partialTicks) {
        return this.getTickRatio(partialTicks);
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.func_177229_b(AirCompressorBlock.FACING);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    protected void syncInventory() {
        if (!this.field_145850_b.field_72995_K) {
            TropicraftPackets.INSTANCE.send(PacketDistributor.DIMENSION.with(() -> ((World)this.field_145850_b).func_234923_W_()), (Object)new MessageAirCompressorInventory(this));
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbttagcompound = this.func_189515_b(new CompoundNBT());
        return nbttagcompound;
    }
}

