/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tropicraft.core.common.block.DrinkMixerBlock;
import net.tropicraft.core.common.block.tileentity.IMachineTile;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Drinks;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipes;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageMixerInventory;
import net.tropicraft.core.common.network.message.MessageMixerStart;

public class DrinkMixerTileEntity
extends TileEntity
implements ITickableTileEntity,
IMachineTile {
    private static final int TICKS_TO_MIX = 80;
    private static final int MAX_NUM_INGREDIENTS = 3;
    private int ticks;
    public NonNullList<ItemStack> ingredients;
    private boolean mixing = false;
    public ItemStack result = ItemStack.field_190927_a;

    public DrinkMixerTileEntity() {
        super((TileEntityType)TropicraftTileEntityTypes.DRINK_MIXER.get());
        this.ingredients = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    }

    public void func_230337_a_(BlockState blockState, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.ticks = nbt.func_74762_e("MixTicks");
        this.mixing = nbt.func_74767_n("Mixing");
        for (int i = 0; i < 3; ++i) {
            if (!nbt.func_74764_b("Ingredient" + i)) continue;
            this.ingredients.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Ingredient" + i)));
        }
        if (nbt.func_74764_b("Result")) {
            this.result = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Result"));
        }
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("MixTicks", this.ticks);
        nbt.func_74757_a("Mixing", this.mixing);
        for (int i = 0; i < 3; ++i) {
            CompoundNBT ingredientNbt = new CompoundNBT();
            ((ItemStack)this.ingredients.get(i)).func_77955_b(ingredientNbt);
            nbt.func_218657_a("Ingredient" + i, (INBT)ingredientNbt);
        }
        CompoundNBT resultNbt = new CompoundNBT();
        this.result.func_77955_b(resultNbt);
        nbt.func_218657_a("Result", (INBT)resultNbt);
        return nbt;
    }

    public void func_73660_a() {
        if (this.ticks < 80 && this.mixing) {
            ++this.ticks;
            if (this.ticks == 80) {
                this.finishMixing();
            }
        }
    }

    public boolean isDoneMixing() {
        return !this.result.func_190926_b();
    }

    public NonNullList<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public static List<Ingredient> listIngredients(@Nonnull ItemStack stack) {
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        if (Drink.isDrink(stack.func_77973_b())) {
            Collections.addAll(is, CocktailItem.getIngredients(stack));
        } else {
            Ingredient i = Ingredient.findMatchingIngredient(stack);
            if (i != null) {
                is.add(i);
            }
        }
        return is;
    }

    public void startMixing() {
        this.ticks = 0;
        this.mixing = true;
        if (!this.field_145850_b.field_72995_K) {
            TropicraftPackets.sendToDimension(new MessageMixerStart(this), this.field_145850_b);
        }
    }

    private void dropItem(@Nonnull ItemStack stack, @Nullable PlayerEntity at) {
        if (at == null) {
            BlockPos pos = this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((Property)DrinkMixerBlock.FACING));
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        } else {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)at.func_226277_ct_(), (double)at.func_226278_cu_(), (double)at.func_226281_cx_(), (ItemStack)stack);
        }
    }

    public void emptyMixer(@Nullable PlayerEntity at) {
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.ingredients.get(i)).func_190926_b()) continue;
            this.dropItem((ItemStack)this.ingredients.get(i), at);
            this.ingredients.set(i, (Object)ItemStack.field_190927_a);
        }
        this.ticks = 80;
        this.mixing = false;
        this.syncInventory();
    }

    public void retrieveResult(@Nullable PlayerEntity at) {
        if (this.result.func_190926_b()) {
            return;
        }
        this.dropItem(this.result, at);
        for (int i = 0; i < 3; ++i) {
            ItemStack container;
            if (((ItemStack)this.ingredients.get(i)).func_190926_b() || (container = ((ItemStack)this.ingredients.get(i)).func_77973_b().getContainerItem((ItemStack)this.ingredients.get(i))).func_190926_b()) continue;
            this.dropItem(container, at);
        }
        this.ingredients.clear();
        this.result = ItemStack.field_190927_a;
        this.syncInventory();
    }

    public void finishMixing() {
        this.result = this.getResult(this.getIngredients());
        this.mixing = false;
        this.ticks = 0;
        this.syncInventory();
    }

    public boolean addToMixer(@Nonnull ItemStack ingredient) {
        if (((ItemStack)this.ingredients.get(0)).func_190926_b()) {
            Ingredient i;
            if (!Drink.isDrink(ingredient.func_77973_b()) && (i = Ingredient.findMatchingIngredient(ingredient)) == null) {
                return false;
            }
            this.ingredients.set(0, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(1)).func_190926_b()) {
            if (Drink.isDrink(ingredient.func_77973_b())) {
                return false;
            }
            Ingredient ing0 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient i = Ingredient.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id) {
                return false;
            }
            this.ingredients.set(1, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        if (((ItemStack)this.ingredients.get(2)).func_190926_b()) {
            if (Drink.isDrink(ingredient.func_77973_b())) {
                return false;
            }
            Ingredient ing0 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(0));
            Ingredient ing1 = Ingredient.findMatchingIngredient((ItemStack)this.ingredients.get(1));
            Ingredient i = Ingredient.findMatchingIngredient(ingredient);
            if (i == null || ing0.id == i.id || ing1.id == i.id) {
                return false;
            }
            this.ingredients.set(2, (Object)ingredient);
            this.syncInventory();
            return true;
        }
        return false;
    }

    public boolean isMixing() {
        return this.mixing;
    }

    private boolean isMixerFull() {
        return MixerRecipes.isValidRecipe(this.ingredients);
    }

    public boolean canMix() {
        return !this.mixing && this.isMixerFull();
    }

    @Override
    public boolean isActive() {
        return this.isMixing();
    }

    @Override
    public float getProgress(float partialTicks) {
        return ((float)this.ticks + partialTicks) / 80.0f;
    }

    @Override
    public Direction getDirection(BlockState state) {
        return (Direction)state.func_177229_b((Property)DrinkMixerBlock.FACING);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    protected void syncInventory() {
        if (!this.field_145850_b.field_72995_K) {
            TropicraftPackets.sendToDimension(new MessageMixerInventory(this), this.field_145850_b);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    private CompoundNBT writeItems(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191281_a((CompoundNBT)nbt, this.ingredients, (boolean)true);
        ItemStackHelper.func_191281_a((CompoundNBT)nbt, (NonNullList)NonNullList.func_193580_a((Object)this.result, (Object[])new ItemStack[0]), (boolean)true);
        return nbt;
    }

    public ItemStack getResult(NonNullList<ItemStack> ingredients2) {
        return Drinks.getResult(ingredients2);
    }
}

