/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.tropicraft.Constants;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.network.TropicraftPackets;
import net.tropicraft.core.common.network.message.MessageSifterInventory;
import net.tropicraft.core.common.network.message.MessageSifterStart;

public class SifterTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int SIFT_TIME = 80;
    private boolean isSifting;
    private int currentSiftTime = 80;
    private Random rand;
    public double yaw;
    public double yaw2 = 0.0;
    @Nonnull
    private ItemStack siftItem = ItemStack.field_190927_a;

    public SifterTileEntity() {
        super((TileEntityType)TropicraftTileEntityTypes.SIFTER.get());
        this.rand = new Random();
    }

    @Nonnull
    public ItemStack getSiftItem() {
        return this.siftItem;
    }

    public void func_73660_a() {
        if (this.currentSiftTime > 0 && this.isSifting) {
            --this.currentSiftTime;
        }
        if (this.field_145850_b.field_72995_K) {
            this.yaw2 = this.yaw % 360.0;
            this.yaw += 4.545454502105713;
        }
        if (this.isSifting && this.currentSiftTime <= 0) {
            this.stopSifting();
        }
    }

    public void dumpResults(BlockPos pos) {
        this.dumpBeachResults(pos);
        this.syncInventory();
    }

    private void dumpBeachResults(BlockPos pos) {
        int dumpCount = this.rand.nextInt(3) + 1;
        while (dumpCount > 0) {
            ItemStack stack;
            --dumpCount;
            if (this.rand.nextInt(10) == 0) {
                stack = this.getRareItem();
            } else if (this.rand.nextInt(10) < 3) {
                String name = this.rand.nextBoolean() ? Constants.LT17_NAMES[this.rand.nextInt(Constants.LT17_NAMES.length)] : Constants.LT18_NAMES[this.rand.nextInt(Constants.LT18_NAMES.length)];
                CompoundNBT nameTag = new CompoundNBT();
                nameTag.func_74778_a("Name", name);
                stack = new ItemStack((IItemProvider)TropicraftItems.LOVE_TROPICS_SHELL.get());
                stack.func_77982_d(nameTag);
            } else {
                stack = this.getCommonItem();
            }
            this.spawnItem(stack, pos);
        }
    }

    private void spawnItem(ItemStack stack, BlockPos pos) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemEntity itemEntity = new ItemEntity(this.field_145850_b, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        this.field_145850_b.func_217376_c((Entity)itemEntity);
    }

    private ItemStack getCommonItem() {
        int shellIndex = this.rand.nextInt(TropicraftTags.Items.SHELLS.func_230236_b_().size() + 1) - 1;
        if (shellIndex < 0) {
            return this.getRareItem();
        }
        return new ItemStack((IItemProvider)TropicraftTags.Items.SHELLS.func_205596_a(this.rand));
    }

    private ItemStack getRareItem() {
        int dmg = this.rand.nextInt(12);
        switch (dmg) {
            case 1: {
                return new ItemStack((IItemProvider)Items.field_151074_bl, 1);
            }
            case 2: {
                return new ItemStack((IItemProvider)Items.field_151133_ar, 1);
            }
            case 3: {
                return new ItemStack((IItemProvider)Items.field_151038_n, 1);
            }
            case 4: {
                return new ItemStack((IItemProvider)Items.field_151069_bo, 1);
            }
            case 5: {
                return new ItemStack((IItemProvider)TropicraftItems.WHITE_PEARL.get(), 1);
            }
            case 6: {
                return new ItemStack((IItemProvider)TropicraftItems.BLACK_PEARL.get(), 1);
            }
            case 7: {
                return new ItemStack((IItemProvider)Items.field_151051_r, 1);
            }
        }
        return new ItemStack((IItemProvider)TropicraftItems.RUBE_NAUTILUS.get());
    }

    public void addItemToSifter(ItemStack stack) {
        this.siftItem = stack.func_77946_l().func_77979_a(1);
        this.syncInventory();
    }

    public void startSifting() {
        this.isSifting = true;
        this.currentSiftTime = 80;
        if (!this.field_145850_b.field_72995_K) {
            TropicraftPackets.sendToDimension(new MessageSifterStart(this), this.field_145850_b);
        }
    }

    private void stopSifting() {
        double x = (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
        double y = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
        double z = (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble() * 1.4;
        if (!this.field_145850_b.field_72995_K) {
            this.dumpResults(new BlockPos(x, y, z));
        }
        this.currentSiftTime = 80;
        this.isSifting = false;
        this.siftItem = ItemStack.field_190927_a;
        this.syncInventory();
    }

    public void setSifting(boolean flag) {
        this.isSifting = flag;
    }

    public boolean isSifting() {
        return this.isSifting;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.isSifting = nbt.func_74767_n("isSifting");
        this.currentSiftTime = nbt.func_74762_e("currentSiftTime");
        if (nbt.func_150297_b("Item", 10)) {
            this.siftItem = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("Item"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("isSifting", this.isSifting);
        nbt.func_74768_a("currentSiftTime", this.currentSiftTime);
        if (!this.siftItem.func_190926_b()) {
            nbt.func_218657_a("Item", (INBT)this.siftItem.func_77955_b(new CompoundNBT()));
        }
        return nbt;
    }

    public CompoundNBT getTagCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        return stack.func_77978_p();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    protected void syncInventory() {
        if (!this.field_145850_b.func_201670_d()) {
            TropicraftPackets.sendToDimension(new MessageSifterInventory(this), this.field_145850_b);
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    private CompoundNBT writeItems(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191281_a((CompoundNBT)nbt, (NonNullList)NonNullList.func_193580_a((Object)this.siftItem, (Object[])new ItemStack[0]), (boolean)true);
        return nbt;
    }

    public void setSiftItem(ItemStack siftItem) {
        this.siftItem = siftItem.func_77946_l().func_77979_a(1);
    }
}

