/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.tropicraft.core.common.TropicsConfigs;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.TropicraftTileEntityTypes;
import net.tropicraft.core.common.dimension.chunk.VolcanoGenerator;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.volcano.VolcanoState;

public class VolcanoTileEntity
extends TileEntity
implements ITickableTileEntity {
    private static final int RAND_DORMANT_DURATION = 4000;
    private static final int MAX_LAVA_LEVEL_DURING_RISE = 183;
    private static final int MAX_LAVA_LEVEL_DURING_ERUPTION = 185;
    private static final int LAVA_BASE_LEVEL = 149;
    private static final int LAVA_ERUPT_LEVEL = 160;
    private int ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
    private int ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
    private int ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
    private int ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT);
    private int ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
    private int lavaLevel = -1;
    private int radius = -1;
    private VolcanoState state = VolcanoState.DORMANT;
    private int heightOffset = Integer.MIN_VALUE;

    public VolcanoTileEntity() {
        super((TileEntityType)TropicraftTileEntityTypes.VOLCANO.get());
    }

    public void func_73660_a() {
        if (!TropicsConfigs.allowVolcanoEruption) {
            return;
        }
        if (this.heightOffset == Integer.MIN_VALUE) {
            this.heightOffset = VolcanoGenerator.getHeightOffsetForBiome(this.func_174877_v().func_177956_o());
        }
        if (!this.func_145831_w().field_72995_K) {
            // empty if block
        }
        if (this.radius == -1) {
            this.radius = this.findRadius();
        }
        if (this.lavaLevel == -1) {
            this.setLavaLevel();
        }
        if (this.radius == -1 || this.lavaLevel == -1) {
            return;
        }
        this.updateStates();
        switch (this.state) {
            case DORMANT: {
                break;
            }
            case ERUPTING: {
                if (this.func_145831_w().field_72995_K) break;
                if (this.func_145831_w().field_73012_v.nextInt(15) == 0) {
                    this.throwLavaFromCaldera(0.05 + Math.abs(this.func_145831_w().field_73012_v.nextGaussian()) * (this.lavaLevel > 90 ? (double)(160 + this.heightOffset) : 0.75));
                }
                if (this.func_145831_w().field_73012_v.nextInt(15) != 0) break;
                this.throwLavaFromCaldera(0.05 + Math.abs(this.func_145831_w().field_73012_v.nextGaussian()) * (this.lavaLevel > 160 + this.heightOffset ? 1.0 : 0.75));
                break;
            }
            case RETREATING: {
                if (this.ticksUntilDormant % 30 != 0) break;
                this.lowerLavaLevels();
                break;
            }
            case RISING: {
                if (this.func_145831_w().field_72995_K) {
                    this.spewSmoke();
                }
                if (this.ticksUntilEruption % 20 != 0) break;
                if (this.lavaLevel < 185 + this.heightOffset) {
                    this.raiseLavaLevels();
                    break;
                }
                this.ticksUntilEruption = 0;
                this.func_145831_w().func_184134_a((double)this.field_174879_c.func_177958_n(), 73.0, (double)this.field_174879_c.func_177956_o(), SoundEvents.field_187539_bB, SoundCategory.NEUTRAL, 1.0f, this.func_145831_w().field_73012_v.nextFloat() / 4.0f + 0.825f, false);
                int balls = this.func_145831_w().field_73012_v.nextInt(25) + 15;
                for (int i = 0; i < balls; ++i) {
                    this.throwLavaFromCaldera(this.func_145831_w().field_73012_v.nextDouble() * 0.5 + 1.25);
                }
                break;
            }
            case SMOKING: {
                if (!this.func_145831_w().field_72995_K) break;
                this.spewSmoke();
                break;
            }
        }
    }

    public void cleanUpFromEruption() {
        int xPos = this.field_174879_c.func_177958_n();
        int zPos = this.field_174879_c.func_177952_p();
        for (int x = xPos - this.radius * 2; x < xPos + this.radius * 2; ++x) {
            for (int z = zPos - this.radius * 2; z < zPos + this.radius * 2; ++z) {
                for (int y = 149 + this.heightOffset; y < 140; ++y) {
                    BlockPos outBlockPos = new BlockPos(x, y, z);
                    if (this.func_145831_w().func_180495_p(outBlockPos).func_177230_c() != Blocks.field_150353_l) continue;
                    this.func_145831_w().func_175656_a(outBlockPos, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void throwLavaFromCaldera(double force) {
        Vector3d pos = new Vector3d((this.func_145831_w().field_73012_v.nextDouble() / 2.0 + 0.3) * (double)this.radius, (double)(this.lavaLevel + 2), 0.0);
        float angle = this.func_145831_w().field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        pos = pos.func_178785_b(angle).func_178787_e(Vector3d.func_237489_a_((Vector3i)this.func_174877_v()));
        double motX = force * Math.cos(angle);
        double motZ = force * Math.sin(-angle);
        this.throwLava(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, motX, 0.86, motZ);
    }

    public void throwLava(double i, double j, double k, double xMot, double yMot, double zMot) {
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_217376_c((Entity)new LavaBallEntity((EntityType<? extends LavaBallEntity>)((EntityType)TropicraftEntities.LAVA_BALL.get()), this.func_145831_w(), i, j, k, xMot, yMot, zMot));
        }
    }

    private void raiseLavaLevels() {
        if (this.lavaLevel < 185 + this.heightOffset) {
            ++this.lavaLevel;
            this.setBlocksOnLavaLevel(Blocks.field_150353_l.func_176223_P(), 3);
        }
    }

    private void lowerLavaLevels() {
        if (this.lavaLevel > 149 + this.heightOffset) {
            this.setBlocksOnLavaLevel(Blocks.field_150350_a.func_176223_P(), 3);
            --this.lavaLevel;
        }
    }

    private void setBlocksOnLavaLevel(BlockState state, int updateFlag) {
        int xPos = this.field_174879_c.func_177958_n();
        int zPos = this.field_174879_c.func_177952_p();
        for (int x = xPos - this.radius; x < xPos + this.radius; ++x) {
            for (int z = zPos - this.radius; z < zPos + this.radius; ++z) {
                if (!(Math.sqrt(Math.pow(x - xPos, 2.0) + Math.pow(z - zPos, 2.0)) < (double)(this.radius + 3))) continue;
                BlockPos botPos = new BlockPos(x, 10, z);
                if (this.func_145831_w().func_180495_p(botPos).func_177230_c() != Blocks.field_150353_l) continue;
                BlockPos pos2 = new BlockPos(x, this.lavaLevel, z);
                if (this.lavaLevel >= 183 + this.heightOffset && this.lavaLevel < 185 + this.heightOffset) {
                    if (this.func_145831_w().func_180495_p(pos2).func_177230_c() == TropicraftBlocks.CHUNK.get()) continue;
                    this.func_145831_w().func_180501_a(pos2, state, updateFlag);
                    continue;
                }
                this.func_145831_w().func_180501_a(pos2, state, updateFlag);
            }
        }
    }

    public void spewSmoke() {
        int n = this.func_145831_w().field_73012_v.nextInt(100) + 4;
        for (int i = 0; i < n; ++i) {
            double x = this.field_174879_c.func_177958_n() + this.func_145831_w().field_73012_v.nextInt(this.radius) * (this.func_145831_w().field_73012_v.nextBoolean() ? -1 : 1);
            double y = this.lavaLevel + this.func_145831_w().field_73012_v.nextInt(6);
            double z = this.field_174879_c.func_177952_p() + this.func_145831_w().field_73012_v.nextInt(this.radius) * (this.func_145831_w().field_73012_v.nextBoolean() ? -1 : 1);
            this.func_145831_w().func_195590_a((IParticleData)ParticleTypes.field_197594_E, true, x, y, z, 0.0, 0.7, 0.0);
        }
    }

    private void updateStates() {
        switch (this.state) {
            case DORMANT: {
                --this.ticksUntilSmoking;
                if (this.ticksUntilSmoking > 0) break;
                this.state = VolcanoState.SMOKING;
                this.ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
                break;
            }
            case SMOKING: {
                --this.ticksUntilRising;
                if (this.ticksUntilRising > 0) break;
                this.state = VolcanoState.RISING;
                this.ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
                break;
            }
            case RISING: {
                --this.ticksUntilEruption;
                if (this.ticksUntilEruption > 0) break;
                this.state = VolcanoState.ERUPTING;
                this.ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
                break;
            }
            case ERUPTING: {
                --this.ticksUntilRetreating;
                if (this.ticksUntilRetreating > 0) break;
                this.state = VolcanoState.RETREATING;
                this.ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
                break;
            }
            case RETREATING: {
                --this.ticksUntilDormant;
                if (this.ticksUntilDormant > 0) break;
                this.state = VolcanoState.DORMANT;
                this.ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT) + this.func_145831_w().field_73012_v.nextInt(4000);
                break;
            }
        }
    }

    private void setLavaLevel() {
        for (int y = 149 + this.heightOffset; y < 256; ++y) {
            BlockPos pos2 = new BlockPos(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
            if (this.func_145831_w().func_180495_p(pos2).func_185904_a() == Material.field_151587_i) continue;
            this.lavaLevel = y - 1;
            return;
        }
    }

    private int findRadius() {
        for (int x = 0; x < 60; ++x) {
            if (this.func_145831_w().func_180495_p(new BlockPos(x + this.field_174879_c.func_177958_n(), 10, this.field_174879_c.func_177952_p())).func_177230_c() == Blocks.field_150353_l) continue;
            return x;
        }
        return -1;
    }

    public void func_230337_a_(BlockState blockState, CompoundNBT nbt) {
        super.func_230337_a_(blockState, nbt);
        this.state = VolcanoState.valueOf(nbt.func_74779_i("state"));
        this.ticksUntilDormant = nbt.func_74762_e("ticksUntilDormant");
        this.ticksUntilSmoking = nbt.func_74762_e("ticksUntilSmoking");
        this.ticksUntilRising = nbt.func_74762_e("ticksUntilRising");
        this.ticksUntilEruption = nbt.func_74762_e("ticksUntilEruption");
        this.ticksUntilRetreating = nbt.func_74762_e("ticksUntilRetreating");
        this.lavaLevel = nbt.func_74762_e("lavaLevel");
        this.radius = nbt.func_74762_e("radius");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("state", this.state.name());
        nbt.func_74768_a("ticksUntilDormant", this.ticksUntilDormant);
        nbt.func_74768_a("ticksUntilSmoking", this.ticksUntilSmoking);
        nbt.func_74768_a("ticksUntilRising", this.ticksUntilRising);
        nbt.func_74768_a("ticksUntilEruption", this.ticksUntilEruption);
        nbt.func_74768_a("ticksUntilRetreating", this.ticksUntilRetreating);
        nbt.func_74768_a("lavaLevel", this.lavaLevel);
        nbt.func_74768_a("radius", this.radius);
        return nbt;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }
}

