/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.data;

import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.TropicraftFlower;

public class TropicraftBlockTagsProvider
extends BlockTagsProvider {
    public TropicraftBlockTagsProvider(DataGenerator generatorIn, ExistingFileHelper existingFileHelper) {
        super(generatorIn, "tropicraft", existingFileHelper);
    }

    protected void func_200432_c() {
        this.createAndAppend(TropicraftTags.Blocks.SAND, (ITag.INamedTag<Block>)BlockTags.field_203436_u, new Supplier[]{TropicraftBlocks.PURIFIED_SAND, TropicraftBlocks.CORAL_SAND, TropicraftBlocks.FOAMY_SAND, TropicraftBlocks.MINERAL_SAND, TropicraftBlocks.VOLCANIC_SAND});
        this.createTag(TropicraftTags.Blocks.MUD, new Supplier[]{TropicraftBlocks.MUD, TropicraftBlocks.MUD_WITH_PIANGUAS});
        this.createAndAppend(TropicraftTags.Blocks.SAPLINGS, (ITag.INamedTag<Block>)BlockTags.field_200030_g, new Supplier[]{TropicraftBlocks.PALM_SAPLING, TropicraftBlocks.MAHOGANY_SAPLING, TropicraftBlocks.GRAPEFRUIT_SAPLING, TropicraftBlocks.LEMON_SAPLING, TropicraftBlocks.LIME_SAPLING, TropicraftBlocks.ORANGE_SAPLING, TropicraftBlocks.RED_MANGROVE_PROPAGULE, TropicraftBlocks.TALL_MANGROVE_PROPAGULE, TropicraftBlocks.TEA_MANGROVE_PROPAGULE, TropicraftBlocks.BLACK_MANGROVE_PROPAGULE});
        this.createAndAppend(TropicraftTags.Blocks.LEAVES, (ITag.INamedTag<Block>)BlockTags.field_206952_E, new Supplier[]{TropicraftBlocks.MAHOGANY_LEAVES, TropicraftBlocks.PALM_LEAVES, TropicraftBlocks.KAPOK_LEAVES, TropicraftBlocks.FRUIT_LEAVES, TropicraftBlocks.GRAPEFRUIT_LEAVES, TropicraftBlocks.LEMON_LEAVES, TropicraftBlocks.LIME_LEAVES, TropicraftBlocks.ORANGE_LEAVES, TropicraftBlocks.RED_MANGROVE_LEAVES, TropicraftBlocks.TALL_MANGROVE_LEAVES, TropicraftBlocks.TEA_MANGROVE_LEAVES, TropicraftBlocks.BLACK_MANGROVE_LEAVES});
        this.createAndAppend(TropicraftTags.Blocks.SMALL_FLOWERS, (ITag.INamedTag<Block>)BlockTags.field_219746_E, TropicraftFlower.ACAI_VINE, TropicraftFlower.ANEMONE, TropicraftFlower.BROMELIAD, TropicraftFlower.CANNA, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.CROCOSMIA, TropicraftFlower.CROTON, TropicraftFlower.DRACAENA, TropicraftFlower.TROPICAL_FERN, TropicraftFlower.FOLIAGE, TropicraftFlower.MAGIC_MUSHROOM, TropicraftFlower.ORANGE_ANTHURIUM, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM);
        this.createTag(TropicraftTags.Blocks.TROPICS_FLOWERS, TropicraftFlower.ACAI_VINE, TropicraftFlower.ANEMONE, TropicraftFlower.BROMELIAD, TropicraftFlower.CANNA, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.CROCOSMIA, TropicraftFlower.CROTON, TropicraftFlower.DRACAENA, TropicraftFlower.TROPICAL_FERN, TropicraftFlower.FOLIAGE, TropicraftFlower.ORANGE_ANTHURIUM, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM);
        this.createTag(TropicraftTags.Blocks.RAINFOREST_FLOWERS, TropicraftFlower.MAGIC_MUSHROOM);
        this.createTag(TropicraftTags.Blocks.OVERWORLD_FLOWERS, TropicraftFlower.ORCHID, TropicraftFlower.PATHOS, TropicraftFlower.RED_ANTHURIUM, TropicraftFlower.COMMELINA_DIFFUSA, TropicraftFlower.ANEMONE, TropicraftFlower.ORANGE_ANTHURIUM);
        this.createAndAppend(TropicraftTags.Blocks.LOGS, (ITag.INamedTag<Block>)BlockTags.field_200031_h, new Supplier[]{TropicraftBlocks.PALM_LOG, TropicraftBlocks.MAHOGANY_LOG, TropicraftBlocks.LIGHT_MANGROVE_LOG, TropicraftBlocks.RED_MANGROVE_LOG, TropicraftBlocks.BLACK_MANGROVE_LOG, TropicraftBlocks.STRIPPED_MANGROVE_LOG});
        this.createAndAppend(TropicraftTags.Blocks.PLANKS, (ITag.INamedTag<Block>)BlockTags.field_199898_b, new Supplier[]{TropicraftBlocks.PALM_PLANKS, TropicraftBlocks.MAHOGANY_PLANKS});
        this.createTag(TropicraftTags.Blocks.ROOTS, new Supplier[]{TropicraftBlocks.RED_MANGROVE_ROOTS, TropicraftBlocks.LIGHT_MANGROVE_ROOTS, TropicraftBlocks.BLACK_MANGROVE_ROOTS});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_SLABS, (ITag.INamedTag<Block>)BlockTags.field_202895_i, new Supplier[]{TropicraftBlocks.PALM_SLAB, TropicraftBlocks.MAHOGANY_SLAB, TropicraftBlocks.MANGROVE_SLAB});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_STAIRS, (ITag.INamedTag<Block>)BlockTags.field_202894_h, new Supplier[]{TropicraftBlocks.PALM_STAIRS, TropicraftBlocks.MAHOGANY_STAIRS, TropicraftBlocks.MANGROVE_STAIRS});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_DOORS, (ITag.INamedTag<Block>)BlockTags.field_200152_g, new Supplier[]{TropicraftBlocks.PALM_DOOR, TropicraftBlocks.MAHOGANY_DOOR, TropicraftBlocks.MANGROVE_DOOR});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_TRAPDOORS, (ITag.INamedTag<Block>)BlockTags.field_212186_k, new Supplier[]{TropicraftBlocks.PALM_TRAPDOOR, TropicraftBlocks.MAHOGANY_TRAPDOOR, TropicraftBlocks.MANGROVE_TRAPDOOR});
        this.createAndAppend(TropicraftTags.Blocks.WOODEN_FENCES, (ITag.INamedTag<Block>)BlockTags.field_219756_j, new Supplier[]{TropicraftBlocks.PALM_FENCE, TropicraftBlocks.MAHOGANY_FENCE, TropicraftBlocks.MANGROVE_FENCE});
        this.extendAndAppend(TropicraftTags.Blocks.SLABS, TropicraftTags.Blocks.WOODEN_SLABS, (ITag.INamedTag<Block>)BlockTags.field_203292_x, new Supplier[]{TropicraftBlocks.BAMBOO_SLAB, TropicraftBlocks.CHUNK_SLAB, TropicraftBlocks.THATCH_SLAB});
        this.extendAndAppend(TropicraftTags.Blocks.STAIRS, TropicraftTags.Blocks.WOODEN_STAIRS, (ITag.INamedTag<Block>)BlockTags.field_203291_w, new Supplier[]{TropicraftBlocks.BAMBOO_STAIRS, TropicraftBlocks.CHUNK_STAIRS, TropicraftBlocks.THATCH_STAIRS});
        this.extendAndAppend(TropicraftTags.Blocks.DOORS, TropicraftTags.Blocks.WOODEN_DOORS, (ITag.INamedTag<Block>)BlockTags.field_200029_f, new Supplier[]{TropicraftBlocks.BAMBOO_DOOR, TropicraftBlocks.THATCH_DOOR});
        this.extendAndAppend(TropicraftTags.Blocks.TRAPDOORS, TropicraftTags.Blocks.WOODEN_TRAPDOORS, (ITag.INamedTag<Block>)BlockTags.field_212185_E, new Supplier[]{TropicraftBlocks.BAMBOO_TRAPDOOR, TropicraftBlocks.THATCH_TRAPDOOR});
        this.extendAndAppend(TropicraftTags.Blocks.FENCES, TropicraftTags.Blocks.WOODEN_FENCES, (ITag.INamedTag<Block>)BlockTags.field_219748_G, new Supplier[]{TropicraftBlocks.BAMBOO_FENCE, TropicraftBlocks.CHUNK_FENCE, TropicraftBlocks.THATCH_FENCE});
        this.createAndAppend(TropicraftTags.Blocks.WALLS, (ITag.INamedTag<Block>)BlockTags.field_219757_z, new Supplier[]{TropicraftBlocks.CHUNK_WALL});
        this.createAndAppend(TropicraftTags.Blocks.CLIMBABLE, (ITag.INamedTag<Block>)BlockTags.field_232878_as_, new Supplier[]{TropicraftBlocks.BAMBOO_LADDER});
        this.createAndAppend(TropicraftTags.Blocks.FLOWER_POTS, (ITag.INamedTag<Block>)BlockTags.field_200032_i, (Supplier[])Stream.concat(TropicraftBlocks.BAMBOO_POTTED_TROPICS_PLANTS.stream(), Stream.concat(TropicraftBlocks.BAMBOO_POTTED_VANILLA_PLANTS.stream(), TropicraftBlocks.VANILLA_POTTED_TROPICS_PLANTS.stream())).toArray(RegistryObject[]::new));
        this.createTag(TropicraftTags.Blocks.BONGOS, new Supplier[]{TropicraftBlocks.SMALL_BONGO_DRUM, TropicraftBlocks.MEDIUM_BONGO_DRUM, TropicraftBlocks.LARGE_BONGO_DRUM});
    }

    @SafeVarargs
    private final <T> T[] resolveAll(IntFunction<T[]> creator, Supplier<? extends T> ... suppliers) {
        return Arrays.stream(suppliers).map(Supplier::get).toArray(creator);
    }

    @SafeVarargs
    private final void createTag(ITag.INamedTag<Block> tag, Supplier<? extends Block> ... blocks) {
        this.func_240522_a_(tag).func_240534_a_((Object[])this.resolveAll(Block[]::new, blocks));
    }

    @SafeVarargs
    private final void appendToTag(ITag.INamedTag<Block> tag, ITag.INamedTag<Block> ... toAppend) {
        this.func_240522_a_(tag).addTags(toAppend);
    }

    @SafeVarargs
    private final void extendTag(ITag.INamedTag<Block> tag, ITag.INamedTag<Block> toExtend, Supplier<? extends Block> ... blocks) {
        this.func_240522_a_(tag).func_240531_a_(toExtend).func_240534_a_((Object[])this.resolveAll(Block[]::new, blocks));
    }

    @SafeVarargs
    private final void createAndAppend(ITag.INamedTag<Block> tag, ITag.INamedTag<Block> to, Supplier<? extends Block> ... blocks) {
        this.createTag(tag, blocks);
        this.appendToTag(to, tag);
    }

    @SafeVarargs
    private final void extendAndAppend(ITag.INamedTag<Block> tag, ITag.INamedTag<Block> toExtend, ITag.INamedTag<Block> to, Supplier<? extends Block> ... blocks) {
        this.extendTag(tag, toExtend, blocks);
        this.appendToTag(to, tag);
    }

    public String func_200397_b() {
        return "Tropicraft Block Tags";
    }
}

