/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeProvider;
import net.tropicraft.core.common.dimension.chunk.TropicraftChunkGenerator;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="tropicraft")
public class TropicraftDimension {
    private static final Logger LOGGER = LogManager.getLogger(TropicraftDimension.class);
    public static final ResourceLocation ID = new ResourceLocation("tropicraft", "tropics");
    public static final RegistryKey<World> WORLD = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ID);
    public static final RegistryKey<Dimension> DIMENSION = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)ID);
    public static final RegistryKey<DimensionType> DIMENSION_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)ID);
    public static final RegistryKey<DimensionSettings> DIMENSION_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)ID);

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        ServerWorld world;
        if (event.getWorld() instanceof ServerWorld && (world = (ServerWorld)event.getWorld()).func_234923_W_() == World.field_234918_g_) {
            TropicraftDimension.upgradeTropicraftDimension(world.func_73046_m());
        }
    }

    private static void upgradeTropicraftDimension(MinecraftServer server) {
        SaveFormat.LevelSave save = server.field_71310_m;
        File oldDimension = save.func_237285_a_(new FolderName("tropicraft/tropics")).toFile();
        File newDimension = save.func_237291_a_(WORLD);
        if (oldDimension.exists() && !newDimension.exists()) {
            try {
                FileUtils.moveDirectory((File)oldDimension, (File)newDimension);
            }
            catch (IOException e) {
                LOGGER.error("Failed to move old tropicraft dimension to new location!", (Throwable)e);
            }
        }
    }

    public static void addDefaultDimensionKey() {
        try {
            Field dimensionKeysField = ObfuscationReflectionHelper.findField(Dimension.class, (String)"field_236056_e_");
            LinkedHashSet keys = (LinkedHashSet)dimensionKeysField.get(null);
            keys.add(DIMENSION);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to add tropics as a default dimension key", (Throwable)e);
        }
    }

    public static Dimension createDimension(Registry<DimensionType> dimensionTypeRegistry, Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed) {
        Supplier<DimensionType> dimensionType = () -> (DimensionType)dimensionTypeRegistry.func_243576_d(DIMENSION_TYPE);
        ChunkGenerator generator = TropicraftDimension.createGenerator(biomeRegistry, dimensionSettingsRegistry, seed);
        return new Dimension(dimensionType, generator);
    }

    public static ChunkGenerator createGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimensionSettingsRegistry, long seed) {
        Supplier<DimensionSettings> dimensionSettings = () -> {
            DimensionSettings settings = (DimensionSettings)dimensionSettingsRegistry.func_230516_a_(DIMENSION_SETTINGS);
            return settings != null ? settings : (DimensionSettings)dimensionSettingsRegistry.func_243576_d(DimensionSettings.field_242734_c);
        };
        TropicraftBiomeProvider biomeSource = new TropicraftBiomeProvider(seed, biomeRegistry);
        return new TropicraftChunkGenerator(biomeSource, seed, dimensionSettings);
    }

    public static void teleportPlayer(ServerPlayerEntity player, RegistryKey<World> dimensionType) {
        if (player.field_70170_p.func_234923_W_() == dimensionType) {
            TropicraftDimension.teleportPlayerNoPortal(player, (RegistryKey<World>)World.field_234918_g_);
        } else {
            TropicraftDimension.teleportPlayerNoPortal(player, dimensionType);
        }
    }

    public static void teleportPlayerNoPortal(ServerPlayerEntity player, RegistryKey<World> destination) {
        ServerWorld world = player.field_71133_b.func_71218_a(destination);
        if (world == null) {
            LOGGER.error("Cannot teleport player to dimension {} as it does not exist!", (Object)destination.func_240901_a_());
            return;
        }
        if (!ForgeHooks.onTravelToDimension((Entity)player, destination)) {
            return;
        }
        int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
        int z = MathHelper.func_76128_c((double)player.func_226281_cx_());
        Chunk chunk = world.func_212866_a_(x >> 4, z >> 4);
        int topY = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x & 0xF, z & 0xF);
        player.func_200619_a(world, (double)x + 0.5, (double)topY + 1.0, (double)z + 0.5, player.field_70177_z, player.field_70125_A);
        BasicEventHooks.firePlayerChangedDimensionEvent((PlayerEntity)player, destination, destination);
    }

    public static int getSeaLevel(IWorldReader world) {
        RegistryKey dimensionKey;
        if (world instanceof ServerWorld) {
            ServerChunkProvider chunkProvider = ((ServerWorld)world).func_72863_F();
            return chunkProvider.func_201711_g().func_230356_f_();
        }
        if (world instanceof World && (dimensionKey = ((World)world).func_234923_W_()) == WORLD) {
            return 127;
        }
        return world.func_181545_F();
    }
}

