/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.chunk;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.impl.LocateCommand;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.VolcanicSandBlock;
import net.tropicraft.core.common.block.VolcanoBlock;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;
import net.tropicraft.core.common.dimension.noise.NoiseModule;
import net.tropicraft.core.common.dimension.noise.generator.Billowed;

@Mod.EventBusSubscriber(modid="tropicraft")
public class VolcanoGenerator {
    public static Set<ResourceLocation> volcanoSpawnBiomesLand = ImmutableSet.of((Object)TropicraftBiomes.TROPICS.func_240901_a_(), (Object)TropicraftBiomes.RAINFOREST_PLAINS.func_240901_a_());
    public static Set<ResourceLocation> volcanoSpawnBiomesOcean = ImmutableSet.of((Object)TropicraftBiomes.TROPICS_OCEAN.func_240901_a_());
    private final long worldSeed;
    private static final int MAX_RADIUS = 65;
    private static final int MIN_RADIUS = 45;
    private static final int CALDERA_CUTOFF = 194;
    public static final int VOLCANO_TOP = 187;
    public static final int VOLCANO_CRUST = 184;
    public static final int LAVA_LEVEL = 149;
    private static final int CRUST_HOLE_CHANCE = 15;
    private static final int OCEAN_HEIGHT_OFFSET = -50;
    public static final int SURFACE_BIOME = 1;
    public static final int OCEAN_BIOME = 2;
    public static final int CHUNK_SIZE_X = 16;
    public static final int CHUNK_SIZE_Z = 16;
    public static final int CHUNK_SIZE_Y = 256;
    private static final int CHUNK_RANGE = 4;
    private static final Supplier<BlockState> VOLCANO_BLOCK = TropicraftBlocks.CHUNK.lazyMap(Block::func_176223_P);
    private static final Supplier<BlockState> LAVA_BLOCK = () -> Blocks.field_150353_l.func_176223_P();
    private static final Supplier<BlockState> SAND_BLOCK = TropicraftBlocks.VOLCANIC_SAND.lazyMap(b -> (BlockState)b.func_176223_P().func_206870_a((Property)VolcanicSandBlock.HOT, (Comparable)Boolean.valueOf(true)));
    private final BiomeProvider biomeSource;

    public VolcanoGenerator(long worldSeed, BiomeProvider biomeSource) {
        this.worldSeed = worldSeed;
        this.biomeSource = biomeSource;
    }

    @SubscribeEvent
    public static void onServerStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        LiteralArgumentBuilder locate = (LiteralArgumentBuilder)Commands.func_197057_a((String)"locate").requires(source -> source.func_197034_c(2));
        dispatcher.register((LiteralArgumentBuilder)locate.then(Commands.func_197057_a((String)"tropicraft:volcano").executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            BlockPos pos = new BlockPos(source.func_197036_d());
            BlockPos volcanoPos = VolcanoGenerator.getVolcanoNear(source.func_197023_e(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4, 100);
            if (volcanoPos == null) {
                throw new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.locate.failed")).create();
            }
            return LocateCommand.func_241054_a_((CommandSource)source, (String)"Volcano", (BlockPos)pos, (BlockPos)volcanoPos, (String)"commands.locate.success");
        })));
    }

    public IChunk generate(int chunkX, int chunkZ, IChunk chunk, SharedSeedRandom random) {
        BlockPos volcanoCoords = VolcanoGenerator.getVolcanoNear(this.biomeSource, this.worldSeed, chunkX, chunkZ, 0);
        if (volcanoCoords == null) {
            return chunk;
        }
        int HEIGHT_OFFSET = VolcanoGenerator.getHeightOffsetForBiome(volcanoCoords.func_177956_o());
        int calderaCutoff = 194 + HEIGHT_OFFSET;
        int lavaLevel = 149 + HEIGHT_OFFSET;
        int volcanoTop = 187 + HEIGHT_OFFSET;
        int volcanoCrust = 184 + HEIGHT_OFFSET;
        chunkX *= 16;
        chunkZ *= 16;
        int volcCenterX = volcanoCoords.func_177958_n();
        int volcCenterZ = volcanoCoords.func_177952_p();
        long seed = this.getPositionSeed(volcCenterX, volcCenterZ);
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        NoiseModule volcNoise = this.getNoise(seed);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (volcanoCoords.func_177958_n() <= chunkX + 15 && volcanoCoords.func_177958_n() >= chunkX && volcanoCoords.func_177952_p() <= chunkZ + 15 && volcanoCoords.func_177952_p() >= chunkZ) {
            BlockPos volcanoBlockPos = new BlockPos(volcanoCoords.func_177958_n() & 0xF, 1, volcanoCoords.func_177952_p() & 0xF);
            chunk.func_177436_a(volcanoBlockPos, ((VolcanoBlock)TropicraftBlocks.VOLCANO.get()).func_176223_P(), false);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int relativeX = x + chunkX - volcCenterX;
                int relativeZ = z + chunkZ - volcCenterZ;
                double volcanoHeight = this.getVolcanoHeight(relativeX, relativeZ, radiusX, radiusZ, volcNoise);
                float distanceSquared = this.getDistanceSq(relativeX, relativeZ, radiusX, radiusZ);
                int groundHeight = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z);
                groundHeight = Math.min(groundHeight, lavaLevel - 3);
                if (!(distanceSquared < 1.0f)) continue;
                for (int y = 256; y > 0; --y) {
                    pos.func_181079_c(x, y, z);
                    if (volcanoHeight + (double)groundHeight < (double)calderaCutoff) {
                        if (volcanoHeight + (double)groundHeight <= (double)volcanoTop) {
                            if (!((double)y <= volcanoHeight + (double)groundHeight)) continue;
                            if (y > groundHeight) {
                                this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                                continue;
                            }
                            if (y <= groundHeight - 2) continue;
                            this.placeBlock((BlockPos)pos, SAND_BLOCK, chunk);
                            continue;
                        }
                        if (y == volcanoCrust - 1) {
                            if (random.nextInt(3) == 0) continue;
                            this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                            continue;
                        }
                        if (y > volcanoTop) continue;
                        this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                        continue;
                    }
                    if (y == volcanoCrust && rand.nextInt(15) != 0) {
                        this.placeBlock((BlockPos)pos, VOLCANO_BLOCK, chunk);
                        continue;
                    }
                    if (y <= lavaLevel) {
                        this.placeBlock((BlockPos)pos, LAVA_BLOCK, chunk);
                        continue;
                    }
                    this.placeBlock((BlockPos)pos, () -> ((Block)Blocks.field_150350_a).func_176223_P(), chunk);
                }
            }
        }
        return chunk;
    }

    private long getPositionSeed(int volcCenterX, int volcCenterZ) {
        return (long)volcCenterX * 341873128712L + (long)volcCenterZ * 132897987541L + this.worldSeed + 4291726L;
    }

    private NoiseModule getNoise(long seed) {
        Billowed volcNoise = new Billowed(seed, 1, 1.0);
        volcNoise.amplitude = 0.45;
        return volcNoise;
    }

    public int getVolcanoHeight(int groundHeight, int x, int z) {
        BlockPos volcanoCoords = VolcanoGenerator.getVolcanoNear(this.biomeSource, this.worldSeed, x >> 4, z >> 4, 0);
        if (volcanoCoords == null) {
            return -1;
        }
        int volcCenterX = volcanoCoords.func_177958_n();
        int volcCenterZ = volcanoCoords.func_177952_p();
        long seed = this.getPositionSeed(volcCenterX, volcCenterZ);
        Random rand = new Random(seed);
        int radiusX = rand.nextInt(20) + 45;
        int radiusZ = rand.nextInt(20) + 45;
        NoiseModule volcNoise = this.getNoise(seed);
        int relativeX = x - volcCenterX;
        int relativeZ = z - volcCenterZ;
        double ret = this.getVolcanoHeight(relativeX, relativeZ, radiusX, radiusZ, volcNoise);
        int heightOffset = VolcanoGenerator.getHeightOffsetForBiome(volcanoCoords.func_177956_o());
        int lavaLevel = 149 + heightOffset;
        int volcanoCrust = 184 + heightOffset;
        groundHeight = Math.min(groundHeight, lavaLevel - 3);
        return Math.min(volcanoCrust + 1, MathHelper.func_76143_f((double)(ret + (double)groundHeight)));
    }

    private float getDistanceSq(float relativeX, float relativeZ, float radiusX, float radiusZ) {
        return relativeX / radiusX * (relativeX / radiusX) + relativeZ / radiusZ * (relativeZ / radiusZ);
    }

    private double getVolcanoHeight(float relativeX, float relativeZ, float radiusX, float radiusZ, NoiseModule volcNoise) {
        float distanceSquared = this.getDistanceSq(relativeX, relativeZ, radiusX, radiusZ);
        float perlin = (float)volcNoise.getNoise((double)relativeX * 0.21 + 0.01, (double)relativeZ * 0.21 + 0.01) + 1.0f;
        double steepness = 10.2;
        return steepness / (double)distanceSquared * (double)perlin - steepness - 2.0;
    }

    public void placeBlock(BlockPos pos, Supplier<BlockState> blockState, IChunk chunk) {
        chunk.func_177436_a(pos, blockState.get(), false);
    }

    public BlockState getBlockState(BlockPos pos, IChunk chunk) {
        return chunk.func_180495_p(pos);
    }

    public static int canGenVolcanoAtCoords(BiomeProvider biomeSource, long worldSeed, int chunkX, int chunkZ) {
        int numChunks = 64;
        int offsetChunks = 16;
        int oldi = chunkX;
        int oldj = chunkZ;
        if (chunkX < 0) {
            chunkX -= numChunks - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= numChunks - 1;
        }
        int randX = chunkX / numChunks;
        int randZ = chunkZ / numChunks;
        long seed = (long)randX * 341873128712L + (long)randZ * 132897987541L + worldSeed + 4291726L;
        Random rand = new Random(seed);
        randX *= numChunks;
        randZ *= numChunks;
        if (oldi == (randX += rand.nextInt(numChunks - offsetChunks)) && oldj == (randZ += rand.nextInt(numChunks - offsetChunks))) {
            if (VolcanoGenerator.hasAllBiomes(biomeSource, oldi * 16 + 8, 0, oldj * 16 + 8, volcanoSpawnBiomesLand)) {
                return 1;
            }
            if (VolcanoGenerator.hasAllBiomes(biomeSource, oldi * 16 + 8, 0, oldj * 16 + 8, volcanoSpawnBiomesOcean)) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static BlockPos getVolcanoNear(ServerWorld world, int chunkX, int chunkZ, int maxRadius) {
        return VolcanoGenerator.getVolcanoNear(world.func_72863_F().func_201711_g().func_202090_b(), world.func_72905_C(), chunkX, chunkZ, maxRadius);
    }

    public static BlockPos getVolcanoNear(BiomeProvider biomeSource, long worldSeed, int chunkX, int chunkZ, int maxRadius) {
        maxRadius += 4;
        for (int radius = 0; radius <= maxRadius; ++radius) {
            for (int offsetX = -radius; offsetX <= radius; ++offsetX) {
                boolean edgeX = offsetX == -radius || offsetX == radius;
                for (int offsetZ = -radius; offsetZ <= radius; ++offsetZ) {
                    int z;
                    int x;
                    int biome;
                    boolean edgeZ;
                    boolean bl = edgeZ = offsetZ == -radius || offsetZ == radius;
                    if (!edgeX && !edgeZ || (biome = VolcanoGenerator.canGenVolcanoAtCoords(biomeSource, worldSeed, x = chunkX + offsetX, z = chunkZ + offsetZ)) == 0) continue;
                    return new BlockPos((x << 4) + 8, biome, (z << 4) + 8);
                }
            }
        }
        return null;
    }

    public static int getHeightOffsetForBiome(int biome) {
        return biome == 1 ? 0 : -50;
    }

    private static boolean hasAllBiomes(BiomeProvider biomeSource, int centerX, int centerY, int centerZ, Set<ResourceLocation> allowedBiomes) {
        Biome biome = biomeSource.func_225526_b_(centerX >> 2, centerY >> 2, centerZ >> 2);
        return allowedBiomes.contains(biome.getRegistryName());
    }
}

