/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.config.HomeTreeBranchConfig;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;
import net.tropicraft.core.common.dimension.feature.tree.RainforestVinesFeature;

public class HomeTreeBranchFeature<T extends HomeTreeBranchConfig>
extends Feature<T> {
    private static final byte[] OTHER_COORD_PAIRS = new byte[]{2, 0, 0, 1, 2, 1};
    private final ConfiguredFeature<RainforestVinesConfig, RainforestVinesFeature> vinesFeature = new ConfiguredFeature((Feature)TropicraftFeatures.VINES.get(), (IFeatureConfig)new RainforestVinesConfig(4, 13, 12));

    public HomeTreeBranchFeature(Codec<T> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, T config) {
        SharedSeedRandom rand = new SharedSeedRandom();
        rand.func_202424_a(world.func_72905_C(), pos.func_177958_n(), pos.func_177952_p());
        int branchLength = rand.nextInt(10) + 15;
        int branchX1 = pos.func_177958_n();
        int branchZ1 = pos.func_177952_p();
        double minAngle = Math.toRadians(((HomeTreeBranchConfig)config).minAngle);
        double maxAngle = Math.toRadians(((HomeTreeBranchConfig)config).maxAngle);
        double angle = minAngle + (double)rand.nextFloat() * (maxAngle - minAngle);
        int branchX2 = (int)((double)branchLength * Math.sin(angle) + (double)branchX1);
        int branchZ2 = (int)((double)branchLength * Math.cos(angle) + (double)branchZ1);
        int branchY2 = rand.nextInt(4) + 4;
        BlockState wood = ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).func_176223_P();
        BlockState leaf = ((LeavesBlock)TropicraftBlocks.MAHOGANY_LEAVES.get()).func_176223_P();
        int leafCircleSizeConstant = 3;
        int y2 = pos.func_177956_o() + branchY2;
        this.placeBlockLine((IWorld)world, new int[]{branchX1, pos.func_177956_o(), branchZ1}, new int[]{branchX2, y2, branchZ2}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1 + 1, pos.func_177956_o(), branchZ1}, new int[]{branchX2 + 1, y2, branchZ2}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1 - 1, pos.func_177956_o(), branchZ1}, new int[]{branchX2 - 1, y2, branchZ2}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1, pos.func_177956_o(), branchZ1 + 1}, new int[]{branchX2, y2, branchZ2 + 1}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1, pos.func_177956_o(), branchZ1 - 1}, new int[]{branchX2, y2, branchZ2 - 1}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1, pos.func_177956_o() - 1, branchZ1}, new int[]{branchX2, y2 - 1, branchZ2}, wood);
        this.placeBlockLine((IWorld)world, new int[]{branchX1, pos.func_177956_o() + 1, branchZ1}, new int[]{branchX2, y2 + 1, branchZ2}, wood);
        this.genLeafCircle((IWorld)world, branchX2, y2 - 1, branchZ2, 8, 6, leaf, true);
        this.genLeafCircle((IWorld)world, branchX2, y2, branchZ2, 9, 0, leaf, true);
        this.genLeafCircle((IWorld)world, branchX2, y2 + 1, branchZ2, 13, 0, leaf, true);
        this.genLeafCircle((IWorld)world, branchX2, y2 + 2, branchZ2, 12, 0, leaf, true);
        this.vinesFeature.func_242765_a(world, generator, (Random)rand, new BlockPos(branchX2, y2 - 1, branchZ2));
        return false;
    }

    public void genLeafCircle(IWorld world, int x, int y, int z, int outerRadius, int innerRadius, BlockState state, boolean vines) {
        int outerRadiusSquared = outerRadius * outerRadius;
        int innerRadiusSquared = innerRadius * innerRadius;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int i = -outerRadius + x; i <= outerRadius + x; ++i) {
            for (int k = -outerRadius + z; k <= outerRadius + z; ++k) {
                double d = (x - i) * (x - i) + (z - k) * (z - k);
                if (!(d <= (double)outerRadiusSquared) || !(d >= (double)innerRadiusSquared)) continue;
                pos.func_181079_c(i, y, k);
                if (!world.func_175623_d((BlockPos)pos) && world.func_180495_p((BlockPos)pos).func_177230_c() != state.func_177230_c()) continue;
                world.func_180501_a((BlockPos)pos, state, 3);
            }
        }
    }

    private void placeBlockLine(IWorld world, int[] ai, int[] ai1, BlockState state) {
        int[] ai2 = new int[]{0, 0, 0};
        int j = 0;
        for (int byte0 = 0; byte0 < 3; byte0 = (int)((byte)(byte0 + 1))) {
            ai2[byte0] = ai1[byte0] - ai[byte0];
            if (Math.abs(ai2[byte0]) <= Math.abs(ai2[j])) continue;
            j = byte0;
        }
        if (ai2[j] == 0) {
            return;
        }
        byte byte1 = OTHER_COORD_PAIRS[j];
        byte byte2 = OTHER_COORD_PAIRS[j + 3];
        int byte3 = ai2[j] > 0 ? 1 : -1;
        double d = (double)ai2[byte1] / (double)ai2[j];
        double d1 = (double)ai2[byte2] / (double)ai2[j];
        int[] ai3 = new int[]{0, 0, 0};
        int l = ai2[j] + byte3;
        for (int k = 0; k != l; k += byte3) {
            ai3[j] = MathHelper.func_76128_c((double)((double)(ai[j] + k) + 0.5));
            ai3[byte1] = MathHelper.func_76128_c((double)((double)ai[byte1] + (double)k * d + 0.5));
            ai3[byte2] = MathHelper.func_76128_c((double)((double)ai[byte2] + (double)k * d1 + 0.5));
            world.func_180501_a(new BlockPos(ai3[0], ai3[1], ai3[2]), state, 3);
        }
    }
}

