/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Rotation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.FeatureJigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.IStructurePieceType;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;

public class HomeTreeStructure
extends Structure<VillageConfig> {
    private static final IStructurePieceType TYPE = IStructurePieceType.func_214750_a(Piece::new, (String)"tropicraft:home_tree");

    public HomeTreeStructure(Codec<VillageConfig> codec) {
        super(codec);
    }

    protected boolean func_230363_a_(ChunkGenerator generator, BiomeProvider biomes, long seed, SharedSeedRandom random, int chunkX, int chunkZ, Biome biome, ChunkPos startChunkPos, VillageConfig config) {
        BlockPos pos = new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8);
        int centerY = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        return this.isValid(generator, pos.func_177982_a(-4, 0, -4), centerY) && this.isValid(generator, pos.func_177982_a(-4, 0, 4), centerY) && this.isValid(generator, pos.func_177982_a(4, 0, 4), centerY) && this.isValid(generator, pos.func_177982_a(4, 0, -4), centerY);
    }

    private boolean isValid(ChunkGenerator generator, BlockPos pos, int startY) {
        int y = generator.func_222529_a(pos.func_177958_n(), pos.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        return y >= generator.func_230356_f_() && Math.abs(y - startY) < 10 && y < 150 && y > generator.func_230356_f_() + 2;
    }

    public Structure.IStartFactory<VillageConfig> func_214557_a() {
        return Start::new;
    }

    public static class Piece
    extends AbstractVillagePiece {
        public Piece(TemplateManager templates, JigsawPiece piece, BlockPos pos, int groundLevelDelta, Rotation rotation, MutableBoundingBox bounds) {
            super(templates, piece, pos, groundLevelDelta, rotation, bounds);
        }

        public Piece(TemplateManager templates, CompoundNBT data) {
            super(templates, data);
        }

        public MutableBoundingBox func_74874_b() {
            if (this.field_214832_a instanceof FeatureJigsawPiece) {
                MutableBoundingBox ret = super.func_74874_b();
                ret = new MutableBoundingBox(ret);
                ret.field_78897_a -= 32;
                ret.field_78895_b -= 32;
                ret.field_78896_c -= 32;
                ret.field_78893_d += 32;
                ret.field_78894_e += 32;
                ret.field_78892_f += 32;
            }
            return super.func_74874_b();
        }

        public Rotation func_214809_Y_() {
            if (this.field_214832_a instanceof NoRotateSingleJigsawPiece) {
                return Rotation.NONE;
            }
            return super.func_214809_Y_();
        }

        public IStructurePieceType func_214807_k() {
            return TYPE;
        }
    }

    public static class Start
    extends StructureStart<VillageConfig> {
        public Start(Structure<VillageConfig> structure, int chunkX, int chunkZ, MutableBoundingBox boundingBox, int references, long seed) {
            super(structure, chunkX, chunkZ, boundingBox, references, seed);
        }

        public void func_230364_a_(DynamicRegistries registries, ChunkGenerator generator, TemplateManager templates, int chunkX, int chunkZ, Biome biome, VillageConfig config) {
            BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
            JigsawManager.func_242837_a((DynamicRegistries)registries, (VillageConfig)config, Piece::new, (ChunkGenerator)generator, (TemplateManager)templates, (BlockPos)pos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)true, (boolean)true);
            this.func_202500_a();
        }

        protected void func_202500_a() {
            super.func_202500_a();
            int margin = 24;
            this.field_75074_b.field_78897_a -= margin;
            this.field_75074_b.field_78895_b -= margin;
            this.field_75074_b.field_78896_c -= margin;
            this.field_75074_b.field_78893_d += margin;
            this.field_75074_b.field_78894_e += margin;
            this.field_75074_b.field_78892_f += margin;
        }
    }
}

