/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.block.ReedsBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;

public final class ReedsFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState REEDS = ((ReedsBlock)TropicraftBlocks.REEDS.get()).func_176223_P();
    private static final int HEIGHT_ABOVE_WATER = 2;
    private static final int MAX_HEIGHT = 3;
    private static final int MAX_DEPTH = 3;

    public ReedsFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos origin, NoFeatureConfig config) {
        if (!world.func_180495_p(origin).func_203425_a(Blocks.field_150355_j) || !world.func_175623_d(origin.func_177984_a())) {
            return false;
        }
        boolean generated = false;
        BlockPos.Mutable bottomPos = new BlockPos.Mutable();
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        for (int i = 0; i < 32; ++i) {
            int x = origin.func_177958_n() + random.nextInt(8) - random.nextInt(8);
            int z = origin.func_177952_p() + random.nextInt(8) - random.nextInt(8);
            int y = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR, x, z);
            bottomPos.func_181079_c(x, y, z);
            generated |= this.generateOne(world, (BlockPos)bottomPos, random, mutablePos);
        }
        return generated;
    }

    private boolean generateOne(ISeedReader world, BlockPos pos, Random random, BlockPos.Mutable mutablePos) {
        if (!REEDS.func_196955_c((IWorldReader)world, pos) || !this.canReplace(world.func_180495_p(pos))) {
            return false;
        }
        int waterDepth = this.getWaterDepthAt(world, pos, mutablePos);
        int height = waterDepth + random.nextInt(2) + 1;
        if (!this.validateHeight(world, pos, height, mutablePos)) {
            return false;
        }
        if (height == 1) {
            this.generateShort(world, pos);
        } else {
            this.generateTall(world, pos, height, mutablePos);
        }
        return true;
    }

    private boolean validateHeight(ISeedReader world, BlockPos pos, int height, BlockPos.Mutable mutablePos) {
        if (height > 3) {
            return false;
        }
        mutablePos.func_189533_g((Vector3i)pos);
        for (int y = height; y >= 0; --y) {
            mutablePos.func_185336_p(pos.func_177956_o() + height);
            if (this.canReplace(world.func_180495_p((BlockPos)mutablePos))) continue;
            return false;
        }
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.func_203425_a(Blocks.field_150355_j) || state.func_196958_f();
    }

    private int getWaterDepthAt(ISeedReader world, BlockPos pos, BlockPos.Mutable mutablePos) {
        int depth = 0;
        mutablePos.func_189533_g((Vector3i)pos);
        while (world.func_180495_p((BlockPos)mutablePos).func_203425_a(Blocks.field_150355_j)) {
            mutablePos.func_189536_c(Direction.UP);
            if (++depth < 3) continue;
            break;
        }
        return depth;
    }

    private void generateShort(ISeedReader world, BlockPos pos) {
        BlockState state = (BlockState)((BlockState)REEDS.func_206870_a(ReedsBlock.TYPE, (Comparable)((Object)ReedsBlock.Type.SINGLE))).func_206870_a((Property)ReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        world.func_180501_a(pos, state, 2);
    }

    private boolean generateTall(ISeedReader world, BlockPos pos, int height, BlockPos.Mutable mutablePos) {
        for (int y = 0; y < height; ++y) {
            mutablePos.func_185336_p(pos.func_177956_o() + y);
            BlockState state = (BlockState)((BlockState)REEDS.func_206870_a(ReedsBlock.TYPE, (Comparable)((Object)(y == height - 1 ? ReedsBlock.Type.TOP : ReedsBlock.Type.BOTTOM)))).func_206870_a((Property)ReedsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(world.func_180495_p((BlockPos)mutablePos).func_203425_a(Blocks.field_150355_j)));
            world.func_180501_a((BlockPos)mutablePos, state, 2);
        }
        return true;
    }
}

