/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.DoublePlantBlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.BlockWithContextConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.SingleRandomFeature;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TwoFeatureChoiceConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.CaveEdgeConfig;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.placement.TopSolidWithNoiseConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.PineappleBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.huge_plant.HugePlantBlock;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.block_placer.HugePlantBlockPlacer;
import net.tropicraft.core.common.dimension.feature.block_state_provider.NoiseFromTagBlockStateProvider;
import net.tropicraft.core.common.dimension.feature.config.HomeTreeBranchConfig;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;
import net.tropicraft.core.common.dimension.feature.tree.CitrusFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.CitrusTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.PleodendronFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.PleodendronTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTrunkPlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.PianguasTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.PneumatophoresTreeDecorator;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.SmallMangroveFoliagePlacer;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.SmallMangroveTrunkPlacer;

public final class TropicraftConfiguredFeatures {
    public final ConfiguredFeature<?, ?> grapefruitTree;
    public final ConfiguredFeature<?, ?> orangeTree;
    public final ConfiguredFeature<?, ?> lemonTree;
    public final ConfiguredFeature<?, ?> limeTree;
    public final ConfiguredFeature<?, ?> normalPalmTree;
    public final ConfiguredFeature<?, ?> curvedPalmTree;
    public final ConfiguredFeature<?, ?> largePalmTree;
    public final ConfiguredFeature<?, ?> rainforestUpTree;
    public final ConfiguredFeature<?, ?> rainforestSmallTualung;
    public final ConfiguredFeature<?, ?> rainforestLargeTualung;
    public final ConfiguredFeature<?, ?> rainforestTallTree;
    public final ConfiguredFeature<?, ?> rainforestVines;
    public final ConfiguredFeature<?, ?> eih;
    public final ConfiguredFeature<?, ?> tropicsGrass;
    public final ConfiguredFeature<?, ?> bamboo;
    public final ConfiguredFeature<?, ?> redMangroveShort;
    public final ConfiguredFeature<?, ?> redMangroveSmall;
    public final ConfiguredFeature<?, ?> redMangrove;
    public final ConfiguredFeature<?, ?> blackMangrove;
    public final ConfiguredFeature<?, ?> tallMangrove;
    public final ConfiguredFeature<?, ?> teaMangrove;
    public final ConfiguredFeature<?, ?> lightMangroves;
    public final ConfiguredFeature<?, ?> mangroves;
    public final ConfiguredFeature<?, ?> mangroveVegetation;
    public final ConfiguredFeature<?, ?> mudDisk;
    public final ConfiguredFeature<?, ?> smallGoldenLeatherFern;
    public final ConfiguredFeature<?, ?> tallGoldenLeatherFern;
    public final ConfiguredFeature<?, ?> hugeGoldenLeatherFern;
    public final ConfiguredFeature<?, ?> pleodendron;
    public final ConfiguredFeature<?, ?> pineapplePatch;
    public final ConfiguredFeature<?, ?> tropicsFlowers;
    public final ConfiguredFeature<?, ?> rainforestFlowers;
    public final ConfiguredFeature<?, ?> irisFlowers;
    public final ConfiguredFeature<?, ?> coffeeBush;
    public final ConfiguredFeature<?, ?> undergrowth;
    public final ConfiguredFeature<?, ?> seagrass;
    public final ConfiguredFeature<?, ?> undergroundSeagrassOnStone;
    public final ConfiguredFeature<?, ?> undergroundSeagrassOnDirt;
    public final ConfiguredFeature<?, ?> undergroundSeaPickles;
    public final ConfiguredFeature<?, ?> mangroveReeds;
    public final ConfiguredFeature<?, ?> azurite;
    public final ConfiguredFeature<?, ?> eudialyte;
    public final ConfiguredFeature<?, ?> zircon;
    public final ConfiguredFeature<?, ?> manganese;
    public final ConfiguredFeature<?, ?> shaka;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouth;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouthExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouthEast;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouthEastExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchEast;
    public final ConfiguredFeature<?, ?> homeTreeBranchEastExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorthEast;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorthEastExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorth;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorthExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorthWest;
    public final ConfiguredFeature<?, ?> homeTreeBranchNorthWestExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchWest;
    public final ConfiguredFeature<?, ?> homeTreeBranchWestExact;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouthWest;
    public final ConfiguredFeature<?, ?> homeTreeBranchSouthWestExact;

    public TropicraftConfiguredFeatures(WorldgenDataConsumer<? extends ConfiguredFeature<?, ?>> worldgen) {
        Register features = new Register(worldgen);
        this.grapefruitTree = features.fruitTree("grapefruit_tree", (Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_SAPLING, (Supplier<? extends Block>)TropicraftBlocks.GRAPEFRUIT_LEAVES);
        this.orangeTree = features.fruitTree("orange_tree", (Supplier<? extends Block>)TropicraftBlocks.ORANGE_SAPLING, (Supplier<? extends Block>)TropicraftBlocks.ORANGE_LEAVES);
        this.lemonTree = features.fruitTree("lemon_tree", (Supplier<? extends Block>)TropicraftBlocks.LEMON_SAPLING, (Supplier<? extends Block>)TropicraftBlocks.LEMON_LEAVES);
        this.limeTree = features.fruitTree("lime_tree", (Supplier<? extends Block>)TropicraftBlocks.LIME_SAPLING, (Supplier<? extends Block>)TropicraftBlocks.LIME_LEAVES);
        this.normalPalmTree = features.sparseTree("normal_palm_tree", TropicraftFeatures.NORMAL_PALM_TREE, IFeatureConfig.field_202429_e, 0.2f);
        this.curvedPalmTree = features.sparseTree("curved_palm_tree", TropicraftFeatures.CURVED_PALM_TREE, IFeatureConfig.field_202429_e, 0.2f);
        this.largePalmTree = features.sparseTree("large_palm_tree", TropicraftFeatures.LARGE_PALM_TREE, IFeatureConfig.field_202429_e, 0.2f);
        this.rainforestUpTree = features.sparseTree("rainforest_up_tree", TropicraftFeatures.UP_TREE, IFeatureConfig.field_202429_e, 0.2f);
        this.rainforestSmallTualung = features.sparseTree("rainforest_small_tualung", TropicraftFeatures.SMALL_TUALUNG, IFeatureConfig.field_202429_e, 0.3f);
        this.rainforestLargeTualung = features.sparseTree("rainforest_large_tualung", TropicraftFeatures.LARGE_TUALUNG, IFeatureConfig.field_202429_e, 0.4f);
        this.rainforestTallTree = features.sparseTree("rainforest_tall_tree", TropicraftFeatures.TALL_TREE, IFeatureConfig.field_202429_e, 0.5f);
        this.rainforestVines = features.register("rainforest_vines", TropicraftFeatures.VINES, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_(new RainforestVinesConfig()).func_242728_a()).func_242731_b(50));
        this.smallGoldenLeatherFern = features.register("small_golden_leather_fern", Feature.field_227248_z_, feature -> {
            SimpleBlockStateProvider state = new SimpleBlockStateProvider(((BushBlock)TropicraftBlocks.GOLDEN_LEATHER_FERN.get()).func_176223_P());
            return feature.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)state, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(12).func_227322_d_()).func_227228_a_(Features.Placements.field_244002_m);
        });
        this.tallGoldenLeatherFern = features.register("tall_golden_leather_fern", Feature.field_227248_z_, feature -> {
            SimpleBlockStateProvider state = new SimpleBlockStateProvider(((DoublePlantBlock)TropicraftBlocks.TALL_GOLDEN_LEATHER_FERN.get()).func_176223_P());
            return feature.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)state, (BlockPlacer)DoublePlantBlockPlacer.field_236444_c_).func_227315_a_(6).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l);
        });
        this.hugeGoldenLeatherFern = features.register("huge_golden_leather_fern", Feature.field_227248_z_, feature -> {
            SimpleBlockStateProvider state = new SimpleBlockStateProvider(((HugePlantBlock)TropicraftBlocks.LARGE_GOLDEN_LEATHER_FERN.get()).func_176223_P());
            return feature.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)state, (BlockPlacer)HugePlantBlockPlacer.INSTANCE).func_227315_a_(3).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l);
        });
        this.pleodendron = features.tree("pleodendron", new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196620_N.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196648_Z.func_176223_P()), (FoliagePlacer)new PleodendronFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 1), (AbstractTrunkPlacer)new PleodendronTrunkPlacer(10, 8, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_225568_b_(), 0, 0.05f, 1);
        MangroveFoliagePlacer mangroveFoliage = new MangroveFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0));
        SimpleBlockStateProvider redMangroveLog = new SimpleBlockStateProvider(((RotatedPillarBlock)TropicraftBlocks.RED_MANGROVE_LOG.get()).func_176223_P());
        SimpleBlockStateProvider lightMangroveLog = new SimpleBlockStateProvider(((RotatedPillarBlock)TropicraftBlocks.LIGHT_MANGROVE_LOG.get()).func_176223_P());
        SimpleBlockStateProvider blackMangroveLog = new SimpleBlockStateProvider(((RotatedPillarBlock)TropicraftBlocks.BLACK_MANGROVE_LOG.get()).func_176223_P());
        Block redMangroveRoots = (Block)TropicraftBlocks.RED_MANGROVE_ROOTS.get();
        Block lightMangroveRoots = (Block)TropicraftBlocks.LIGHT_MANGROVE_ROOTS.get();
        Block blackMangroveRoots = (Block)TropicraftBlocks.BLACK_MANGROVE_ROOTS.get();
        SimpleBlockStateProvider redMangroveLeaves = new SimpleBlockStateProvider(((LeavesBlock)TropicraftBlocks.RED_MANGROVE_LEAVES.get()).func_176223_P());
        SimpleBlockStateProvider tallMangroveLeaves = new SimpleBlockStateProvider(((LeavesBlock)TropicraftBlocks.TALL_MANGROVE_LEAVES.get()).func_176223_P());
        SimpleBlockStateProvider teaMangroveLeaves = new SimpleBlockStateProvider(((LeavesBlock)TropicraftBlocks.TEA_MANGROVE_LEAVES.get()).func_176223_P());
        SimpleBlockStateProvider blackMangroveLeaves = new SimpleBlockStateProvider(((LeavesBlock)TropicraftBlocks.BLACK_MANGROVE_LEAVES.get()).func_176223_P());
        TwoLayerFeature mangroveMinimumSize = new TwoLayerFeature(0, 0, 0, OptionalInt.of(4));
        MangroveTrunkPlacer redMangroveTrunk = new MangroveTrunkPlacer(3, 3, 0, redMangroveRoots, true, false);
        this.redMangroveShort = features.mangrove("red_mangrove_short", new BaseTreeFeatureConfig.Builder((BlockStateProvider)redMangroveLog, (BlockStateProvider)redMangroveLeaves, (FoliagePlacer)mangroveFoliage, (AbstractTrunkPlacer)redMangroveTrunk, (AbstractFeatureSizeType)mangroveMinimumSize).func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243991_b, (Object)((Object)PianguasTreeDecorator.REGULAR))).func_236701_a_(1).func_225568_b_());
        this.redMangroveSmall = features.mangrove("red_mangrove_small", new BaseTreeFeatureConfig.Builder((BlockStateProvider)redMangroveLog, (BlockStateProvider)redMangroveLeaves, (FoliagePlacer)new SmallMangroveFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new SmallMangroveTrunkPlacer(2, 1, 0, redMangroveRoots), (AbstractFeatureSizeType)mangroveMinimumSize).func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243991_b, (Object)((Object)PianguasTreeDecorator.SMALL))).func_225568_b_());
        this.redMangrove = features.random("red_mangrove", this.redMangroveShort, this.redMangroveSmall);
        this.tallMangrove = features.mangrove("tall_mangrove", new BaseTreeFeatureConfig.Builder((BlockStateProvider)lightMangroveLog, (BlockStateProvider)tallMangroveLeaves, (FoliagePlacer)mangroveFoliage, (AbstractTrunkPlacer)new MangroveTrunkPlacer(7, 4, 2, lightMangroveRoots, false, false), (AbstractFeatureSizeType)mangroveMinimumSize).func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243991_b, (Object)((Object)PianguasTreeDecorator.REGULAR))).func_236701_a_(2).func_225568_b_());
        PneumatophoresTreeDecorator teaMangrovePneumatophores = new PneumatophoresTreeDecorator(lightMangroveRoots, 2, 6, 4);
        this.teaMangrove = features.mangrove("tea_mangrove", new BaseTreeFeatureConfig.Builder((BlockStateProvider)lightMangroveLog, (BlockStateProvider)teaMangroveLeaves, (FoliagePlacer)mangroveFoliage, (AbstractTrunkPlacer)new MangroveTrunkPlacer(5, 3, 0, lightMangroveRoots, false, true), (AbstractFeatureSizeType)mangroveMinimumSize).func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243991_b, (Object)((Object)PianguasTreeDecorator.REGULAR), (Object)((Object)teaMangrovePneumatophores))).func_236701_a_(1).func_225568_b_());
        PneumatophoresTreeDecorator blackMangrovePneumatophores = new PneumatophoresTreeDecorator(blackMangroveRoots, 8, 16, 6);
        this.blackMangrove = features.mangrove("black_mangrove", new BaseTreeFeatureConfig.Builder((BlockStateProvider)blackMangroveLog, (BlockStateProvider)blackMangroveLeaves, (FoliagePlacer)mangroveFoliage, (AbstractTrunkPlacer)new MangroveTrunkPlacer(4, 3, 0, blackMangroveRoots, true, false), (AbstractFeatureSizeType)mangroveMinimumSize).func_236703_a_((List)ImmutableList.of((Object)Features.Placements.field_243991_b, (Object)((Object)PianguasTreeDecorator.REGULAR), (Object)((Object)blackMangrovePneumatophores))).func_236701_a_(1).func_225568_b_());
        this.lightMangroves = features.random("light_mangroves", this.tallMangrove, this.teaMangrove, this.blackMangrove);
        this.mangroves = features.random("mangroves", this.redMangrove, this.lightMangroves);
        this.mangroveVegetation = features.register("mangrove_vegetation", this.mangroves.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(7, 200.0, 1.5))));
        this.mudDisk = features.register("mud_disk", Feature.field_202285_ae, feature -> (ConfiguredFeature)feature.func_225566_b_((IFeatureConfig)new SphereReplaceConfig(((Block)TropicraftBlocks.MUD.get()).func_176223_P(), FeatureSpread.func_242253_a((int)2, (int)4), 2, (List)ImmutableList.of((Object)Blocks.field_150346_d.func_176223_P(), (Object)Blocks.field_196658_i.func_176223_P()))).func_227228_a_(Features.Placements.field_244003_n).func_242731_b(3));
        this.eih = features.noConfig("eih", TropicraftFeatures.EIH, f -> f.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.01f, 1))));
        this.tropicsGrass = features.register("tropics_grass", Feature.field_227248_z_, f -> (ConfiguredFeature)f.func_225566_b_((IFeatureConfig)Features.Configs.field_243979_c).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(10));
        this.bamboo = features.register("bamboo", Feature.field_214482_aJ, f -> ((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.15f)).func_227228_a_(Features.Placements.field_243996_g).func_242728_a()).func_227228_a_(Placement.field_242901_e.func_227446_a_((IPlacementConfig)new TopSolidWithNoiseConfig(70, 140.0, 0.3))));
        this.pineapplePatch = features.register("pineapple_patch", Feature.field_227248_z_, feature -> {
            SimpleBlockStateProvider state = new SimpleBlockStateProvider(((PineappleBlock)TropicraftBlocks.PINEAPPLE.get()).func_176223_P());
            return feature.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)state, (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l);
        });
        this.tropicsFlowers = features.register("tropics_flowers", Feature.field_227247_y_, feature -> {
            NoiseFromTagBlockStateProvider stateProvider = new NoiseFromTagBlockStateProvider((ITag<Block>)TropicraftTags.Blocks.TROPICS_FLOWERS);
            BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)stateProvider, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227322_d_();
            return feature.func_225566_b_((IFeatureConfig)config).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(12));
        });
        this.rainforestFlowers = features.register("rainforest_flowers", Feature.field_227247_y_, feature -> {
            NoiseFromTagBlockStateProvider stateProvider = new NoiseFromTagBlockStateProvider((ITag<Block>)TropicraftTags.Blocks.RAINFOREST_FLOWERS);
            BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)stateProvider, (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(64).func_227317_b_().func_227322_d_();
            return feature.func_225566_b_((IFeatureConfig)config).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(4));
        });
        this.irisFlowers = features.register("iris_flowers", Feature.field_227248_z_, feature -> {
            SimpleBlockStateProvider stateProvider = new SimpleBlockStateProvider(((TallFlowerBlock)TropicraftBlocks.IRIS.get()).func_176223_P());
            BlockClusterFeatureConfig config = new BlockClusterFeatureConfig.Builder((BlockStateProvider)stateProvider, (BlockPlacer)new DoublePlantBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
            return feature.func_225566_b_((IFeatureConfig)config).func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(10));
        });
        this.coffeeBush = features.noConfig("coffee_bush", TropicraftFeatures.COFFEE_BUSH, feature -> feature.func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(5)));
        this.undergrowth = features.noConfig("undergrowth", TropicraftFeatures.UNDERGROWTH, feature -> feature.func_227228_a_((ConfiguredPlacement)Features.Placements.field_244000_k.func_227228_a_(Features.Placements.field_244001_l).func_242731_b(100)));
        this.seagrass = features.register("seagrass", Feature.field_203234_at, feature -> (ConfiguredFeature)((ConfiguredFeature)feature.func_225566_b_((IFeatureConfig)new ProbabilityConfig(0.3f)).func_242731_b(48)).func_227228_a_(Features.Placements.field_244003_n).func_242731_b(3));
        this.undergroundSeagrassOnStone = features.register("underground_seagrass_on_stone", Feature.field_206922_aF, feature -> {
            BlockWithContextConfig config = new BlockWithContextConfig(Blocks.field_203198_aQ.func_176223_P(), (List)ImmutableList.of((Object)Blocks.field_150348_b.func_176223_P()), (List)ImmutableList.of((Object)Blocks.field_150355_j.func_176223_P()), (List)ImmutableList.of((Object)Blocks.field_150355_j.func_176223_P()));
            return feature.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.1f)));
        });
        this.undergroundSeagrassOnDirt = features.register("underground_seagrass_on_dirt", Feature.field_206922_aF, feature -> {
            BlockWithContextConfig config = new BlockWithContextConfig(Blocks.field_203198_aQ.func_176223_P(), (List)ImmutableList.of((Object)Blocks.field_150346_d.func_176223_P()), (List)ImmutableList.of((Object)Blocks.field_150355_j.func_176223_P()), (List)ImmutableList.of((Object)Blocks.field_150355_j.func_176223_P()));
            return feature.func_225566_b_((IFeatureConfig)config).func_227228_a_(Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.5f)));
        });
        this.undergroundSeaPickles = features.noConfig("underground_sea_pickles", TropicraftFeatures.UNDERGROUND_SEA_PICKLE, feature -> feature.func_227228_a_(Placement.field_215039_y.func_227446_a_((IPlacementConfig)new CaveEdgeConfig(GenerationStage.Carving.LIQUID, 0.05f))));
        this.mangroveReeds = features.noConfig("mangrove_reeds", TropicraftFeatures.REEDS, feature -> (ConfiguredFeature)feature.func_227228_a_(Features.Placements.field_244003_n).func_242731_b(2));
        this.azurite = features.register("azurite", Feature.field_202290_aj, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TropicraftBlocks.AZURITE_ORE.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(100, 0, 128))).func_242728_a()).func_242731_b(3));
        this.eudialyte = features.register("eudialyte", Feature.field_202290_aj, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TropicraftBlocks.EUDIALYTE_ORE.get()).func_176223_P(), 12)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(100, 0, 128))).func_242728_a()).func_242731_b(10));
        this.zircon = features.register("zircon", Feature.field_202290_aj, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TropicraftBlocks.ZIRCON_ORE.get()).func_176223_P(), 14)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(100, 0, 128))).func_242728_a()).func_242731_b(15));
        this.manganese = features.register("manganese", Feature.field_202290_aj, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TropicraftBlocks.MANGANESE_ORE.get()).func_176223_P(), 10)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(32, 0, 32))).func_242728_a()).func_242731_b(8));
        this.shaka = features.register("shaka", Feature.field_202290_aj, f -> (ConfiguredFeature)((ConfiguredFeature)f.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, ((Block)TropicraftBlocks.SHAKA_ORE.get()).func_176223_P(), 8)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(0, 0, 32))).func_242728_a()).func_242731_b(6));
        this.homeTreeBranchSouth = features.homeTreeBranch("home_tree/branch/south", -30.0f, 30.0f);
        this.homeTreeBranchSouthExact = features.homeTreeBranch("home_tree/branch/south_exact", 0.0f, 0.0f);
        this.homeTreeBranchSouthEast = features.homeTreeBranch("home_tree/branch/southeast", 30.0f, 60.0f);
        this.homeTreeBranchSouthEastExact = features.homeTreeBranch("home_tree/branch/southeast_exact", 45.0f, 45.0f);
        this.homeTreeBranchEast = features.homeTreeBranch("home_tree/branch/east", 60.0f, 120.0f);
        this.homeTreeBranchEastExact = features.homeTreeBranch("home_tree/branch/east_exact", 90.0f, 90.0f);
        this.homeTreeBranchNorthEast = features.homeTreeBranch("home_tree/branch/northeast", 120.0f, 150.0f);
        this.homeTreeBranchNorthEastExact = features.homeTreeBranch("home_tree/branch/northeast_exact", 135.0f, 135.0f);
        this.homeTreeBranchNorth = features.homeTreeBranch("home_tree/branch/north", 150.0f, 210.0f);
        this.homeTreeBranchNorthExact = features.homeTreeBranch("home_tree/branch/north_exact", 180.0f, 180.0f);
        this.homeTreeBranchNorthWest = features.homeTreeBranch("home_tree/branch/northwest", 210.0f, 240.0f);
        this.homeTreeBranchNorthWestExact = features.homeTreeBranch("home_tree/branch/northwest_exact", 225.0f, 225.0f);
        this.homeTreeBranchWest = features.homeTreeBranch("home_tree/branch/west", 240.0f, 300.0f);
        this.homeTreeBranchWestExact = features.homeTreeBranch("home_tree/branch/west_exact", 270.0f, 270.0f);
        this.homeTreeBranchSouthWest = features.homeTreeBranch("home_tree/branch/southwest", 300.0f, 330.0f);
        this.homeTreeBranchSouthWestExact = features.homeTreeBranch("home_tree/branch/southwest_exact", 315.0f, 315.0f);
    }

    public void addFruitTrees(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.grapefruitTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.orangeTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.lemonTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.limeTree);
    }

    public void addPalmTrees(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.normalPalmTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.curvedPalmTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.largePalmTree);
    }

    public void addRainforestTrees(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.rainforestUpTree);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.rainforestSmallTualung);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.rainforestLargeTualung);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.rainforestTallTree);
    }

    public void addRainforestPlants(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Features.field_243807_aF);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.rainforestVines);
    }

    public void addMangroveVegetation(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.mangroveVegetation);
    }

    public void addGoldenLeatherFern(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.smallGoldenLeatherFern);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.tallGoldenLeatherFern);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.hugeGoldenLeatherFern);
    }

    public void addPleodendron(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.pleodendron);
    }

    public void addMudDisks(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.mudDisk);
    }

    public void addMangroveReeds(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.mangroveReeds);
    }

    public void addTropicsGrass(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.tropicsGrass);
    }

    public void addBamboo(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.bamboo);
    }

    public void addPineapples(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.pineapplePatch);
    }

    public void addEih(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.eih);
    }

    public void addTropicsFlowers(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.tropicsFlowers);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.irisFlowers);
    }

    public void addTropicsGems(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.azurite);
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.eudialyte);
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.zircon);
    }

    public void addTropicsMetals(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.manganese);
        generation.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, this.shaka);
    }

    public void addUndergroundSeagrass(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.undergroundSeagrassOnStone);
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.undergroundSeagrassOnDirt);
    }

    public void addRegularSeagrass(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.seagrass);
    }

    public void addUndergroundPickles(BiomeGenerationSettings.Builder generation) {
        generation.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, this.undergroundSeaPickles);
    }

    static final class Register {
        private final WorldgenDataConsumer<ConfiguredFeature<?, ?>> worldgen;

        Register(WorldgenDataConsumer<? extends ConfiguredFeature<?, ?>> worldgen) {
            this.worldgen = worldgen;
        }

        public <F extends Feature<?>> ConfiguredFeature<?, ?> register(String id, ConfiguredFeature<?, ?> feature) {
            return this.worldgen.register(new ResourceLocation("tropicraft", id), feature);
        }

        public <F extends Feature<?>> ConfiguredFeature<?, ?> register(String id, F feature, Function<F, ConfiguredFeature<?, ?>> configure) {
            return this.register(id, configure.apply(feature));
        }

        public <F extends Feature<?>> ConfiguredFeature<?, ?> register(String id, RegistryObject<F> feature, Function<F, ConfiguredFeature<?, ?>> configure) {
            return this.register(id, (Feature)feature.get(), configure);
        }

        public <F extends Feature<NoFeatureConfig>> ConfiguredFeature<?, ?> noConfig(String id, RegistryObject<F> feature, UnaryOperator<ConfiguredFeature<?, ?>> configure) {
            return this.register(id, feature, (F f) -> (ConfiguredFeature)configure.apply(f.func_225566_b_((IFeatureConfig)NoFeatureConfig.field_236559_b_)));
        }

        public ConfiguredFeature<?, ?> fruitTree(String id, Supplier<? extends Block> sapling, Supplier<? extends Block> fruitLeaves) {
            BaseTreeFeatureConfig config = new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P()), (BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(((LeavesBlock)TropicraftBlocks.FRUIT_LEAVES.get()).func_176223_P(), 1).func_227407_a_(fruitLeaves.get().func_176223_P(), 1), (FoliagePlacer)new CitrusFoliagePlacer(FeatureSpread.func_242252_a((int)0), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new CitrusTrunkPlacer(6, 3, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_225568_b_();
            return this.tree(id, config, 0, 0.1f, 1);
        }

        public <C extends IFeatureConfig, F extends Feature<C>> ConfiguredFeature<?, ?> sparseTree(String id, RegistryObject<F> feature, C config, float chance) {
            return this.register(id, feature, (F f) -> f.func_225566_b_(config).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, chance, 1))));
        }

        public <F extends Feature<?>> ConfiguredFeature<?, ?> tree(String id, BaseTreeFeatureConfig config, int count, float extraChance, int extraCount) {
            return this.register(id, Feature.field_236291_c_, (F feature) -> feature.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(count, extraChance, extraCount))));
        }

        public ConfiguredFeature<?, ?> mangrove(String id, BaseTreeFeatureConfig config) {
            return this.register(id, (Feature)TropicraftFeatures.MANGROVE_TREE.get(), (F feature) -> feature.func_225566_b_((IFeatureConfig)config));
        }

        public ConfiguredFeature<?, ?> random(String id, ConfiguredFeature<?, ?> ... choices) {
            if (choices.length == 2) {
                ConfiguredFeature<?, ?> left = choices[0];
                ConfiguredFeature<?, ?> right = choices[1];
                return this.register(id, Feature.field_202293_am, (F feature) -> feature.func_225566_b_((IFeatureConfig)new TwoFeatureChoiceConfig(() -> left, () -> right)));
            }
            return this.register(id, Feature.field_204620_ao, (F feature) -> {
                SingleRandomFeature config = new SingleRandomFeature(Arrays.stream(choices).map(c -> () -> c).collect(Collectors.toList()));
                return feature.func_225566_b_((IFeatureConfig)config);
            });
        }

        public <C extends IFeatureConfig, F extends Feature<C>> ConfiguredFeature<?, ?> homeTreeBranch(String id, float minAngle, float maxAngle) {
            return this.register(id, TropicraftFeatures.HOME_TREE_BRANCH, (F f) -> f.func_225566_b_(new HomeTreeBranchConfig(minAngle, maxAngle)));
        }
    }
}

