/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.CoffeePlantFeature;
import net.tropicraft.core.common.dimension.feature.EIHFeature;
import net.tropicraft.core.common.dimension.feature.HomeTreeBranchFeature;
import net.tropicraft.core.common.dimension.feature.HomeTreeStructure;
import net.tropicraft.core.common.dimension.feature.KoaVillageStructure;
import net.tropicraft.core.common.dimension.feature.ReedsFeature;
import net.tropicraft.core.common.dimension.feature.UndergroundSeaPickleFeature;
import net.tropicraft.core.common.dimension.feature.UndergrowthFeature;
import net.tropicraft.core.common.dimension.feature.config.FruitTreeConfig;
import net.tropicraft.core.common.dimension.feature.config.HomeTreeBranchConfig;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;
import net.tropicraft.core.common.dimension.feature.jigsaw.SinkInGroundProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SmoothingGravityProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.SteepPathProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.StructureSupportsProcessor;
import net.tropicraft.core.common.dimension.feature.tree.CurvedPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.FruitTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.LargePalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.NormalPalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.RainforestVinesFeature;
import net.tropicraft.core.common.dimension.feature.tree.TallRainforestTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.TualungFeature;
import net.tropicraft.core.common.dimension.feature.tree.UpTreeFeature;
import net.tropicraft.core.common.dimension.feature.tree.mangrove.MangroveTreeFeature;

public class TropicraftFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"tropicraft");
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"tropicraft");
    public static final RegistryObject<FruitTreeFeature> FRUIT_TREE = TropicraftFeatures.register("fruit_tree", () -> new FruitTreeFeature(FruitTreeConfig.CODEC));
    public static final RegistryObject<PalmTreeFeature> NORMAL_PALM_TREE = TropicraftFeatures.register("normal_palm_tree", () -> new NormalPalmTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<PalmTreeFeature> CURVED_PALM_TREE = TropicraftFeatures.register("curved_palm_tree", () -> new CurvedPalmTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<PalmTreeFeature> LARGE_PALM_TREE = TropicraftFeatures.register("large_palm_tree", () -> new LargePalmTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<RainforestTreeFeature> UP_TREE = TropicraftFeatures.register("up_tree", () -> new UpTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<RainforestTreeFeature> SMALL_TUALUNG = TropicraftFeatures.register("small_tualung", () -> new TualungFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 16, 9));
    public static final RegistryObject<RainforestTreeFeature> LARGE_TUALUNG = TropicraftFeatures.register("large_tualung", () -> new TualungFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, 25, 11));
    public static final RegistryObject<RainforestTreeFeature> TALL_TREE = TropicraftFeatures.register("tall_tree", () -> new TallRainforestTreeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<EIHFeature> EIH = TropicraftFeatures.register("eih", () -> new EIHFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<UndergrowthFeature> UNDERGROWTH = TropicraftFeatures.register("undergrowth", () -> new UndergrowthFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<RainforestVinesFeature> VINES = TropicraftFeatures.register("rainforest_vines", () -> new RainforestVinesFeature(RainforestVinesConfig.CODEC));
    public static final RegistryObject<UndergroundSeaPickleFeature> UNDERGROUND_SEA_PICKLE = TropicraftFeatures.register("underground_sea_pickle", () -> new UndergroundSeaPickleFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<Structure<VillageConfig>> KOA_VILLAGE = TropicraftFeatures.registerStructure("koa_village", new KoaVillageStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final RegistryObject<Structure<VillageConfig>> HOME_TREE = TropicraftFeatures.registerStructure("home_tree", new HomeTreeStructure((Codec<VillageConfig>)VillageConfig.field_236533_a_), GenerationStage.Decoration.SURFACE_STRUCTURES);
    public static final RegistryObject<HomeTreeBranchFeature<HomeTreeBranchConfig>> HOME_TREE_BRANCH = TropicraftFeatures.register("home_tree_branch", () -> new HomeTreeBranchFeature<HomeTreeBranchConfig>(HomeTreeBranchConfig.CODEC));
    public static final RegistryObject<CoffeePlantFeature> COFFEE_BUSH = TropicraftFeatures.register("coffee_bush", () -> new CoffeePlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<ReedsFeature> REEDS = TropicraftFeatures.register("reeds", () -> new ReedsFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_));
    public static final RegistryObject<MangroveTreeFeature> MANGROVE_TREE = TropicraftFeatures.register("mangrove_tree", () -> new MangroveTreeFeature((TreeFeature)Feature.field_236291_c_, (Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    public static final JigsawPattern.PlacementBehaviour KOA_PATH = JigsawPattern.PlacementBehaviour.create((String)"KOA_PATH", (String)"tropicraft:koa_path", (ImmutableList)ImmutableList.of((Object)((Object)new SmoothingGravityProcessor(Heightmap.Type.WORLD_SURFACE_WG, -1)), (Object)((Object)new SinkInGroundProcessor()), (Object)((Object)new SteepPathProcessor()), (Object)((Object)new StructureSupportsProcessor(false, (List<ResourceLocation>)ImmutableList.of((Object)TropicraftBlocks.BAMBOO_FENCE.getId())))));

    private static <T extends Feature<?>> RegistryObject<T> register(String name, Supplier<T> sup) {
        return FEATURES.register(name, sup);
    }

    private static <T extends Structure<?>> RegistryObject<T> registerStructure(String name, T structure, GenerationStage.Decoration step) {
        Structure.field_236365_a_.put((Object)("tropicraft:" + name), structure);
        Structure.field_236385_u_.put(structure, step);
        return STRUCTURES.register(name, () -> structure);
    }
}

