/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.GravityStructureProcessor;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;

public class SmoothingGravityProcessor
extends PathStructureProcessor {
    public static final Codec<SmoothingGravityProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Heightmap.Type.field_236078_g_.fieldOf("heightmap").forGetter(p -> p.heightmap), (App)Codec.INT.fieldOf("offset").forGetter(p -> p.offset)).apply((Applicative)instance, SmoothingGravityProcessor::new));
    static final IStructureProcessorType<SmoothingGravityProcessor> TYPE = (IStructureProcessorType)Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"tropicraft:smooth_gravity", () -> CODEC);
    private final Heightmap.Type heightmap;
    private final int offset;
    private final GravityStructureProcessor baseline;

    public SmoothingGravityProcessor(Heightmap.Type heightmap, int offset) {
        this.heightmap = heightmap;
        this.offset = offset;
        this.baseline = new GravityStructureProcessor(heightmap, offset);
    }

    public Template.BlockInfo process(IWorldReader world, BlockPos seedPos, BlockPos pos2, Template.BlockInfo originalBlockInfo, Template.BlockInfo blockInfo, PlacementSettings placementSettingsIn, Template template) {
        Direction.Axis pathDir = this.getPathDirection(seedPos, blockInfo, placementSettingsIn, template);
        if (pathDir == null) {
            pathDir = Direction.Axis.X;
        }
        BlockPos pos = blockInfo.field_186242_a;
        BlockPos posForward = pos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)pathDir));
        BlockPos posBackward = pos.func_177972_a(Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.NEGATIVE, (Direction.Axis)pathDir));
        int heightForward = world.func_201676_a(this.heightmap, posForward.func_177958_n(), posForward.func_177952_p()) + this.offset;
        int heightBackward = world.func_201676_a(this.heightmap, posBackward.func_177958_n(), posBackward.func_177952_p()) + this.offset;
        int height = world.func_201676_a(this.heightmap, pos.func_177958_n(), pos.func_177952_p()) + this.offset;
        if (heightForward > height && heightBackward > height) {
            return new Template.BlockInfo(new BlockPos(pos.func_177958_n(), Math.min(heightForward, heightBackward), pos.func_177952_p()), blockInfo.field_186243_b, blockInfo.field_186244_c);
        }
        return this.baseline.process(world, seedPos, pos2, originalBlockInfo, blockInfo, placementSettingsIn, template);
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return TYPE;
    }
}

