/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.serialization.Codec;
import net.minecraft.block.BlockState;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;

public class SteepPathProcessor
extends PathStructureProcessor {
    public static final Codec<SteepPathProcessor> CODEC = Codec.unit((Object)((Object)new SteepPathProcessor()));
    static final IStructureProcessorType<SteepPathProcessor> TYPE = (IStructureProcessorType)Registry.func_218325_a((Registry)Registry.field_218364_E, (String)"tropicraft:steep_path", () -> CODEC);

    public Template.BlockInfo process(IWorldReader worldReaderIn, BlockPos seedPos, BlockPos pos2, Template.BlockInfo originalBlockInfo, Template.BlockInfo blockInfo, PlacementSettings placementSettingsIn, Template template) {
        BlockPos pos = blockInfo.field_186242_a;
        if (originalBlockInfo.field_186242_a.func_177956_o() != 1 || originalBlockInfo.field_186243_b.func_177230_c() == TropicraftBlocks.BAMBOO_STAIRS.get()) {
            return blockInfo;
        }
        Direction.Axis axis = this.getPathDirection(seedPos, blockInfo, placementSettingsIn, template);
        if (axis == null) {
            return blockInfo;
        }
        int bridgeTo = -1;
        BlockState ladder = null;
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            Direction dir = Direction.func_181076_a((Direction.AxisDirection)axisDir, (Direction.Axis)axis);
            BlockPos nextHeight = worldReaderIn.func_205770_a(Heightmap.Type.WORLD_SURFACE_WG, pos.func_177972_a(dir)).func_177977_b();
            if (nextHeight.func_177956_o() > pos.func_177956_o()) {
                ladder = this.getLadderState(dir);
                bridgeTo = nextHeight.func_177956_o();
            }
            if (ladder != null) break;
        }
        if (ladder == null) {
            return blockInfo;
        }
        Direction dir = ((Direction)ladder.func_177229_b((Property)LadderBlock.field_176382_a)).func_176734_d();
        if (bridgeTo == (pos = pos.func_177984_a()).func_177956_o() && this.canPlaceLadderAt(worldReaderIn, pos.func_177984_a(), dir) == null) {
            this.setBlockState(worldReaderIn, pos, (BlockState)((StairsBlock)TropicraftBlocks.THATCH_STAIRS.get()).func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)dir));
        } else {
            while (bridgeTo >= pos.func_177956_o() || this.canPlaceLadderAt(worldReaderIn, pos, dir) != null) {
                this.setBlockState(worldReaderIn, pos, ladder);
                this.setBlockState(worldReaderIn, pos.func_177972_a(dir), ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).func_176223_P());
                pos = pos.func_177984_a();
            }
        }
        return blockInfo;
    }

    private BlockState canPlaceLadderAt(IWorldReader worldReaderIn, BlockPos pos, Direction dir) {
        BlockState ladderState;
        BlockPos check = pos.func_177972_a(dir);
        BlockState state = worldReaderIn.func_180495_p(check);
        if (!state.isAir((IBlockReader)worldReaderIn, check) && (ladderState = this.getLadderState(dir)).func_196955_c(worldReaderIn, pos)) {
            return ladderState;
        }
        return null;
    }

    private BlockState getLadderState(Direction dir) {
        return (BlockState)((LadderBlock)TropicraftBlocks.BAMBOO_LADDER.get()).func_176223_P().func_206870_a((Property)LadderBlock.field_176382_a, (Comparable)dir.func_176734_d());
    }

    protected IStructureProcessorType<?> func_215192_a() {
        return TYPE;
    }
}

