/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.PalmTreeFeature;

public class CurvedPalmTreeFeature
extends PalmTreeFeature {
    private static final int Z_PLUS = 0;
    private static final int Z_MINUS = 1;
    private static final int X_PLUS = 2;
    private static final int X_MINUS = 3;
    private static final int TOP_OFFSET = 3;
    private static final int WATER_SEARCH_DIST = 10;
    private int originX;
    private int originZ;
    private int dir;

    public CurvedPalmTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        int yy;
        int xx;
        pos = pos.func_185334_h();
        int height = 9 + rand.nextInt(3);
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().func_196260_a(this.getSapling().func_176223_P(), (IWorldReader)world, pos)) {
            return false;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int dir = this.pickDirection((IWorldGenerationReader)world, rand, x, z);
        this.setDir(dir);
        this.setOrigin(x, z);
        for (xx = 0; xx < 4; ++xx) {
            for (yy = 0; yy < height; ++yy) {
                BlockPos posWithDir = this.getPosWithDir(xx, yy + y, 0);
                if (CurvedPalmTreeFeature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)posWithDir)) continue;
                return false;
            }
        }
        for (xx = 0; xx < 9; ++xx) {
            for (int zz = 0; zz < 9; ++zz) {
                for (int yy2 = height - 3; yy2 < height + 4; ++yy2) {
                    if (CurvedPalmTreeFeature.func_236297_b_((IWorldGenerationBaseReader)world, (BlockPos)this.getPosWithDir(xx + 3, yy2 + y, zz))) continue;
                    return false;
                }
            }
        }
        xx = 0;
        for (yy = 0; yy < height; ++yy) {
            this.placeBlockWithDir((IWorldWriter)world, xx, yy + y, 0, this.getLog());
            if (yy == 0 || yy == 1 || yy == 3) {
                this.placeBlockWithDir((IWorldWriter)world, ++xx, yy + y, 0, this.getLog());
            }
            if (yy != height - 2) continue;
            CurvedPalmTreeFeature.spawnCoconuts((IWorldGenerationReader)world, this.getPosWithDir(xx, yy + y, 0), rand, 2, this.getLeaf());
        }
        this.setOrigin(this.getActualXAt(3, 0), this.getActualZAt(3, 0));
        for (int yy3 = 1; yy3 < 5; ++yy3) {
            if (yy3 == 4) {
                this.placeBlockWithDir((IWorldWriter)world, 1, yy3 + y + height - 1, 0, this.getLeaf());
                continue;
            }
            this.placeBlockWithDir((IWorldWriter)world, 0, yy3 + y + height - 1, 0, this.getLeaf());
        }
        for (int curDir = 0; curDir < 4; ++curDir) {
            this.setDir(curDir);
            yy = height - 1;
            this.placeBlockWithDir((IWorldWriter)world, 1, yy - 1 + y, 1, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 2, yy - 2 + y, 1, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 1, yy - 2 + y, 2, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 2, yy - 3 + y, 2, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 1, yy + 1 + y, 1, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 2, yy + 2 + y, 1, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 1, yy + 2 + y, 2, this.getLeaf());
            this.placeBlockWithDir((IWorldWriter)world, 2, yy + 3 + y, 2, this.getLeaf());
            for (int xx2 = 1; xx2 < 5; ++xx2) {
                if (xx2 == 4) {
                    --yy;
                }
                this.placeBlockWithDir((IWorldWriter)world, xx2, yy + y, 0, this.getLeaf());
            }
        }
        return true;
    }

    private int findWater(IWorldGenerationReader world, Random rand, int x, int z) {
        int iPos;
        int iNeg = 0;
        int kPos = 0;
        int kNeg = 0;
        for (iPos = 0; iPos < 10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x + iPos, 127, z)); ++iPos) {
        }
        while (iNeg > -10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x + iNeg, 127, z))) {
            --iNeg;
        }
        while (kPos < 10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x, 127, z + kPos))) {
            ++kPos;
        }
        while (kNeg > -10 && !CurvedPalmTreeFeature.isWater(world, new BlockPos(x, 127, z + kNeg))) {
            --kNeg;
        }
        if (iPos < Math.abs(iNeg) && iPos < kPos && iPos < Math.abs(kNeg)) {
            return 2;
        }
        if (Math.abs(iNeg) < iPos && Math.abs(iNeg) < kPos && Math.abs(iNeg) < Math.abs(kNeg)) {
            return 3;
        }
        if (kPos < Math.abs(iNeg) && kPos < iPos && kPos < Math.abs(kNeg)) {
            return 0;
        }
        if (Math.abs(kNeg) < Math.abs(iNeg) && Math.abs(kNeg) < iPos && Math.abs(kNeg) < kPos) {
            return 1;
        }
        if (iPos < 10 && iPos == Math.abs(iNeg)) {
            return rand.nextInt(2) + 1;
        }
        if (iPos < 10 && iPos == kPos) {
            if (rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 0;
        }
        if (iPos < 10 && iPos == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 2;
            }
            return 1;
        }
        if (kPos < 10 && Math.abs(iNeg) == kPos) {
            if (rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 0;
        }
        if (Math.abs(iNeg) < 10 && Math.abs(iNeg) == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 3;
            }
            return 1;
        }
        if (kPos < 10 && kPos == Math.abs(kNeg)) {
            if (rand.nextInt(2) + 1 == 1) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    private static boolean isWater(IWorldGenerationReader world, BlockPos pos) {
        return world.func_217375_a(pos, state -> state.func_203425_a(Blocks.field_150355_j));
    }

    private int pickDirection(IWorldGenerationReader world, Random rand, int x, int z) {
        int direction = this.findWater(world, rand, x, z);
        if (direction != -1) {
            return direction;
        }
        return rand.nextInt(4);
    }

    private void setOrigin(int originX, int originZ) {
        this.originX = originX;
        this.originZ = originZ;
    }

    private void setDir(int dir) {
        this.dir = dir;
    }

    private BlockPos getPosWithDir(int x, int y, int z) {
        return this.getPosWithDir(this.pos(x, y, z));
    }

    private BlockPos getPosWithDir(BlockPos unRotatedPos) {
        int i = unRotatedPos.func_177958_n();
        int j = unRotatedPos.func_177956_o();
        int k = unRotatedPos.func_177952_p();
        switch (this.dir) {
            case 2: {
                return this.pos(this.originX + i, j, this.originZ + k);
            }
            case 0: {
                return this.pos(this.originX + k, j, this.originZ - i);
            }
            case 3: {
                return this.pos(this.originX - i, j, this.originZ - k);
            }
            case 1: {
                return this.pos(this.originX - k, j, this.originZ + i);
            }
        }
        return BlockPos.field_177992_a;
    }

    private void placeBlockWithDir(IWorldWriter world, int x, int y, int z, BlockState state) {
        switch (this.dir) {
            case 2: {
                this.func_230367_a_(world, this.pos(this.originX + x, y, this.originZ + z), state);
                return;
            }
            case 0: {
                this.func_230367_a_(world, this.pos(this.originX + z, y, this.originZ - x), state);
                return;
            }
            case 3: {
                this.func_230367_a_(world, this.pos(this.originX - x, y, this.originZ - z), state);
                return;
            }
            case 1: {
                this.func_230367_a_(world, this.pos(this.originX - z, y, this.originZ + x), state);
            }
        }
    }

    private int getActualXAt(int i, int k) {
        switch (this.dir) {
            case 2: {
                return this.originX + i;
            }
            case 0: {
                return this.originX + k;
            }
            case 3: {
                return this.originX - i;
            }
            case 1: {
                return this.originX - k;
            }
        }
        return this.originX;
    }

    private int getActualZAt(int i, int k) {
        switch (this.dir) {
            case 2: {
                return this.originZ + k;
            }
            case 0: {
                return this.originZ - i;
            }
            case 3: {
                return this.originZ - k;
            }
            case 1: {
                return this.originZ + i;
            }
        }
        return this.originZ;
    }

    public BlockPos pos(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }
}

