/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeature;
import net.tropicraft.core.common.block.CoconutBlock;
import net.tropicraft.core.common.block.TropicraftBlocks;
import org.apache.commons.lang3.ArrayUtils;

public abstract class PalmTreeFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] DIRECTIONS = (Direction[])ArrayUtils.removeElement((Object[])Direction.values(), (Object)Direction.UP);

    public PalmTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    protected SaplingBlock getSapling() {
        return (SaplingBlock)TropicraftBlocks.PALM_SAPLING.get();
    }

    protected final BlockState getLeaf() {
        return ((LeavesBlock)TropicraftBlocks.PALM_LEAVES.get()).func_176223_P();
    }

    protected final BlockState getLog() {
        return ((RotatedPillarBlock)TropicraftBlocks.PALM_LOG.get()).func_176223_P();
    }

    protected void placeLeaf(IWorldGenerationReader world, int x, int y, int z) {
        this.placeLeaf(world, new BlockPos(x, y, z));
    }

    protected void placeLeaf(IWorldGenerationReader world, BlockPos pos) {
        if (TreeFeature.func_236404_a_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, this.getLeaf());
        }
    }

    protected void placeLog(IWorldGenerationReader world, int x, int y, int z) {
        this.placeLog(world, new BlockPos(x, y, z));
    }

    protected void placeLog(IWorldGenerationReader world, BlockPos pos) {
        if (TreeFeature.func_236410_c_((IWorldGenerationBaseReader)world, (BlockPos)pos)) {
            this.func_230367_a_((IWorldWriter)world, pos, this.getLog());
        }
    }

    public static void spawnCoconuts(IWorldGenerationReader world, BlockPos pos, Random random, int chance, BlockState leaf) {
        BlockState coconut = ((Block)TropicraftBlocks.COCONUT.get()).func_176223_P();
        for (Direction d : DIRECTIONS) {
            BlockPos pos2 = pos.func_177972_a(d);
            if (random.nextInt(chance) != 0 || !TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)pos2)) continue;
            world.func_180501_a(pos2, (BlockState)coconut.func_206870_a((Property)CoconutBlock.field_176387_N, (Comparable)d.func_176734_d()), 3);
        }
    }
}

