/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public class PleodendronTrunkPlacer
extends AbstractTrunkPlacer {
    public static final Codec<PleodendronTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> PleodendronTrunkPlacer.func_236915_a_((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, PleodendronTrunkPlacer::new));

    public PleodendronTrunkPlacer(int baseHeight, int heightRandA, int heightRandB) {
        super(baseHeight, heightRandA, heightRandB);
    }

    protected TrunkPlacerType<?> func_230381_a_() {
        return TropicraftTrunkPlacers.PLEODENDRON;
    }

    public List<FoliagePlacer.Foliage> func_230382_a_(IWorldGenerationReader world, Random random, int height, BlockPos origin, Set<BlockPos> logs, MutableBoundingBox bounds, BaseTreeFeatureConfig config) {
        int i;
        PleodendronTrunkPlacer.func_236909_a_((IWorldGenerationReader)world, (BlockPos)origin.func_177977_b());
        ArrayList<FoliagePlacer.Foliage> leafNodes = new ArrayList<FoliagePlacer.Foliage>();
        for (i = 0; i < height; ++i) {
            PleodendronTrunkPlacer.func_236911_a_((IWorldGenerationReader)world, (Random)random, (BlockPos)origin.func_177981_b(i), logs, (MutableBoundingBox)bounds, (BaseTreeFeatureConfig)config);
        }
        leafNodes.add(new FoliagePlacer.Foliage(origin.func_177981_b(height + 1), -1, false));
        for (i = 5; i < height - 4; ++i) {
            if (random.nextInt(4) != 0) continue;
            this.growBranches(world, random, origin.func_177981_b(i), logs, bounds, config, leafNodes);
        }
        return leafNodes;
    }

    private void growBranches(IWorldGenerationReader world, Random random, BlockPos origin, Set<BlockPos> logs, MutableBoundingBox bounds, BaseTreeFeatureConfig config, List<FoliagePlacer.Foliage> leafNodes) {
        int count = random.nextInt(2) + 1;
        double thetaOffset = random.nextDouble() * 2.0 * Math.PI;
        for (int i = 0; i < count; ++i) {
            double theta = (double)i / (double)count * 2.0 * Math.PI + thetaOffset;
            theta += random.nextDouble() * Math.PI * 0.15;
            int dist = random.nextInt(3) == 0 ? 4 : 3;
            for (int j = 1; j <= dist; ++j) {
                int x = (int)(Math.cos(theta) * (double)j);
                int z = (int)(Math.sin(theta) * (double)j);
                BlockPos local = origin.func_177982_a(x, 0, z);
                Direction.Axis axis = Util.getAxisBetween(origin, local);
                PleodendronTrunkPlacer.func_236913_a_((IWorldWriter)world, (BlockPos)local, (BlockState)((BlockState)config.field_227368_m_.func_225574_a_(random, local).func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)axis)), (MutableBoundingBox)bounds);
                logs.add(local);
                if (j != dist) continue;
                leafNodes.add(new FoliagePlacer.Foliage(local.func_177981_b(1), -2, false));
            }
        }
    }
}

