/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.VineBlock;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.tropicraft.core.common.dimension.feature.config.RainforestVinesConfig;

public class RainforestVinesFeature
extends Feature<RainforestVinesConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();

    public RainforestVinesFeature(Codec<RainforestVinesConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, RainforestVinesConfig config) {
        BlockPos.Mutable mutablePos = pos.func_239590_i_();
        int maxY = Math.min(pos.func_177956_o() + config.height, world.func_234938_ad_());
        for (int y = pos.func_177956_o(); y < maxY; ++y) {
            block1: for (int i = 0; i < config.rollsPerY; ++i) {
                mutablePos.func_189533_g((Vector3i)pos);
                mutablePos.func_196234_d(rand.nextInt(config.xzSpread * 2) - config.xzSpread, 0, rand.nextInt(config.xzSpread * 2) - config.xzSpread);
                mutablePos.func_185336_p(y);
                if (!world.func_175623_d((BlockPos)mutablePos)) continue;
                for (Direction direction : DIRECTIONS) {
                    mutablePos.func_189536_c(direction);
                    BlockState attaching = world.func_180495_p((BlockPos)mutablePos);
                    if ((attaching.func_177230_c() != Blocks.field_196658_i || rand.nextInt(4) != 0) && !attaching.func_235714_a_((ITag)BlockTags.field_206952_E) || direction == Direction.DOWN || !VineBlock.func_196542_b((IBlockReader)world, (BlockPos)mutablePos, (Direction)direction)) continue;
                    mutablePos.func_189536_c(direction.func_176734_d());
                    int len = rand.nextInt(3) + 2;
                    for (int j = 0; j < len && world.func_175623_d((BlockPos)mutablePos); ++j) {
                        world.func_180501_a((BlockPos)mutablePos, (BlockState)Blocks.field_150395_bd.func_176223_P().func_206870_a((Property)VineBlock.func_176267_a((Direction)direction), (Comparable)Boolean.valueOf(true)), 2);
                        mutablePos.func_189536_c(Direction.DOWN);
                    }
                    continue block1;
                }
            }
        }
        return true;
    }
}

