/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class TallRainforestTreeFeature
extends RainforestTreeFeature {
    private static final int VINE_CHANCE = 5;
    private static final int SMALL_LEAF_CHANCE = 3;
    private static final int SECOND_CANOPY_CHANCE = 3;

    public TallRainforestTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    private boolean isSoil(IWorld world, BlockPos pos) {
        return this.getSapling().func_196260_a(this.getSapling().func_176223_P(), (IWorldReader)world, pos);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = pos.func_185334_h();
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        int height = rand.nextInt(15) + 15;
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.isSoil((IWorld)world, pos.func_177977_b())) {
            return false;
        }
        if (!this.isSoil((IWorld)world, pos.func_177974_f().func_177977_b())) {
            return false;
        }
        if (!this.isSoil((IWorld)world, pos.func_177976_e().func_177977_b())) {
            return false;
        }
        if (!this.isSoil((IWorld)world, pos.func_177978_c().func_177977_b())) {
            return false;
        }
        if (!this.isSoil((IWorld)world, pos.func_177968_d().func_177977_b())) {
            return false;
        }
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i - 1, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i + 1, j - 1, k), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k - 1), Blocks.field_150346_d.func_176223_P());
        this.setState((IWorldWriter)world, new BlockPos(i, j - 1, k + 1), Blocks.field_150346_d.func_176223_P());
        for (int y = j; y < j + height; ++y) {
            int nz;
            int nx;
            this.placeLog((IWorldGenerationReader)world, i, y, k);
            this.placeLog((IWorldGenerationReader)world, i - 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i + 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i, y, k - 1);
            this.placeLog((IWorldGenerationReader)world, i, y, k + 1);
            if (y - j > height / 2 && rand.nextInt(3) == 0) {
                nx = rand.nextInt(3) - 1 + i;
                nz = rand.nextInt(3) - 1 + k;
                this.genCircle((IWorldGenerationReader)world, new BlockPos(nx, y + 1, nz), 1.0, 0.0, this.getLeaf(), false);
                this.genCircle((IWorldGenerationReader)world, nx, y, nz, 2.0, 1.0, this.getLeaf(), false);
            }
            if (y - j <= height - height / 4 || y - j >= height - 3 || rand.nextInt(3) != 0) continue;
            nx = i + rand.nextInt(9) - 4;
            nz = k + rand.nextInt(9) - 4;
            int leafSize = rand.nextInt(3) + 5;
            this.genCircle((IWorldGenerationReader)world, nx, y + 3, nz, leafSize - 2, 0.0, this.getLeaf(), false);
            this.genCircle((IWorldGenerationReader)world, nx, y + 2, nz, leafSize - 1, leafSize - 3, this.getLeaf(), false);
            this.genCircle((IWorldGenerationReader)world, nx, y + 1, nz, leafSize, leafSize - 1, this.getLeaf(), false);
            this.placeBlockLine((IWorldGenerationReader)world, new int[]{i, y - 2, k}, new int[]{nx, y + 2, nz}, this.getLog());
        }
        int leafSize = rand.nextInt(5) + 9;
        this.genCircle((IWorldGenerationReader)world, i, j + height, k, leafSize - 2, 0.0, this.getLeaf(), false);
        this.genCircle((IWorldGenerationReader)world, i, j + height - 1, k, leafSize - 1, leafSize - 4, this.getLeaf(), false);
        this.genCircle((IWorldGenerationReader)world, i, j + height - 2, k, leafSize, leafSize - 1, this.getLeaf(), false);
        return true;
    }
}

