/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;
import net.tropicraft.core.common.dimension.feature.tree.RainforestTreeFeature;

public class UpTreeFeature
extends RainforestTreeFeature {
    public UpTreeFeature(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    public boolean generate(ISeedReader world, ChunkGenerator generator, Random rand, BlockPos pos, NoFeatureConfig config) {
        pos = pos.func_185334_h();
        int height = rand.nextInt(4) + 6;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.func_177956_o(), height)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isBBAvailable(world, pos, height)) {
            return false;
        }
        if (!this.getSapling().func_196260_a(this.getSapling().func_176223_P(), (IWorldReader)world, pos)) {
            return false;
        }
        world.func_180501_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P(), 3);
        for (int y = j; y < j + height; ++y) {
            this.placeLog((IWorldGenerationReader)world, i, y, k);
            if (rand.nextInt(5) == 0) {
                int x = rand.nextInt(3) - 1 + i;
                int z = k;
                if (x - i == 0) {
                    z += rand.nextBoolean() ? 1 : -1;
                }
                this.placeLeaf((IWorldGenerationReader)world, x, y, z);
            }
            if (y != j + height - 1) continue;
            this.placeLog((IWorldGenerationReader)world, i + 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i - 1, y, k);
            this.placeLog((IWorldGenerationReader)world, i, y, k + 1);
            this.placeLog((IWorldGenerationReader)world, i, y, k - 1);
        }
        int radius = rand.nextInt(2) + 3;
        this.genCircle((IWorldGenerationReader)world, i, j + height, k, radius, 0.0, this.getLeaf(), false);
        this.genCircle((IWorldGenerationReader)world, i, j + height + 1, k, radius + 2, radius, this.getLeaf(), false);
        this.genCircle((IWorldGenerationReader)world, i, j + height + 2, k, radius + 3, radius + 2, this.getLeaf(), false);
        return true;
    }
}

