/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.TreeFeature;
import net.minecraftforge.common.Tags;
import net.tropicraft.core.common.TropicraftTags;

public class MangroveTreeFeature
extends Feature<BaseTreeFeatureConfig> {
    private final TreeFeature backing;

    public MangroveTreeFeature(TreeFeature backing, Codec<BaseTreeFeatureConfig> codec) {
        super(codec);
        this.backing = backing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generate(ISeedReader world, ChunkGenerator generator, Random random, BlockPos pos, BaseTreeFeatureConfig config) {
        BlockPos placePos = this.findPlacePos(world, pos, config);
        if (placePos == null) {
            return false;
        }
        BlockPos soilPos = placePos.func_177977_b();
        BlockState soilState = world.func_180495_p(soilPos);
        boolean replaceSoil = soilState.func_235714_a_(TropicraftTags.Blocks.MUD) || soilState.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) || soilState.func_235714_a_((ITag)Tags.Blocks.SAND) || world.func_180495_p(soilPos.func_177977_b()).func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
        try {
            if (replaceSoil) {
                world.func_180501_a(soilPos, Blocks.field_150346_d.func_176223_P(), 3);
            }
            boolean bl = this.backing.func_241855_a(world, generator, random, pos, config);
            return bl;
        }
        finally {
            if (replaceSoil) {
                world.func_180501_a(soilPos, soilState, 3);
            }
        }
    }

    @Nullable
    private BlockPos findPlacePos(ISeedReader world, BlockPos pos, BaseTreeFeatureConfig config) {
        if (config.field_227372_q_) {
            return pos;
        }
        int floorY = world.func_205770_a(Heightmap.Type.OCEAN_FLOOR, pos).func_177956_o();
        int surfaceY = world.func_205770_a(Heightmap.Type.WORLD_SURFACE, pos).func_177956_o();
        int waterDepth = surfaceY - floorY;
        if (config.field_236680_i_ == 0 && waterDepth > 0) {
            return null;
        }
        if (waterDepth > 3) {
            return null;
        }
        if (waterDepth > config.field_236680_i_) {
            return new BlockPos(pos.func_177958_n(), surfaceY - config.field_236680_i_, pos.func_177952_p());
        }
        int y = config.field_236682_l_ == Heightmap.Type.OCEAN_FLOOR ? floorY : (config.field_236682_l_ == Heightmap.Type.WORLD_SURFACE ? surfaceY : world.func_205770_a(config.field_236682_l_, pos).func_177956_o());
        return new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
    }
}

