/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.layer;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraft.world.gen.layer.traits.IC0Transformer;
import net.tropicraft.core.common.dimension.layer.TropicraftBiomeIds;

public final class TropicraftAddWeightedSubBiomesLayer
implements IC0Transformer {
    private List<WeightedRandom.Item> biomeWeights;
    private int totalWeight;
    final int baseID;
    final int[] subBiomeIDs;
    private final Object2IntMap<WeightedRandom.Item> biomeLookup = new Object2IntOpenHashMap();

    TropicraftAddWeightedSubBiomesLayer(int baseID, int[] subBiomeIDs, WeightedRandom.Item ... weights) {
        if (weights.length > 0) {
            this.biomeWeights = Lists.newArrayList((Object[])weights);
            this.totalWeight = WeightedRandom.func_76272_a(this.biomeWeights);
            for (int i = 0; i < weights.length; ++i) {
                this.biomeLookup.put((Object)weights[i], subBiomeIDs[i]);
            }
        }
        this.baseID = baseID;
        this.subBiomeIDs = subBiomeIDs;
    }

    public static TropicraftAddWeightedSubBiomesLayer ocean(TropicraftBiomeIds biomeIds) {
        return new TropicraftAddWeightedSubBiomesLayer(biomeIds.ocean, new int[]{biomeIds.ocean, biomeIds.kelpForest}, new WeightedRandom.Item(20), new WeightedRandom.Item(4));
    }

    public int func_202726_a(INoiseRandom random, int center) {
        if (center == this.baseID) {
            if (this.biomeLookup.size() > 0) {
                return this.biomeLookup.getInt((Object)WeightedRandom.func_180166_a(this.biomeWeights, (int)random.func_202696_a(this.totalWeight)));
            }
            return this.subBiomeIDs[random.func_202696_a(this.subBiomeIDs.length)];
        }
        return center;
    }
}

