/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.layer;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public final class TropicraftBiomeIds {
    public final int ocean;
    public final int kelpForest;
    public final int land;
    public final int river;
    public final int beach;
    public final int islandMountains;
    public final int rainforestPlains;
    public final int rainforestHills;
    public final int rainforestMountains;
    public final int bambooRainforest;
    public final int mangroves;

    public TropicraftBiomeIds(Registry<Biome> biomes) {
        this.ocean = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.TROPICS_OCEAN);
        this.kelpForest = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.KELP_FOREST);
        this.land = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.TROPICS);
        this.river = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.TROPICS_RIVER);
        this.beach = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.TROPICS_BEACH);
        this.islandMountains = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.RAINFOREST_ISLAND_MOUNTAINS);
        this.rainforestPlains = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.RAINFOREST_PLAINS);
        this.rainforestHills = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.RAINFOREST_HILLS);
        this.rainforestMountains = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.RAINFOREST_MOUNTAINS);
        this.bambooRainforest = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.BAMBOO_RAINFOREST);
        this.mangroves = TropicraftBiomeIds.getId(biomes, TropicraftBiomes.MANGROVES);
    }

    private static int getId(Registry<Biome> biomes, RegistryKey<Biome> key) {
        return biomes.func_148757_b(biomes.func_230516_a_(key));
    }

    public boolean isOcean(int biome) {
        return biome == this.ocean || biome == this.kelpForest;
    }

    public boolean isRiver(int biome) {
        return biome == this.river;
    }

    public boolean isLand(int biome) {
        return biome == this.land;
    }
}

