/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.surfacebuilders;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.LazyValue;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.surfacebuilders.ConfiguredSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;
import net.minecraftforge.fml.RegistryObject;
import net.tropicraft.core.common.block.BlockTropicraftSand;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.data.WorldgenDataConsumer;
import net.tropicraft.core.common.dimension.surfacebuilders.TropicraftSurfaceBuilders;
import net.tropicraft.core.common.dimension.surfacebuilders.TropicsSurfaceBuilder;
import net.tropicraft.core.common.dimension.surfacebuilders.UnderwaterSurfaceBuilder;

public final class TropicraftConfiguredSurfaceBuilders {
    private static final LazyValue<BlockState> PURIFIED_SAND = new LazyValue(() -> ((Block)TropicraftBlocks.PURIFIED_SAND.get()).func_176223_P());
    private static final LazyValue<BlockState> UNDERWATER_PURIFIED_SAND = new LazyValue(() -> (BlockState)((BlockState)PURIFIED_SAND.func_179281_c()).func_206870_a((Property)BlockTropicraftSand.UNDERWATER, (Comparable)Boolean.valueOf(true)));
    public final ConfiguredSurfaceBuilder<?> tropics;
    public final ConfiguredSurfaceBuilder<?> sandy;
    public final ConfiguredSurfaceBuilder<?> mangrove;

    public TropicraftConfiguredSurfaceBuilders(WorldgenDataConsumer<? extends ConfiguredSurfaceBuilder<?>> worldgen) {
        Register surfaceBuilders = new Register(worldgen);
        BlockState grass = Blocks.field_196658_i.func_176223_P();
        BlockState dirt = Blocks.field_150346_d.func_176223_P();
        BlockState stone = Blocks.field_150348_b.func_176223_P();
        SurfaceBuilderConfig landConfig = new SurfaceBuilderConfig(grass, dirt, stone);
        SurfaceBuilderConfig sandyConfig = new SurfaceBuilderConfig((BlockState)PURIFIED_SAND.func_179281_c(), (BlockState)PURIFIED_SAND.func_179281_c(), (BlockState)UNDERWATER_PURIFIED_SAND.func_179281_c());
        SurfaceBuilderConfig sandyUnderwaterConfig = new SurfaceBuilderConfig((BlockState)UNDERWATER_PURIFIED_SAND.func_179281_c(), (BlockState)UNDERWATER_PURIFIED_SAND.func_179281_c(), (BlockState)UNDERWATER_PURIFIED_SAND.func_179281_c());
        TropicsSurfaceBuilder.Config tropicsConfig = new TropicsSurfaceBuilder.Config(landConfig, sandyConfig, sandyUnderwaterConfig);
        this.tropics = surfaceBuilders.register("tropics", TropicraftSurfaceBuilders.TROPICS, tropicsConfig);
        this.sandy = surfaceBuilders.register("sandy", TropicraftSurfaceBuilders.UNDERWATER, new UnderwaterSurfaceBuilder.Config(sandyConfig, landConfig, sandyUnderwaterConfig));
        this.mangrove = surfaceBuilders.register("mangrove", TropicraftSurfaceBuilders.MANGROVE, new SurfaceBuilderConfig(grass, dirt, dirt));
    }

    static final class Register {
        private final WorldgenDataConsumer<ConfiguredSurfaceBuilder<?>> worldgen;

        Register(WorldgenDataConsumer<? extends ConfiguredSurfaceBuilder<?>> worldgen) {
            this.worldgen = worldgen;
        }

        public <C extends ISurfaceBuilderConfig, S extends SurfaceBuilder<C>> ConfiguredSurfaceBuilder<?> register(String id, RegistryObject<S> surfaceBuilder, C config) {
            return this.register(id, (SurfaceBuilder)surfaceBuilder.get(), config);
        }

        public <C extends ISurfaceBuilderConfig, S extends SurfaceBuilder<C>> ConfiguredSurfaceBuilder<?> register(String id, S surfaceBuilder, C config) {
            return this.worldgen.register(new ResourceLocation("tropicraft", id), surfaceBuilder.func_242929_a(config));
        }
    }
}

