/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.surfacebuilders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class TropicsSurfaceBuilder
extends SurfaceBuilder<Config> {
    public TropicsSurfaceBuilder(Codec<Config> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, Config config) {
        SurfaceBuilderConfig selectedConfig = config.land;
        if (noise > 1.5) {
            selectedConfig = chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z) + 1 >= seaLevel ? config.sandy : config.sandyUnderwater;
        }
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)selectedConfig);
    }

    public static final class Config
    implements ISurfaceBuilderConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceBuilderConfig.field_237203_a_.fieldOf("land").forGetter(c -> c.land), (App)SurfaceBuilderConfig.field_237203_a_.fieldOf("sandy").forGetter(c -> c.sandy), (App)SurfaceBuilderConfig.field_237203_a_.fieldOf("sandy_underwater").forGetter(c -> c.sandyUnderwater)).apply((Applicative)instance, Config::new));
        public final SurfaceBuilderConfig land;
        public final SurfaceBuilderConfig sandy;
        public final SurfaceBuilderConfig sandyUnderwater;

        public Config(SurfaceBuilderConfig land, SurfaceBuilderConfig sandy, SurfaceBuilderConfig sandyUnderwater) {
            this.land = land;
            this.sandy = sandy;
            this.sandyUnderwater = sandyUnderwater;
        }

        public BlockState func_204108_a() {
            return this.land.func_204108_a();
        }

        public BlockState func_204109_b() {
            return this.land.func_204109_b();
        }
    }
}

