/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.surfacebuilders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.surfacebuilders.ISurfaceBuilderConfig;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public class UnderwaterSurfaceBuilder
extends SurfaceBuilder<Config> {
    public UnderwaterSurfaceBuilder(Codec<Config> codec) {
        super(codec);
    }

    public void buildSurface(Random random, IChunk chunk, Biome biome, int x, int z, int startHeight, double noise, BlockState defaultBlock, BlockState defaultFluid, int seaLevel, long seed, Config config) {
        SurfaceBuilderConfig selectedConfig = config.beach;
        if (startHeight > seaLevel + 5) {
            selectedConfig = config.land;
        }
        if (chunk.func_201576_a(Heightmap.Type.OCEAN_FLOOR_WG, x, z) + 1 < seaLevel) {
            selectedConfig = config.underwater;
        }
        SurfaceBuilder.field_215396_G.func_205610_a_(random, chunk, biome, x, z, startHeight, noise, defaultBlock, defaultFluid, seaLevel, seed, (ISurfaceBuilderConfig)selectedConfig);
    }

    public static final class Config
    implements ISurfaceBuilderConfig {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)SurfaceBuilderConfig.field_237203_a_.fieldOf("beach").forGetter(c -> c.beach), (App)SurfaceBuilderConfig.field_237203_a_.fieldOf("land").forGetter(c -> c.land), (App)SurfaceBuilderConfig.field_237203_a_.fieldOf("underwater").forGetter(c -> c.underwater)).apply((Applicative)instance, Config::new));
        public final SurfaceBuilderConfig beach;
        public final SurfaceBuilderConfig land;
        public final SurfaceBuilderConfig underwater;

        public Config(SurfaceBuilderConfig beach, SurfaceBuilderConfig land, SurfaceBuilderConfig underwater) {
            this.beach = beach;
            this.land = land;
            this.underwater = underwater;
        }

        public BlockState func_204108_a() {
            return this.beach.func_204108_a();
        }

        public BlockState func_204109_b() {
            return this.beach.func_204109_b();
        }
    }
}

