/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

public final class ColorMixer {
    private static ColorMixer instance = new ColorMixer();

    public static ColorMixer getInstance() {
        return instance;
    }

    public void normalizeRGBA(int[] rgba, float[] result) {
        result[0] = (float)rgba[0] / 255.0f;
        result[1] = (float)rgba[1] / 255.0f;
        result[2] = (float)rgba[2] / 255.0f;
        result[3] = (float)rgba[3] / 255.0f;
    }

    public void denormalizeRGBA(float[] rgba, int[] result) {
        result[0] = (int)(255.0f * rgba[0]);
        result[1] = (int)(255.0f * rgba[1]);
        result[2] = (int)(255.0f * rgba[2]);
        result[3] = (int)(255.0f * rgba[3]);
    }

    public void splitRGBA(long color, int[] result) {
        result[0] = (int)(color >> 24 & 0xFFL);
        result[1] = (int)(color >> 16 & 0xFFL);
        result[2] = (int)(color >> 8 & 0xFFL);
        result[3] = (int)(color & 0xFFL);
    }

    public long unsplitRGBA(int[] rgb) {
        return (rgb[0] & 0xFF) << 24 | (rgb[1] & 0xFF) << 16 | (rgb[2] & 0xFF) << 8 | rgb[3] & 0xFF;
    }

    public void normalizeRGB(int[] rgb, float[] result) {
        result[0] = (float)rgb[0] / 255.0f;
        result[1] = (float)rgb[1] / 255.0f;
        result[2] = (float)rgb[2] / 255.0f;
    }

    public void denormalizeRGB(float[] rgb, int[] result) {
        result[0] = (int)(255.0f * rgb[0]);
        result[1] = (int)(255.0f * rgb[1]);
        result[2] = (int)(255.0f * rgb[2]);
    }

    public void splitRGB(int color, int[] result) {
        result[0] = color >> 16 & 0xFF;
        result[1] = color >> 8 & 0xFF;
        result[2] = color & 0xFF;
    }

    public int unsplitRGB(int[] rgb) {
        return (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
    }

    public void convertRGBToCMYK(float[] rgb, float[] cmyk) {
        float tempC = 1.0f - rgb[0];
        float tempM = 1.0f - rgb[1];
        float tempY = 1.0f - rgb[2];
        float black = Math.min(tempC, Math.min(tempM, tempY));
        float cyan = (tempC - black) / (1.0f - black);
        float magenta = (tempM - black) / (1.0f - black);
        float yellow = (tempY - black) / (1.0f - black);
        cmyk[0] = cyan;
        cmyk[1] = magenta;
        cmyk[2] = yellow;
        cmyk[3] = black;
    }

    public void convertCMYKToRGB(float[] cmyk, float[] rgb) {
        float c = cmyk[0];
        float m = cmyk[1];
        float y = cmyk[2];
        float k = cmyk[3];
        float nc = c * (1.0f - k) + k;
        float nm = m * (1.0f - k) + k;
        float ny = y * (1.0f - k) + k;
        float r = 1.0f - nc;
        float g = 1.0f - nm;
        float b = 1.0f - ny;
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
    }

    public void convertRYBToRGB(float[] ryb, float[] rgb) {
        float mg;
        float r = ryb[0];
        float y = ryb[1];
        float b = ryb[2];
        float w = Math.min(r, Math.min(y, b));
        float my = Math.max(r -= w, Math.max(y -= w, b -= w));
        float g = Math.min(y, b);
        y -= g;
        if ((b -= g) != 0.0f && g != 0.0f) {
            b *= 2.0f;
            g *= 2.0f;
        }
        if ((mg = Math.max(r += y, Math.max(g += y, b))) != 0.0f) {
            float n = my / mg;
            r *= n;
            g *= n;
            b *= n;
        }
        rgb[0] = r += w;
        rgb[1] = g += w;
        rgb[2] = b += w;
    }

    public void convertRGBToRYB(float[] rgb, float[] ryb) {
        float my;
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float w = Math.min(r, Math.min(g, b));
        float mg = Math.max(r -= w, Math.max(g -= w, b -= w));
        float y = Math.min(r, g);
        r -= y;
        if (b != 0.0f && (g -= y) != 0.0f) {
            b /= 2.0f;
            g /= 2.0f;
        }
        if ((my = Math.max(r, Math.max(y += g, b += g))) != 0.0f) {
            float n = mg / my;
            r *= n;
            y *= n;
            b *= n;
        }
        ryb[0] = r += w;
        ryb[1] = y += w;
        ryb[2] = b += w;
    }

    public void mixCMYK(float[][] cmyks, float[] result) {
        if (cmyks.length == 0) {
            result[3] = 0.0f;
            result[2] = 0.0f;
            result[1] = 0.0f;
            result[0] = 0.0f;
            return;
        }
        if (cmyks.length == 1) {
            float[] cmyk = cmyks[0];
            result[0] = cmyk[0];
            result[1] = cmyk[1];
            result[2] = cmyk[2];
            result[3] = cmyk[3];
            return;
        }
        float cTotal = 0.0f;
        float mTotal = 0.0f;
        float yTotal = 0.0f;
        float kTotal = 0.0f;
        float cMax = 0.0f;
        float mMax = 0.0f;
        float yMax = 0.0f;
        float kMax = 0.0f;
        for (float[] cmyk : cmyks) {
            float c = cmyk[0];
            float m = cmyk[1];
            float y = cmyk[2];
            float k = cmyk[3];
            cTotal += c;
            mTotal += m;
            yTotal += y;
            kTotal += k;
            cMax = c > cMax ? c : cMax;
            mMax = m > mMax ? m : mMax;
            yMax = y > yMax ? y : yMax;
            kMax = k > kMax ? k : kMax;
        }
        int count = cmyks.length;
        float c = cTotal / (float)Math.sqrt(count + 1);
        float m = mTotal / (float)Math.sqrt(count + 1);
        float y = yTotal / (float)Math.sqrt(count + 1);
        float k = kTotal / (float)Math.sqrt(Math.sqrt(count));
        result[0] = c;
        result[1] = m;
        result[2] = y;
        result[3] = k;
    }

    public void mixRYB(float[][] rybs, float[] result) {
        if (rybs.length == 0) {
            result[2] = 0.0f;
            result[1] = 0.0f;
            result[0] = 0.0f;
            return;
        }
        if (rybs.length == 1) {
            float[] ryb = rybs[0];
            result[0] = ryb[0];
            result[1] = ryb[1];
            result[2] = ryb[2];
            return;
        }
        float rTotal = 0.0f;
        float yTotal = 0.0f;
        float bTotal = 0.0f;
        for (float[] ryb : rybs) {
            rTotal += ryb[0];
            yTotal += ryb[1];
            bTotal += ryb[2];
        }
        int count = rybs.length;
        float br = rTotal / (float)count;
        float r = rTotal / (float)Math.sqrt(Math.sqrt((float)count - br));
        br = yTotal / (float)count;
        float y = yTotal / (float)Math.sqrt(Math.sqrt((float)count - br));
        br = bTotal / (float)count;
        float b = bTotal / (float)Math.sqrt(Math.sqrt((float)count - br));
        result[0] = r;
        result[1] = y;
        result[2] = b;
    }

    public int mixRGBAsCMYK(int[] rgbs) {
        float[][] cmyks = new float[rgbs.length][];
        int[] tempRGBi = new int[3];
        float[] tempRGBf = new float[3];
        float[] tempCMYKf = new float[4];
        for (int i = 0; i < rgbs.length; ++i) {
            int rgb = rgbs[i];
            this.splitRGB(rgb, tempRGBi);
            this.normalizeRGB(tempRGBi, tempRGBf);
            this.convertRGBToCMYK(tempRGBf, tempCMYKf);
            cmyks[i] = tempCMYKf;
        }
        this.mixCMYK(cmyks, tempCMYKf);
        this.convertCMYKToRGB(tempCMYKf, tempRGBf);
        this.denormalizeRGB(tempRGBf, tempRGBi);
        int rgb = this.unsplitRGB(tempRGBi);
        return rgb;
    }

    public int mixRGBAsRYB(int[] rgbs) {
        float[][] rybs = new float[rgbs.length][];
        int[] tempRGBi = new int[3];
        float[] tempRGBf = new float[3];
        float[] tempRYBf = new float[3];
        for (int i = 0; i < rgbs.length; ++i) {
            int rgb = rgbs[i];
            this.splitRGB(rgb, tempRGBi);
            this.normalizeRGB(tempRGBi, tempRGBf);
            this.convertRGBToRYB(tempRGBf, tempRYBf);
            rybs[i] = tempRYBf;
        }
        this.mixRYB(rybs, tempRYBf);
        this.convertRYBToRGB(tempRYBf, tempRGBf);
        this.denormalizeRGB(tempRGBf, tempRGBi);
        int rgb = this.unsplitRGB(tempRGBi);
        return rgb;
    }

    public int alphaBlendRGBA(int bg, int fg, float fgAlpha) {
        float bgRed = (float)(bg >> 16 & 0xFF) / 255.0f;
        float bgGreen = (float)(bg >> 8 & 0xFF) / 255.0f;
        float bgBlue = (float)(bg & 0xFF) / 255.0f;
        float fgRed = (float)(fg >> 16 & 0xFF) / 255.0f;
        float fgGreen = (float)(fg >> 8 & 0xFF) / 255.0f;
        float fgBlue = (float)(fg & 0xFF) / 255.0f;
        float outRed = fgRed * fgAlpha + bgRed * (1.0f - fgAlpha);
        float outGreen = fgGreen * fgAlpha + bgGreen * (1.0f - fgAlpha);
        float outBlue = fgBlue * fgAlpha + bgBlue * (1.0f - fgAlpha);
        int outRedi = (int)(outRed * 255.0f);
        int outGreeni = (int)(outGreen * 255.0f);
        int outBluei = (int)(outBlue * 255.0f);
        return (outRedi & 0xFF) << 16 | (outGreeni & 0xFF) << 8 | outBluei & 0xFF;
    }
}

