/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.drinks.DrinkAction;
import net.tropicraft.core.common.drinks.DrinkActionPotion;
import net.tropicraft.core.common.entity.placeable.ChairEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class Drink {
    public static final Int2ObjectMap<Drink> DRINKS = new Int2ObjectOpenHashMap();
    public static final Drink LEMONADE = new Drink(1, 16440129, "lemonade", TextFormatting.YELLOW).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 1));
    public static final Drink LIMEADE = new Drink(2, 8710282, "limeade", TextFormatting.GREEN).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 1));
    public static final Drink ORANGEADE = new Drink(3, 15973942, "orangeade", TextFormatting.GOLD).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 1));
    public static final Drink CAIPIRINHA = new Drink(4, 9764662, "caipirinha", TextFormatting.GREEN).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 1)).setHasUmbrella(true);
    public static final Drink BLACK_COFFEE = new Drink(5, 6833196, "black_coffee", TextFormatting.WHITE).addAction(new DrinkActionPotion(Effects.field_76428_l, 5, 1)).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 2));
    public static final Drink PINA_COLADA = new Drink(6, 0xEFEFEF, "pina_colada", TextFormatting.GOLD).addAction(new DrinkActionPotion(Effects.field_76431_k, 10, 0)).addAction(new DrinkAction(){

        @Override
        public void onDrink(PlayerEntity player) {
            if (!player.field_70170_p.field_72995_K && this.isSunset(player.field_70170_p) && player.func_184187_bx() instanceof ChairEntity) {
                TropicraftDimension.teleportPlayer((ServerPlayerEntity)player, TropicraftDimension.WORLD);
            }
        }

        private boolean isSunset(World world) {
            long timeDay = world.func_72820_D() % 24000L;
            return timeDay > 12200L && timeDay < 14000L;
        }
    }).setAlwaysEdible(true);
    public static final Drink COCONUT_WATER = new Drink(7, 0xDFDFDF, "coconut_water", TextFormatting.WHITE).addAction(new DrinkActionPotion(Effects.field_76424_c, 5, 1));
    public static final Drink MAI_TAI = new Drink(8, 16742190, "mai_tai", TextFormatting.GOLD).addAction(new DrinkActionPotion(Effects.field_76431_k, 5, 0));
    public static final Drink COCKTAIL = new Drink(9, 0, "cocktail", TextFormatting.WHITE);
    public int drinkId;
    public int color;
    public String name;
    public boolean alwaysEdible;
    public boolean hasUmbrella;
    public TextFormatting textFormatting;
    public List<DrinkAction> actions = new ArrayList<DrinkAction>();

    public Drink(int id, int color, String name, TextFormatting textFormatting) {
        DRINKS.put(id, (Object)this);
        this.drinkId = id;
        this.color = color;
        this.name = name;
        this.textFormatting = textFormatting;
        this.alwaysEdible = true;
    }

    public Drink setHasUmbrella(boolean has) {
        this.hasUmbrella = has;
        return this;
    }

    public Drink setAlwaysEdible(boolean edible) {
        this.alwaysEdible = edible;
        return this;
    }

    public Drink addAction(DrinkAction action) {
        this.actions.add(action);
        return this;
    }

    public void onDrink(PlayerEntity player) {
        for (DrinkAction action : this.actions) {
            action.onDrink(player);
        }
    }

    public static boolean isDrink(Item item) {
        return TropicraftItems.COCKTAILS.values().stream().anyMatch(ri -> ri.get() == item);
    }
}

