/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Drinks;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.item.CocktailItem;

public final class MixerRecipes {
    private static Map<Drink, Ingredient[]> drinkToIngredientsMap = new HashMap<Drink, Ingredient[]>();
    private static Map<Drink, Item> drinkToSpecialItemMap = new HashMap<Drink, Item>();

    private MixerRecipes() {
    }

    public static void addMixerRecipes() {
        MixerRecipes.registerMixerRecipe(Drink.LIMEADE, Ingredient.lime, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.CAIPIRINHA, Ingredient.lime, Ingredient.sugarcane, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.ORANGEADE, Ingredient.orange, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.LEMONADE, Ingredient.lemon, Ingredient.sugar, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.BLACK_COFFEE, Ingredient.roastedCoffeeBean, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.PINA_COLADA, Ingredient.pineappleCubes, Ingredient.coconutChunk);
        MixerRecipes.registerMixerRecipe(Drink.PINA_COLADA, Ingredient.pineappleCubes, Ingredient.coconut);
        MixerRecipes.registerMixerRecipe(Drink.PINA_COLADA, Ingredient.pineapple, Ingredient.coconutChunk);
        MixerRecipes.registerMixerRecipe(Drink.PINA_COLADA, Ingredient.pineapple, Ingredient.coconut);
        MixerRecipes.registerMixerRecipe(Drink.COCONUT_WATER, Ingredient.coconut, Ingredient.waterBucket);
        MixerRecipes.registerMixerRecipe(Drink.MAI_TAI, Ingredient.orange, Ingredient.lime, Ingredient.waterBucket);
    }

    private static void registerMixerRecipe(Drink result, Ingredient ... ingredients) {
        Drinks.register(new MixerRecipe(result, ingredients));
        drinkToIngredientsMap.put(result, ingredients);
    }

    public static void setDrinkItem(Drink drink, CocktailItem item) {
        drinkToSpecialItemMap.put(drink, item);
    }

    public static ItemStack getItemStack(Drink drink) {
        if (drinkToSpecialItemMap.containsKey(drink)) {
            return new ItemStack((IItemProvider)drinkToSpecialItemMap.get(drink));
        }
        NonNullList stack = NonNullList.func_191196_a();
        for (Ingredient i : drinkToIngredientsMap.get(drink)) {
            stack.add((Object)new ItemStack((IItemProvider)i.getIngredientItem()));
        }
        return Drinks.getResult((NonNullList<ItemStack>)stack);
    }

    public static boolean isValidRecipe(NonNullList<ItemStack> ingredientStacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ItemStack stack : ingredientStacks) {
            Ingredient ingredient = Ingredient.findMatchingIngredient(stack);
            if (ingredient == null) {
                return false;
            }
            ingredients.add(ingredient);
            for (MixerRecipe recipe : Drinks.getRecipes()) {
                HashSet<Ingredient> recipeIngredientSet = new HashSet<Ingredient>(Arrays.asList(recipe.getIngredients()));
                if (!ingredients.equals(recipeIngredientSet)) continue;
                return true;
            }
        }
        return false;
    }

    public static Drink getDrink(NonNullList<ItemStack> ingredientStacks) {
        HashSet<Ingredient> ingredients = new HashSet<Ingredient>();
        for (ItemStack stack : ingredientStacks) {
            Ingredient ingredient = Ingredient.findMatchingIngredient(stack);
            if (ingredient == null) {
                return null;
            }
            ingredients.add(ingredient);
            for (MixerRecipe recipe : Drinks.getRecipes()) {
                HashSet<Ingredient> recipeIngredientSet = new HashSet<Ingredient>(Arrays.asList(recipe.getIngredients()));
                if (!ingredients.equals(recipeIngredientSet)) continue;
                return recipe.getCraftingResult();
            }
        }
        return null;
    }
}

